/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules.js;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jayeson.model.IDataFilterRule;
import jayeson.model.filterrules.js.FilterRuleDeserializer;
import jayeson.model.filterrules.js.JSonFilterRuleType;
import jayeson.model.filterrules.js.JSonFilterRuleTypeMap;

public class DefaultFilterRuleDeserializer
implements FilterRuleDeserializer {
    public static final String NAME_SPACE_FIELD_NAME = "namespace";
    public static final String FILTER_RULES_FIELD_NAME = "filterRules";
    public static final String CLASS_TYPE_FIELD_NAME = "ruleType";
    public static final String SPORT_TYPE_FIELD_NAME = "sportType";
    public static final String CLASS_PROPERTY_NAME = "__c__";
    private JSonFilterRuleTypeMap defaultMapper;
    private Map<String, JSonFilterRuleTypeMap> ruleMapper;
    private ObjectMapper mapper;

    public DefaultFilterRuleDeserializer(JSonFilterRuleTypeMap defaultMap) {
        if (defaultMap == null) {
            throw new RuntimeException("The default type mapper cannot be null!");
        }
        this.mapper = new ObjectMapper();
        this.defaultMapper = defaultMap;
        this.ruleMapper = new HashMap<String, JSonFilterRuleTypeMap>();
    }

    public void clearTypeMappers() {
        this.ruleMapper.clear();
    }

    public void addTypeMapper(JSonFilterRuleTypeMap typeMap) {
        String namespace = typeMap.getRuleNameSpace();
        if (!this.ruleMapper.containsKey(namespace)) {
            this.ruleMapper.put(namespace, typeMap);
        }
    }

    public void removeTypeMapper(JSonFilterRuleTypeMap typeMap) {
        String namespace = typeMap.getRuleNameSpace();
        if (this.ruleMapper.containsKey(namespace)) {
            this.ruleMapper.remove(namespace);
        }
    }

    public void removeTypeMapperByNamespace(String namespace) {
        if (this.ruleMapper.containsKey(namespace)) {
            this.ruleMapper.remove(namespace);
        }
    }

    public Collection<JSonFilterRuleTypeMap> getTypeMappers() {
        ArrayList<JSonFilterRuleTypeMap> mappers = new ArrayList<JSonFilterRuleTypeMap>();
        mappers.addAll(this.ruleMapper.values());
        return mappers;
    }

    @Override
    public Collection<IDataFilterRule> parse(String content) {
        try {
            ArrayList<IDataFilterRule> rules = new ArrayList<IDataFilterRule>();
            JsonNode jNode = this.mapper.readTree(content);
            String namespace = "";
            try {
                namespace = jNode.get(NAME_SPACE_FIELD_NAME).asText();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot deserialize the message. Invalid namespace.", e);
            }
            JSonFilterRuleTypeMap map = this.ruleMapper.get(namespace);
            if (map == null) {
                map = this.defaultMapper;
            }
            JsonNode arrayNode = null;
            try {
                arrayNode = jNode.get(FILTER_RULES_FIELD_NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot deserialize the message. Invalid filter rules.", e);
            }
            if (arrayNode != null && arrayNode.isArray()) {
                for (JsonNode node : arrayNode) {
                    int vType = node.get(CLASS_TYPE_FIELD_NAME).asInt();
                    JSonFilterRuleType frType = map.getFromValue(vType);
                    Class<? extends IDataFilterRule> targetClass = frType.mappedClass();
                    if (targetClass == null) continue;
                    ((ObjectNode)node).put(CLASS_PROPERTY_NAME, targetClass.getName());
                    rules.add((IDataFilterRule)this.mapper.treeToValue((TreeNode)node, targetClass));
                }
            }
            return rules;
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Cannot deserialize the message. There is a problem reading the Json.", ex);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot deserialize the message.", e);
        }
    }

    @Override
    public Collection<String> parseToClassNames(String content) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            ArrayList<String> rules = new ArrayList<String>();
            JsonNode jNode = mapper.readTree(content);
            String namespace = "";
            try {
                namespace = jNode.get(NAME_SPACE_FIELD_NAME).asText();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot deserialize the message. Invalid namespace.", e);
            }
            JSonFilterRuleTypeMap map = this.ruleMapper.get(namespace);
            if (map == null) {
                map = this.defaultMapper;
            }
            JsonNode arrayNode = null;
            try {
                arrayNode = jNode.get(FILTER_RULES_FIELD_NAME);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot deserialize the message. Invalid filter rules.", e);
            }
            if (arrayNode != null && arrayNode.isArray()) {
                for (JsonNode node : arrayNode) {
                    int vType = node.asInt();
                    JSonFilterRuleType frType = map.getFromValue(vType);
                    Class<? extends IDataFilterRule> targetClass = frType.mappedClass();
                    rules.add(targetClass.getName());
                }
            }
            return rules;
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Cannot deserialize the message. There is a problem reading the Json.", ex);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot deserialize the message.", e);
        }
    }
}

