/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static Logger log = LoggerFactory.getLogger(Client.class);

    public void connect(String host, int port) {
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        String HOST = host;
        int PORT = port;
        try {
            log.debug("Connecting to " + HOST + ":" + PORT);
            echoSocket = new Socket(HOST, PORT);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
            log.debug("Connected");
            String input = "{\"type\":\"SUBSCRIBE\"}";
            log.debug("Transmitting.....");
            out.println(input);
            StringBuilder buf = new StringBuilder();
            int open = 0;
            while (input != null) {
                char[] bb = new char[1];
                in.read(bb, 0, 1);
                buf.append(bb[0]);
                if (bb[0] == '{') {
                    ++open;
                }
                if (bb[0] == '}') {
                    --open;
                }
                if (open != 0) continue;
                String msg = this.beautifyMsg(buf.toString());
                Client.processMessage(msg);
                buf = new StringBuilder();
            }
            out.close();
            in.close();
            echoSocket.close();
        }
        catch (UnknownHostException e) {
            log.debug("Don't know about host:" + HOST);
            System.exit(1);
        }
        catch (IOException e) {
            log.debug("Couldn't get I/O for the connection to:" + HOST);
            System.exit(1);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String beautifyMsg(String msg) throws JSONException {
        JSONObject json = new JSONObject(msg);
        return json.toString(4);
    }

    public static void processMessage(String msg) {
        log.info("Received msg: \n" + msg + "\n");
    }
}

