/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server;

import com.google.inject.Inject;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import jayeson.service.feedwrapper.server.netty.ClientInitializer;

public class Server {
    private Channel serverChannel;
    private final ClientInitializer clientInitializer;

    @Inject
    public Server(ClientInitializer clientInitializer) {
        this.clientInitializer = clientInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String host, int port) throws InterruptedException {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)this.clientInitializer);
            this.serverChannel = host != null ? b.bind(host, port).sync().channel() : b.bind(port).sync().channel();
            this.serverChannel.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public void stop() {
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
    }
}

