/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import jayeson.lib.delivery.api.SslConfig;
import jayeson.lib.delivery.module.subscriber.ScopedSubscriberConfig;
import jayeson.lib.delivery.module.subscriber.StandAloneSubscriberModule;
import jayeson.lib.delivery.module.subscriber.SubscriberConfig;
import jayeson.lib.sports.client.SportsConfig;
import jayeson.lib.sports.core.TTLConfig;
import jayeson.lib.sports.module.Module;
import jayeson.lib.sports.receive.SportsFeedInConfig;
import jayeson.lib.streamfinder.StreamfinderConfig;
import jayeson.service.feedwrapper.server.ClientSubscriber;
import jayeson.service.feedwrapper.server.ClientSubscriberFactory;
import jayeson.service.feedwrapper.server.ClientSubscriberImpl;
import jayeson.service.feedwrapper.server.netty.ClientHandler;
import jayeson.service.feedwrapper.server.protocol.JsonCodecModule;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

public class ServerModule
extends AbstractModule {
    protected static final String defaultFileName = System.getProperty("config", "libSportConfig.json");
    protected static final String systemVar = "ConfigurationFile";

    protected void configure() {
        SportsConfig config = (SportsConfig)JacksonConfig.readConfig((String)defaultFileName, (String)systemVar, SportsConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
        this.install(new FactoryModuleBuilder().implement(ClientSubscriber.class, ClientSubscriberImpl.class).build(ClientSubscriberFactory.class));
        SubscriberConfig subConfig = this.scopeSubscriberConfig(config);
        StandAloneSubscriberModule subscriberModule = new StandAloneSubscriberModule(subConfig);
        Module.Client clientModule = new Module.Client(this.sportsFeedInConfig(config));
        this.install((Module)subscriberModule);
        this.install((Module)clientModule);
        this.bind(ClientHandler.class).asEagerSingleton();
        this.install((Module)new JsonCodecModule());
    }

    private List<String> constructStream(SportsConfig config) {
        int count;
        StringBuilder constructStream = new StringBuilder();
        if (config.getSportFilter() != null) {
            if (config.getSportFilter().isEmpty()) {
                constructStream.append(".*");
            } else {
                count = 0;
                for (String sport : config.getSportFilter()) {
                    if (config.getSportFilter().size() > 1 && count == 0) {
                        constructStream.append("(" + sport + "|");
                    }
                    if (config.getSportFilter().size() > 1 && count + 1 < config.getSportFilter().size() && count > 0) {
                        constructStream.append(sport + "|");
                    }
                    if (config.getSportFilter().size() == 1) {
                        constructStream.append(sport);
                    }
                    if (config.getSportFilter().size() > 1 && count + 1 == config.getSportFilter().size()) {
                        constructStream.append(sport + ")");
                    }
                    ++count;
                }
            }
        } else {
            constructStream.append(".*");
        }
        if (config.getBookFilter() != null) {
            if (config.getBookFilter().isEmpty()) {
                if (config.getSportFilter() != null && !config.getSportFilter().isEmpty()) {
                    constructStream.append(".*");
                }
            } else {
                count = 0;
                for (String sportBook : config.getBookFilter()) {
                    if (config.getBookFilter().size() > 1 && count == 0) {
                        constructStream.append("_(" + sportBook + "|");
                    }
                    if (config.getBookFilter().size() > 1 && count + 1 < config.getBookFilter().size() && count > 0) {
                        constructStream.append(sportBook + "|");
                    }
                    if (config.getBookFilter().size() == 1) {
                        constructStream.append("_" + sportBook);
                    }
                    if (config.getBookFilter().size() > 1 && count + 1 == config.getBookFilter().size()) {
                        constructStream.append(sportBook + ")");
                    }
                    ++count;
                }
            }
        } else if (config.getSportFilter() != null && !config.getSportFilter().isEmpty()) {
            constructStream.append(".*");
        }
        if (config.getOddTypeFilter() != null) {
            if (config.getOddTypeFilter().isEmpty()) {
                if (config.getBookFilter() != null && !config.getBookFilter().isEmpty()) {
                    constructStream.append(".*");
                }
            } else {
                count = 0;
                for (String oddType : config.getOddTypeFilter()) {
                    if (config.getOddTypeFilter().size() > 1 && count == 0) {
                        constructStream.append("_(" + oddType + "|");
                    }
                    if (config.getOddTypeFilter().size() > 1 && count + 1 < config.getOddTypeFilter().size() && count > 0) {
                        constructStream.append(oddType + "|");
                    }
                    if (config.getOddTypeFilter().size() == 1) {
                        constructStream.append("_" + oddType);
                    }
                    if (config.getOddTypeFilter().size() > 1 && count + 1 == config.getOddTypeFilter().size()) {
                        constructStream.append(oddType + ")");
                    }
                    ++count;
                }
            }
        } else if (config.getBookFilter() != null && !config.getBookFilter().isEmpty()) {
            constructStream.append(".*");
        }
        return Arrays.asList(constructStream.toString());
    }

    private SubscriberConfig scopeSubscriberConfig(SportsConfig config) {
        SubscriberConfig subConfig = new SubscriberConfig();
        ScopedSubscriberConfig scopeConfig = new ScopedSubscriberConfig();
        StreamfinderConfig sfConf = new StreamfinderConfig(config.getUsername(), config.getPassword(), config.getUri(), "");
        List<String> streamList = this.constructStream(config);
        if (streamList == null) {
            streamList = Arrays.asList(".*");
        }
        HashMap<String, List<String>> discMap = new HashMap<String, List<String>>();
        discMap.put("70", streamList);
        scopeConfig.setDiscoveryStreams(discMap);
        scopeConfig.setSfConfig(sfConf);
        subConfig.setAuthDataRenewIntervalMs(30000L);
        HashMap<String, ScopedSubscriberConfig> scopeMap = new HashMap<String, ScopedSubscriberConfig>();
        if (config.getScope() == null || config.getScope().isEmpty()) {
            scopeMap.put("unity", scopeConfig);
        } else {
            scopeMap.put(config.getScope(), scopeConfig);
        }
        subConfig.setScopes(scopeMap);
        SslConfig sslConfig = new SslConfig();
        sslConfig.setEnableSelfSignedCert(true);
        subConfig.setSslConfig(sslConfig);
        return subConfig;
    }

    private SportsFeedInConfig sportsFeedInConfig(SportsConfig config) {
        SportsFeedInConfig sportsConfig = new SportsFeedInConfig();
        TTLConfig ttlConfigJson = new TTLConfig();
        if (config.getTtlConfig() != null) {
            ttlConfigJson = config.getTtlConfig();
        } else {
            ttlConfigJson.setEnableTtl(true);
            ttlConfigJson.setEarlyttl(30000);
            ttlConfigJson.setLivettl(5000);
            ttlConfigJson.setTodayttl(15000);
        }
        sportsConfig.setTtlConfig(ttlConfigJson);
        sportsConfig.setExcludeRateId(config.getExcludeRateId().booleanValue());
        return sportsConfig;
    }
}

