/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.netty;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import jayeson.service.feedwrapper.server.netty.ClientHandler;
import jayeson.service.feedwrapper.server.netty.RequestDecoder;
import jayeson.service.feedwrapper.server.protocol.JsonObjectDecoder;

public class ClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final ClientHandler clientHandler;

    @Inject
    public ClientInitializer(ClientHandler clientHandler) {
        this.clientHandler = clientHandler;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new JsonObjectDecoder()});
        pipeline.addLast(new ChannelHandler[]{new RequestDecoder()});
        pipeline.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
        pipeline.addLast(new ChannelHandler[]{this.clientHandler});
    }
}

