/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.netty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;
import jayeson.lib.sports.client.PushDelta;
import jayeson.service.feedwrapper.server.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
extends Client {
    private static Logger log = LoggerFactory.getLogger(NettyClient.class);
    private final ChannelHandlerContext ctx;
    private final ObjectMapper mapper;

    @Inject
    public NettyClient(String clientId, ChannelHandlerContext ctx, ObjectMapper map) {
        this.ctx = ctx;
        this.mapper = map;
        this.setId(clientId);
    }

    @Override
    public CompletableFuture<Boolean> send(PushDelta<?> message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        final CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        String sendingMsg = null;
        try {
            sendingMsg = this.mapper.writeValueAsString(message);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot serialize object " + message, (Throwable)e);
            result.completeExceptionally(e);
            return result;
        }
        ChannelFuture future = this.ctx.writeAndFlush((Object)sendingMsg);
        future.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.cause() != null) {
                    result.completeExceptionally(future.cause());
                } else {
                    result.complete(future.isSuccess());
                }
            }
        });
        return result;
    }

    @Override
    public void disconnect() {
        this.ctx.close();
    }
}

