/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import jayeson.lib.feed.basketball.BasketballRecord;

public class BasketballRecordEncoder
extends StdSerializer<BasketballRecord> {
    private static final long serialVersionUID = 3276958449322103017L;

    public BasketballRecordEncoder() {
        this(null);
    }

    public BasketballRecordEncoder(Class<BasketballRecord> t) {
        super(t);
    }

    public void serialize(BasketballRecord value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("source", value.source());
        gen.writeStringField("matchId", value.matchId());
        gen.writeStringField("eventId", value.eventId());
        gen.writeNumberField("id", value.id());
        gen.writeStringField("oddType", value.oddType().toString());
        gen.writeStringField("oddFormat", value.oddFormat().toString());
        gen.writeStringField("lbType", value.lbType().toString());
        gen.writeObjectField("timeType", (Object)value.timeType().toString());
        gen.writeNumberField("pivotValue", value.pivotValue());
        gen.writeStringField("pivotBias", value.pivotBias().toString());
        gen.writeStringField("pivotType", value.pivotType().toString());
        gen.writeBooleanField("isSwapped", value.isSwapped());
        gen.writeNumberField("rateOver", value.rateOver());
        gen.writeNumberField("rateUnder", value.rateUnder());
        gen.writeNumberField("rateEqual", value.rateEqual());
        if (value.rateOverId() != null) {
            gen.writeStringField("rateOverId", value.rateOverId());
        }
        if (value.rateUnderId() != null) {
            gen.writeStringField("rateUnderId", value.rateUnderId());
        }
        if (value.rateEqualId() != null) {
            gen.writeStringField("rateEqualId", value.rateEqualId());
        }
        gen.writeEndObject();
    }
}

