/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import jayeson.lib.feed.tennis.TennisEventState;
import jayeson.lib.feed.tennis.TennisStats;

public class TennisEventStateEncoder
extends StdSerializer<TennisEventState> {
    private static final long serialVersionUID = -5120234051270794504L;

    public TennisEventStateEncoder() {
        this(null);
    }

    public TennisEventStateEncoder(Class<TennisEventState> t) {
        super(t);
    }

    public void serialize(TennisEventState value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("source", value.partitionKey().source());
        gen.writeBooleanField("isADV", ((TennisStats)value.statsOf(0)).getAv());
        gen.writeStringField("currentPointType", ((TennisStats)value.statsOf(0)).getScoreType().toString());
        gen.writeFieldName("eventStats");
        gen.writeStartArray();
        if (((TennisStats)value.statsOf(0)).getCurrentPointWon() != -1) {
            for (int i = 0; i < 2; ++i) {
                gen.writeStartObject();
                if (((TennisStats)value.statsOf(i)).getCurrentPointWon() != -1) {
                    gen.writeNumberField("p" + (i + 1) + "CurrentPoint", ((TennisStats)value.statsOf(i)).getCurrentPointWon());
                }
                if (((TennisStats)value.statsOf(i)).getCurrentSetWon() != -1) {
                    gen.writeNumberField("p" + (i + 1) + "CurrentSetWon", ((TennisStats)value.statsOf(i)).getCurrentSetWon());
                }
                for (int x = 1; x <= 5; ++x) {
                    if (((TennisStats)value.statsOf(i)).getGameWon(x) == -1) continue;
                    gen.writeNumberField("p" + (i + 1) + "TotalGamesWoninS" + x, ((TennisStats)value.statsOf(i)).getGameWon(x));
                }
                gen.writeEndObject();
            }
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

