/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import jayeson.lib.feed.tennis.TennisRecord;

public class TennisRecordEncoder
extends StdSerializer<TennisRecord> {
    private static final long serialVersionUID = -5120234051270794504L;

    public TennisRecordEncoder() {
        this(null);
    }

    public TennisRecordEncoder(Class<TennisRecord> t) {
        super(t);
    }

    public void serialize(TennisRecord value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("source", value.source());
        gen.writeStringField("matchId", value.matchId());
        gen.writeStringField("eventId", value.eventId());
        gen.writeNumberField("id", value.id());
        gen.writeStringField("oddType", value.oddType().toString());
        gen.writeStringField("oddFormat", value.oddFormat().toString());
        gen.writeStringField("lbType", value.lbType().toString());
        gen.writeObjectField("timeType", (Object)value.timeType());
        gen.writeNumberField("pivotValue", value.pivotValue());
        gen.writeStringField("pivotBias", value.pivotBias().toString());
        gen.writeStringField("pivotType", value.pivotType().toString());
        gen.writeBooleanField("isSwapped", value.isSwapped());
        gen.writeNumberField("rateOver", value.rateOver());
        gen.writeNumberField("rateUnder", value.rateUnder());
        gen.writeNumberField("rateEqual", value.rateEqual());
        if (value.rateOverId() != null) {
            gen.writeStringField("rateOverId", value.rateOverId());
        }
        if (value.rateUnderId() != null) {
            gen.writeStringField("rateUnderId", value.rateUnderId());
        }
        if (value.rateEqualId() != null) {
            gen.writeStringField("rateEqualId", value.rateEqualId());
        }
        gen.writeEndObject();
    }
}

