/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed.message;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.namefeed.codec.NameDeleteMessageClass;
import jayeson.lib.namefeed.codec.NameFullMessageClass;
import jayeson.lib.namefeed.codec.NameRefreshMessageClass;
import jayeson.lib.namefeed.codec.NameResetMessageClass;

@Singleton
public class NameFeedMessageGroup
implements IMessageGroup {
    public final NameFullMessageClass EVENT_FULL_NAME = new NameFullMessageClass(this, 0);
    public final NameDeleteMessageClass EVENT_DELETE_NAME = new NameDeleteMessageClass(this, 1);
    public final NameResetMessageClass EVENT_RESET_NAME = new NameResetMessageClass(this, 2);
    public final NameRefreshMessageClass EVENT_REFRESH_NAME = new NameRefreshMessageClass(this, 3);
    final IMessageClass<?>[] mClasses;

    @Inject
    public NameFeedMessageGroup() {
        List<IMessageClass> allClasses = Arrays.asList(new IMessageClass[]{this.EVENT_FULL_NAME, this.EVENT_DELETE_NAME, this.EVENT_RESET_NAME, this.EVENT_REFRESH_NAME});
        int largestId = allClasses.stream().map(IMessageClass::id).mapToInt(Byte::intValue).reduce(Integer::max).getAsInt();
        this.mClasses = new IMessageClass[largestId + 1];
        allClasses.stream().forEach(mc -> {
            this.mClasses[mc.id()] = mc;
        });
    }

    public List<IMessageClass<?>> allClasses() {
        return Arrays.asList(this.mClasses);
    }

    public IMessageClass<?> classById(byte id) {
        return this.mClasses[id];
    }

    public byte id() {
        return 30;
    }
}

