/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import java.util.Collection;
import java.util.List;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.codec.AbstractMessageClass;
import jayeson.lib.sports.codec.EncodeAction;
import jayeson.lib.sports.codec.ICodec;
import jayeson.lib.sports.codec.PartitionCodec;
import jayeson.lib.sports.codec.SportCodecs;
import jayeson.lib.sports.codec.StringPool;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.protobuf.Sports;

public class UpdateOddMessageClass
extends AbstractMessageClass {
    public UpdateOddMessageClass(IMessageGroup group, int id, PartitionCodec partitionCodec, SportCodecs sportCodec) {
        super(group, id, partitionCodec, sportCodec);
    }

    @Override
    public Sports.DataMessage.Builder write(IndexedSnapshot input, ICodec codec, StringPool pool, Boolean encodeOddId, PartitionKey key) throws Exception {
        Sports.DataMessage.Builder output = Sports.DataMessage.newBuilder();
        Sports.Odds.Builder odds = Sports.Odds.newBuilder();
        for (IBetMatch match : input.matches(key.sportType())) {
            for (IBetEvent event : match.events()) {
                for (IBetRecord rec : event.getRecords(key.source())) {
                    Sports.BaseRecord pbufOdd = codec.encodeRecord(rec, pool, EncodeAction.UPDATE, encodeOddId, key);
                    if (pbufOdd == null) continue;
                    odds.addOdds(pbufOdd);
                }
            }
        }
        output.setOdds(odds);
        return output;
    }

    @Override
    public Collection<IBetMatch> read(Sports.DataMessage pbuf, ICodec codec, List<String> pool, PartitionKey partition) {
        return codec.decodeRecord(pbuf.getOdds().getOddsList(), pool, EncodeAction.UPDATE, partition);
    }
}

