/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import jayeson.lib.sports.core.AbstractFSRepo;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.core.ISnapshotHandler;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.TTLRemoveCheck;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.MergeableWrapper;
import jayeson.lib.sports.datastructure.Outgoing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRepoImpl
extends AbstractFSRepo
implements FSRepo {
    private static Logger log = LoggerFactory.getLogger(FSRepoImpl.class);
    private IndexedSnapshot head;
    private MergeableWrapper result;
    private String outputStreamName;
    private ReentrantLock lock = new ReentrantLock(true);
    private SportsFeedMessageGroup sportsGroup;
    private CompletableFuture<Boolean> fssEndReceived;
    private DeltaTransformingLogic transformingLogic;
    private boolean isAggregated;

    @Inject
    public FSRepoImpl(@Assisted String outputStreamName, @Assisted boolean isAggregated, SportsFeedMessageGroup sportsGroup, DeltaTransformingLogic transformingLogic) {
        this.outputStreamName = outputStreamName;
        this.sportsGroup = sportsGroup;
        this.fssEndReceived = new CompletableFuture();
        this.isAggregated = isAggregated;
        this.transformingLogic = transformingLogic;
        log.info("Initializing FSRepo with {}", (Object)outputStreamName);
    }

    @Override
    public synchronized Collection<DeltaOutgoing> appendSnapshot(String stream, Function<IndexedSnapshot, MergeableWrapper> logic) {
        try {
            this.freezeSnapshot("");
            if (this.head == null) {
                this.result = logic.apply(null);
                this.head = this.result.getAfter();
            } else {
                this.result = logic.apply(this.head);
                this.head = this.result.getAfter();
            }
        }
        finally {
            this.unFreezeSnapshot("");
        }
        return this.result.getDeltaOut();
    }

    @Override
    public IndexedSnapshot getSnapshot() {
        if (this.head == null) {
            return new IndexedSnapshotImpl();
        }
        return this.head;
    }

    @Override
    public IndexedSnapshot getSnapshot(String streamName) {
        return this.getSnapshot();
    }

    @Override
    public void freezeSnapshot(String streamName) {
        if (this.lock.getHoldCount() > 0) {
            log.warn("Lock already got by this thread.Call unlock multiple times", (Object)streamName);
        }
        this.lock.lock();
    }

    @Override
    public void unFreezeSnapshot(String streamName) {
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ex) {
            log.error("Error while unfreezing lock ", (Throwable)ex);
        }
    }

    @Override
    public List<TTLRemoveCheck> getTtlRemoveSnapshot() {
        if (this.head == null) {
            return Arrays.asList(new TTLRemoveCheck[0]);
        }
        TTLRemoveCheck tl = new TTLRemoveCheck(null, this.head.getPartitions(), this.outputStreamName, this.transformingLogic);
        return Arrays.asList(tl);
    }

    @Override
    public void push(Outgoing outGoing) {
        for (ISnapshotHandler handler : this.getRegisteredHandlers()) {
            handler.process(this.outputStreamName, outGoing);
        }
    }

    @Override
    public void push(String stream, Outgoing outGoing) {
        if (outGoing.msgType() != this.sportsGroup.FULLSNAPSHOT_START) {
            if (outGoing.msgType() == this.sportsGroup.FULLSNAPSHOT_END) {
                this.fssEndReceived.complete(true);
            } else {
                this.push(outGoing);
            }
        }
    }

    @Override
    public CompletableFuture<Boolean> isReady(String stream) {
        return this.fssEndReceived;
    }

    @Override
    public boolean isAggregated() {
        return this.isAggregated;
    }
}

