/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.TTLConfig;
import jayeson.lib.sports.core.TTLRemoveCheck;
import jayeson.lib.sports.core.TTLRestoreCheck;
import jayeson.lib.sports.datastructure.Incoming;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.TTLWrapper;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RecycleBin {
    private static Logger log = LoggerFactory.getLogger(RecycleBin.class);
    private TTLConfig ttlConfig;
    private ConcurrentHashMap<PartitionKey, IndexedSnapshot> expiredMatches;
    private ConcurrentHashMap<PartitionKey, Long> keyRemovedTimeEpochMillis;
    private ReentrantLock lock = new ReentrantLock(true);
    ConcurrentHashMap<PartitionKey, Boolean> ttlStatus;
    SportsFeedMessageGroup sportsFeedMessageGroup;
    private DeltaTransformingLogic transformingLogic;

    @Inject
    public RecycleBin(TTLConfig ttlConfig, SportsFeedMessageGroup grp, DeltaTransformingLogic transformingLogic) {
        this.ttlConfig = ttlConfig;
        this.sportsFeedMessageGroup = grp;
        this.transformingLogic = transformingLogic;
        this.expiredMatches = new ConcurrentHashMap();
        this.keyRemovedTimeEpochMillis = new ConcurrentHashMap();
        this.ttlStatus = new ConcurrentHashMap();
    }

    public synchronized TTLWrapper removeData(TTLWrapper ttlRemoveWrapper, IndexedSnapshot snapshot, PartitionKey key) {
        if (!snapshot.getPartitions().contains(key)) {
            ttlRemoveWrapper.setRemainingSs(snapshot);
            ttlRemoveWrapper.setRemovedSs(null);
            return ttlRemoveWrapper;
        }
        IIndexedSnapshotBuilder sBuilder = BuilderProvider.getSnapshotBuilder(snapshot);
        IndexedSnapshot removedData = (IndexedSnapshot)sBuilder.reset(key).build();
        IndexedSnapshot result = (IndexedSnapshot)sBuilder.build();
        this.expiredMatches.put(key, removedData);
        this.keyRemovedTimeEpochMillis.put(key, System.currentTimeMillis());
        ttlRemoveWrapper.setRemovedSs(removedData);
        ttlRemoveWrapper.setRemainingSs(result);
        return ttlRemoveWrapper;
    }

    public synchronized TTLWrapper restoreData(IndexedSnapshot parent, PartitionKey key, long restoredTime) {
        TTLWrapper ttlRestore = new TTLWrapper();
        IndexedSnapshot partition = this.expiredMatches.get(key);
        if (partition == null) {
            ttlRestore.setRemainingSs(parent);
            ttlRestore.setRestoredSs(null);
            return ttlRestore;
        }
        HashMap<PartitionKey, Long> updateTime = new HashMap<PartitionKey, Long>();
        updateTime.put(key, restoredTime);
        partition = new IndexedSnapshotImpl(partition.matches(), updateTime);
        parent = SnapshotUtil.combineSnapshots(this.sportsFeedMessageGroup.DATA_INSERT_MATCH, partition, parent).getAfterSs();
        parent = SnapshotUtil.combineSnapshots(this.sportsFeedMessageGroup.DATA_INSERT_EVENT, partition, parent).getAfterSs();
        parent = SnapshotUtil.combineSnapshots(this.sportsFeedMessageGroup.DATA_INSERT_ODD, partition, parent).getAfterSs();
        ttlRestore.setRestoredSs(partition);
        ttlRestore.setRemainingSs(parent);
        ttlRestore.setTtlRemovedTime(this.keyRemovedTimeEpochMillis.remove(key));
        this.expiredMatches.remove(key);
        return ttlRestore;
    }

    public void clearBin() {
        this.expiredMatches.clear();
    }

    public void clearBin(PartitionKey key) {
        this.expiredMatches.remove(key);
        this.ttlStatus.remove(key);
    }

    public boolean containData(PartitionKey key) {
        return this.expiredMatches.containsKey(key);
    }

    public void setTtlConfig(TTLConfig config) {
        this.ttlConfig = config;
    }

    public TTLConfig getTtlConfig() {
        return this.ttlConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TTLRestoreCheck getTtlRestoreSnapshot(Incoming incoming) {
        this.freezeThread();
        TTLRestoreCheck restoreSnapshot = null;
        try {
            if (this.getGrp().DATA_RESET.isSameFormat(incoming.msgType())) {
                for (PartitionKey pKey : incoming.data().getPartitions()) {
                    log.info("Dropping partition " + pKey);
                    this.expiredMatches.remove(pKey);
                }
            } else {
                HashSet<PartitionKey> restoreKeys = new HashSet<PartitionKey>();
                for (PartitionKey pKey : incoming.data().getPartitions()) {
                    if (this.ttlStatus.getOrDefault(pKey, false).booleanValue()) {
                        this.ttlStatus.remove(pKey);
                    }
                    restoreKeys.add(pKey);
                }
                restoreSnapshot = new TTLRestoreCheck(this, restoreKeys, incoming.stream(), this.transformingLogic);
            }
        }
        finally {
            this.unFreezeThread();
        }
        return restoreSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<TTLRemoveCheck> getTtlRemoveSnapshot(Collection<FSRepo> fsRepos) {
        this.freezeThread();
        ArrayList<TTLRemoveCheck> ttlSnapshots = new ArrayList<TTLRemoveCheck>();
        try {
            fsRepos.stream().forEach(fsRepo -> ttlSnapshots.addAll(fsRepo.getTtlRemoveSnapshot()));
            for (TTLRemoveCheck removeSnapshot : ttlSnapshots) {
                removeSnapshot.setRecycleBin(this);
                for (PartitionKey pk : removeSnapshot.getKeys()) {
                    this.ttlStatus.put(pk, true);
                }
            }
        }
        finally {
            this.unFreezeThread();
        }
        return ttlSnapshots;
    }

    public Collection<IBetMatch> copyData(PartitionKey key, Collection<IBetMatch> matches) {
        IndexedSnapshot partition = this.expiredMatches.get(key);
        if (partition == null) {
            return matches;
        }
        if (matches == null) {
            matches = Arrays.asList(new IBetMatch[0]);
        }
        IndexedSnapshot parent = new IndexedSnapshotImpl(matches);
        parent = SnapshotUtil.combineSnapshots(this.sportsFeedMessageGroup.DATA_INSERT_MATCH, partition, parent).getAfterSs();
        parent = SnapshotUtil.combineSnapshots(this.sportsFeedMessageGroup.DATA_INSERT_EVENT, partition, parent).getAfterSs();
        parent = SnapshotUtil.combineSnapshots(this.sportsFeedMessageGroup.DATA_INSERT_ODD, partition, parent).getAfterSs();
        return parent.matches();
    }

    public SportsFeedMessageGroup getGrp() {
        return this.sportsFeedMessageGroup;
    }

    public void freezeThread() {
        if (this.lock.getHoldCount() > 0) {
            log.warn("Lock already got by this thread.Call unlock multiple times");
        }
        this.lock.lock();
    }

    public void unFreezeThread() {
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ex) {
            log.error("Error while unfreezing lock ", (Throwable)ex);
        }
    }
}

