/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.ConvertedMsg;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.utility.concurrent.worker.single.SharedExecutorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComparableEPDispatcher
implements IEndPointDispatcher {
    private static Logger log = LoggerFactory.getLogger(AbstractComparableEPDispatcher.class);
    private String streamName;
    private AtomicBoolean readyToDispatch;
    private AtomicBoolean isSwitchingFilters;
    private AtomicBoolean isReceivingRelevantDeltaFromNewEPG;
    private AtomicBoolean hasDispatchedSwitchFilterDeltas;
    private IEndPointGroup oldEPG;
    private IEndPointGroup newEPG;
    private SharedExecutorWorker<Outgoing, Void> inputWorker;
    private SharedExecutorWorker<Outgoing, Void> newWorker;
    private SharedExecutorWorker<Outgoing, Void> oldWorker;
    protected SportsFeedMessageGroup grp;

    public AbstractComparableEPDispatcher(String streamName, SportsFeedMessageGroup grp, ScheduledExecutorService es) {
        this.streamName = streamName;
        this.grp = grp;
        this.readyToDispatch = new AtomicBoolean(false);
        this.isSwitchingFilters = new AtomicBoolean(false);
        this.isReceivingRelevantDeltaFromNewEPG = new AtomicBoolean(false);
        this.hasDispatchedSwitchFilterDeltas = new AtomicBoolean(true);
        this.oldEPG = null;
        this.newEPG = null;
        this.newWorker = new SharedExecutorWorker(es);
        this.oldWorker = new SharedExecutorWorker(es, this::dispatchMessages);
        this.inputWorker = this.getIdleWorker();
    }

    @Override
    public String getStream() {
        return this.streamName;
    }

    @Override
    public int compareTo(IEndPointDispatcher dispatcher) {
        return this.id().compareTo(dispatcher.id());
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractComparableEPDispatcher) {
            return this.id().equals(((AbstractComparableEPDispatcher)obj).id());
        }
        return false;
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    @Override
    public void submitToInputQueue(Outgoing out) {
        this.inputWorker.submit((Object)out).exceptionally(this::onException);
    }

    @Override
    public void submitToDispatchingQueue(Outgoing out) {
        this.getHandlingWorker().submit((Object)out).exceptionally(this::onException);
    }

    @Override
    public void submitToIdleQueue(Outgoing out) {
        this.getIdleWorker().submit((Object)out).exceptionally(this::onException);
    }

    @Override
    public Void onException(Throwable e) {
        if (!(e instanceof CancellationException)) {
            log.error("Exception when dispatching outgoing messages to dispatchers. ", e);
        }
        return null;
    }

    @Override
    public void switchInputQueueToIdleQueue() {
        this.inputWorker = this.getIdleWorker();
    }

    private void swapHandler() {
        SharedExecutorWorker<Outgoing, Void> handlingWorker = this.getHandlingWorker();
        SharedExecutorWorker<Outgoing, Void> idleWorker = this.getIdleWorker();
        handlingWorker.removeDefaultHandler();
        idleWorker.setDefaultHandler(this::dispatchMessages);
    }

    private SharedExecutorWorker<Outgoing, Void> getHandlingWorker() {
        if (this.newWorker.getDefaultHandler() != null) {
            return this.newWorker;
        }
        if (this.oldWorker.getDefaultHandler() != null) {
            return this.oldWorker;
        }
        return null;
    }

    private SharedExecutorWorker<Outgoing, Void> getIdleWorker() {
        if (this.newWorker.getDefaultHandler() == null) {
            return this.newWorker;
        }
        if (this.oldWorker.getDefaultHandler() == null) {
            return this.oldWorker;
        }
        return null;
    }

    @Override
    public void readyToDispatch() {
        this.readyToDispatch.set(true);
    }

    @Override
    public void notReadyToDispatch() {
        this.readyToDispatch.set(false);
    }

    @Override
    public boolean isReadyToDispatch() {
        return this.readyToDispatch.get();
    }

    @Override
    public void cleanup() {
        this.newWorker.clear();
        this.oldWorker.clear();
    }

    @Override
    public void submitEndQueueIndicatorToDispatchingQueue(boolean switchFilterCompleted) {
        _EndQueueIndicator endQIndicator = new _EndQueueIndicator(switchFilterCompleted);
        this.submitToDispatchingQueue(endQIndicator);
    }

    private Void dispatchMessages(Outgoing out) {
        if (out instanceof _EndQueueIndicator) {
            this.swapHandler();
            if (((_EndQueueIndicator)out).isSwitchFilterCompleted()) {
                this.setDispatchedSwitchFilterDeltas(true);
                if (this.isReceivingRelevantDeltaFromNewEPG()) {
                    this.setSwitchingFilters(false);
                }
            }
            return null;
        }
        this.handleMessage(out);
        return null;
    }

    protected abstract void handleMessage(Outgoing var1);

    @Override
    public void setSwitchingFilters(boolean value) {
        this.isSwitchingFilters.set(value);
    }

    @Override
    public boolean isSwitchingFilters() {
        return this.isSwitchingFilters.get();
    }

    @Override
    public boolean isReceivingRelevantDeltaFromNewEPG() {
        return this.isReceivingRelevantDeltaFromNewEPG.get();
    }

    @Override
    public void setReceivingRelevantDeltaFromNewEPG(boolean value) {
        this.isReceivingRelevantDeltaFromNewEPG.set(value);
    }

    @Override
    public boolean hasDispatchedSwitchFilterDeltas() {
        return this.hasDispatchedSwitchFilterDeltas.get();
    }

    @Override
    public void setDispatchedSwitchFilterDeltas(boolean value) {
        this.hasDispatchedSwitchFilterDeltas.set(value);
    }

    @Override
    public synchronized void setOldEPG(IEndPointGroup epg) {
        this.oldEPG = epg;
    }

    @Override
    public IEndPointGroup getOldEPG() {
        return this.oldEPG;
    }

    @Override
    public synchronized void setNewEPG(IEndPointGroup epg) {
        this.newEPG = epg;
    }

    @Override
    public IEndPointGroup getNewEPG() {
        return this.newEPG;
    }

    public static class _EndQueueIndicator
    implements DeltaOutgoing {
        private boolean switchFilterCompleted;

        public _EndQueueIndicator(boolean switchFilterCompleted) {
            this.switchFilterCompleted = switchFilterCompleted;
        }

        public boolean isSwitchFilterCompleted() {
            return this.switchFilterCompleted;
        }

        @Override
        public IMessageClass<?> msgType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexedSnapshot after() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexedSnapshot delta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexedSnapshot before() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConvertedMsg getConverted() {
            return this.getConverted();
        }
    }
}

