/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.WrapperImpl;
import jayeson.model.IDataFilter;

public class UpdateFilterSnapshotWrapper
extends WrapperImpl
implements IDispatchableWrapper {
    private IDataFilter oldFilter;
    private IndexedSnapshot fullSnapshot;

    public UpdateFilterSnapshotWrapper(IEndPointGroup epg, String stream, IDataFilter oldFilter, IndexedSnapshot fullSnapshot) {
        super(epg, stream);
        this.oldFilter = oldFilter;
        this.fullSnapshot = fullSnapshot;
    }

    public IDataFilter getOldFilter() {
        return this.oldFilter;
    }

    @Override
    public Consumer<Void> process() {
        return Void2 -> {
            Collection<IEndPointDispatcher> epds = this.getEpg().getEPDs(this.getStream());
            for (IEndPointDispatcher epd : epds) {
                epd.switchInputQueueToIdleQueue();
            }
            this.getEpg().submitForPostProcess(this);
        };
    }

    @Override
    public Consumer<Void> postProcess() {
        return Void2 -> {
            Collection<Outgoing> mws = this.getEpg().generate(this);
            if (mws != null) {
                Collection<IEndPointDispatcher> epds = this.getEpg().getEPDs(this.getStream());
                for (IEndPointDispatcher epd : epds) {
                    for (Outgoing mw : mws) {
                        if (mw == null) continue;
                        epd.submitToDispatchingQueue(mw);
                    }
                    epd.submitEndQueueIndicatorToDispatchingQueue(true);
                }
            }
        };
    }

    public IndexedSnapshot getFullSnapshot() {
        return this.fullSnapshot;
    }
}

