/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.metainfo.StreamNameCode;
import jayeson.lib.sports.codec.FilterRequest;
import jayeson.lib.sports.codec.StartSubscribeFeed;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.dispatch.network.FeedSubscriptions;
import jayeson.service.delivery.IOutProcessor;

public class ClientMsgHandler
implements IOutProcessor {
    final SportsFeedMessageGroup msgGroup;
    final FeedSubscriptions subscriptions;
    final StreamNameCode streamNameCode;

    @Inject
    public ClientMsgHandler(SportsFeedMessageGroup msgGroup, FeedSubscriptions subscriptions, StreamNameCode streamNameCode) {
        this.msgGroup = msgGroup;
        this.subscriptions = subscriptions;
        this.streamNameCode = streamNameCode;
    }

    public void process(MessageWrapper mw) throws Exception {
        String stream = mw.getMetaInformation((MetaInformationCode)this.streamNameCode);
        IEndPoint socket = mw.getEndpoint();
        Object message = mw.msg();
        if (message instanceof FilterRequest) {
            FilterRequest filterRequest = (FilterRequest)message;
            this.subscriptions.setFilter(socket, stream, filterRequest);
        } else if (message instanceof StartSubscribeFeed) {
            StartSubscribeFeed startCmd = (StartSubscribeFeed)message;
            this.subscriptions.start(socket, stream, startCmd);
        } else if (mw.getMessageClass().id() == this.msgGroup.FILTER_REMOVE.id()) {
            FilterRequest filterRequest = new FilterRequest(Integer.parseInt(mw.msg().toString()), null);
            this.subscriptions.setFilter(socket, stream, filterRequest);
        }
    }

    public IMessageGroup messageGroup() {
        return this.msgGroup;
    }

    public void onDeregistered(IEndPoint endpoint) {
    }

    public void onRegistered(IEndPoint endpoint) {
    }
}

