/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.dispatch.transform.EventCache;
import jayeson.lib.sports.dispatch.transform.MatchCache;
import jayeson.lib.sports.util.PbufToApiConverter;

public class CacheTracker {
    protected Map<String, MatchCache> matchCache = new HashMap<String, MatchCache>();
    private boolean isInitialized;
    protected Map<PartitionKey, Set<String>> partitionToMatches = new HashMap<PartitionKey, Set<String>>();

    public void setInitialized(boolean value) {
        this.isInitialized = value;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Map<String, MatchCache> getMatcheCache() {
        return this.matchCache;
    }

    public MatchCache getMatch(String matchId) {
        return this.matchCache.get(matchId);
    }

    public EventCache getEvent(String matchId, String eventId) {
        return this.matchCache.get(matchId).getEventCache(eventId);
    }

    public boolean isMatchEmpty() {
        return this.matchCache.isEmpty();
    }

    public boolean isEventEmpty(String matchId) {
        boolean isEventEmpty = true;
        if (this.matchCache.get(matchId) != null) {
            return this.matchCache.get((Object)matchId).eventCache.isEmpty();
        }
        return isEventEmpty;
    }

    public boolean hasMatch(String matchId) {
        boolean hasMatch = false;
        if (this.matchCache.get(matchId) != null) {
            hasMatch = true;
        }
        return hasMatch;
    }

    public boolean hasMatch(String matchId, PartitionKey key) {
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null) {
            return mCache.hasKey(key);
        }
        return false;
    }

    public Collection<PartitionKey> getMatchKeys(String matchId) {
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null) {
            return mCache.getKeys();
        }
        return Arrays.asList(new PartitionKey[0]);
    }

    public boolean hasEvent(String matchId, String eventId) {
        boolean hasEvent = false;
        if (this.matchCache.get(matchId) != null && this.matchCache.get(matchId).getEventCache(eventId) != null) {
            hasEvent = true;
        }
        return hasEvent;
    }

    public boolean hasEvent(String matchId, String eventId, PartitionKey key) {
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null) {
            EventCache eCache = mCache.getEventCache(eventId);
            return eCache != null && eCache.hasKey(key);
        }
        return false;
    }

    public Collection<PartitionKey> getEventKeys(String matchId, String eventId) {
        EventCache eCache;
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null && (eCache = mCache.getEventCache(eventId)) != null) {
            return eCache.getKeys();
        }
        return Arrays.asList(new PartitionKey[0]);
    }

    public Collection<PartitionKey> getEventKeys(IndexedSnapshot snapshot) {
        HashSet<PartitionKey> keys = new HashSet<PartitionKey>();
        for (IBetMatch match : snapshot.matches()) {
            String matchId = match.id();
            MatchCache mCache = this.matchCache.get(matchId);
            if (mCache == null) continue;
            Set<String> eventIds = match.events().stream().map(event -> event.id()).collect(Collectors.toSet());
            keys.addAll(mCache.getEventPartitionKeys(eventIds));
        }
        return keys;
    }

    public Collection<PartitionKey> getMatchKeys(IndexedSnapshot snapshot) {
        HashSet<PartitionKey> keys = new HashSet<PartitionKey>();
        for (IBetMatch match : snapshot.matches()) {
            String matchId = match.id();
            MatchCache mCache = this.matchCache.get(matchId);
            if (mCache == null) continue;
            keys.addAll(mCache.getKeys());
        }
        return keys;
    }

    public void cleanUp() {
        this.matchCache.clear();
    }

    public void clearPartition(PartitionKey key) {
        Iterator<MatchCache> it = this.matchCache.values().iterator();
        while (it.hasNext()) {
            MatchCache mCache = it.next();
            mCache.clear(key);
            if (!mCache.isEmpty()) continue;
            it.remove();
        }
    }

    public Set<PartitionKey> getPartitions() {
        return this.partitionToMatches.keySet();
    }

    public boolean containsPartition(PartitionKey key) {
        return this.partitionToMatches.containsKey(key);
    }

    public void insertMatchToCache(IndexedSnapshot snapshot) {
        for (IBetMatch match : snapshot.matches()) {
            String partitions;
            MatchCache mCache = this.matchCache.get(match.id());
            if (mCache == null) {
                mCache = new MatchCache(match.id());
                this.matchCache.put(match.id(), mCache);
            }
            if ((partitions = (String)match.meta().get("AGGREGATE_KEY")) == null) continue;
            List<PartitionKey> keys = PbufToApiConverter.getParitionKeys(partitions);
            mCache.addKeys(keys);
            keys.forEach(key -> {
                Set matches = this.partitionToMatches.computeIfAbsent((PartitionKey)key, inputKey -> new HashSet());
                matches.add(match.id());
            });
        }
    }

    public void insertEventToCache(IndexedSnapshot snapshot) {
        for (IBetMatch match : snapshot.matches()) {
            MatchCache mCache = this.matchCache.get(match.id());
            if (mCache == null) continue;
            for (IBetEvent event : match.events()) {
                EventCache eCache = mCache.getEventCache(event.id());
                if (eCache == null) {
                    eCache = new EventCache(event.id());
                    mCache.addEvent(event.id(), eCache);
                }
                for (IBetEventState state : event.eventStates()) {
                    eCache.addKey(state.partitionKey());
                }
            }
        }
    }

    public void deleteMatchFromCache(IndexedSnapshot snapshot) {
        for (IBetMatch match : snapshot.matches()) {
            MatchCache mCache = this.matchCache.get(match.id());
            if (mCache == null) continue;
            Set<PartitionKey> partitions = snapshot.getPartitions();
            mCache.removeKeys(partitions);
            if (mCache.isEmpty()) {
                this.matchCache.remove(match.id());
            }
            ArrayList keysToDelete = new ArrayList();
            partitions.forEach(key -> {
                Set<String> matchIds = this.partitionToMatches.get(key);
                if (matchIds != null) {
                    matchIds.remove(match.id());
                    if (matchIds.isEmpty()) {
                        keysToDelete.add(key);
                    }
                }
            });
            keysToDelete.forEach(key -> this.partitionToMatches.remove(key));
        }
    }

    public void deleteEventFromCache(IndexedSnapshot snapshot) {
        for (IBetMatch match : snapshot.matches()) {
            MatchCache mCache = this.matchCache.get(match.id());
            if (mCache == null) continue;
            for (IBetEvent event : match.events()) {
                EventCache eCache = mCache.getEventCache(event.id());
                if (eCache == null) continue;
                eCache.removeKeys(snapshot.getPartitions());
                if (!eCache.isEmpty()) continue;
                mCache.removeEvent(event.id());
            }
        }
    }

    public void deleteMatchFromCache(String matchId) {
        MatchCache mCache = this.matchCache.remove(matchId);
        if (mCache != null) {
            ArrayList keysToDelete = new ArrayList();
            mCache.getKeys().forEach(key -> {
                Set<String> matchIds = this.partitionToMatches.get(key);
                if (matchIds != null) {
                    matchIds.remove(matchId);
                    if (matchIds.isEmpty()) {
                        keysToDelete.add(key);
                    }
                }
            });
            keysToDelete.forEach(key -> this.partitionToMatches.remove(key));
        }
    }

    public void deleteMatchFromCache(String matchId, PartitionKey key) {
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null) {
            Set<String> matchIds;
            mCache.removeKey(key);
            if (mCache.isEmpty()) {
                this.matchCache.remove(matchId);
            }
            if ((matchIds = this.partitionToMatches.get(key)) != null) {
                matchIds.remove(matchId);
                if (matchIds.isEmpty()) {
                    this.partitionToMatches.remove(key);
                }
            }
        }
    }

    public void deleteEventFromCache(String matchId, String eventId, PartitionKey key) {
        EventCache eCache;
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null && (eCache = mCache.getEventCache(eventId)) != null) {
            eCache.removeKey(key);
            if (eCache.isEmpty()) {
                mCache.removeEvent(eventId);
            }
        }
    }

    public void insertMatchToCache(String matchId, PartitionKey key) {
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache == null) {
            mCache = new MatchCache(matchId);
            this.matchCache.put(matchId, mCache);
        }
        mCache.addKey(key);
    }

    public void insertEventToCache(String matchId, String eventId, PartitionKey key) {
        MatchCache mCache = this.matchCache.get(matchId);
        if (mCache != null) {
            EventCache eCache = mCache.getEventCache(eventId);
            if (eCache == null) {
                eCache = new EventCache(eventId);
            }
            eCache.addKey(key);
        }
    }
}

