/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.module;

import com.google.inject.AbstractModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import jayeson.lib.sports.client.SportsFeedClient;
import jayeson.lib.sports.core.AggregatedStreamNameMapper;
import jayeson.lib.sports.core.ClientDeltaTransformingLogicImpl;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.FSRepoFactory;
import jayeson.lib.sports.core.IdentityStreamNameMapper;
import jayeson.lib.sports.core.RelayerDeltaTransformingLogicImpl;
import jayeson.lib.sports.core.StreamNameMapper;
import jayeson.lib.sports.core.TTLConfig;
import jayeson.lib.sports.dispatch.network.SportsConfig;
import jayeson.lib.sports.dispatch.transform.CacheTrackingLogic;
import jayeson.lib.sports.dispatch.transform.ClientCacheTrackingLogicImpl;
import jayeson.lib.sports.dispatch.transform.ClientMessageEncoderImpl;
import jayeson.lib.sports.dispatch.transform.MessageEncoder;
import jayeson.lib.sports.dispatch.transform.RelayerCacheTrackingLogicImpl;
import jayeson.lib.sports.dispatch.transform.RelayerMessageEncoderImpl;
import jayeson.lib.sports.module.SportsFeedCoreComponentModule;
import jayeson.lib.sports.module.SportsFeedPEModule;
import jayeson.lib.sports.receive.SportsFeedInConfig;

public class Module {

    public static class Relayer {

        public static class Aggregated
        extends AbstractModule {
            final SportsConfig config;

            protected void configure() {
                this.install((com.google.inject.Module)new SportsFeedCoreComponentModule());
                this.install((com.google.inject.Module)new SportsFeedPEModule(this.config));
                this.binder().install(new FactoryModuleBuilder().build(FSRepoFactory.class));
                this.bind(StreamNameMapper.class).toInstance((Object)new AggregatedStreamNameMapper(this.config.getAggregatedStreamName()));
                this.bind(DeltaTransformingLogic.class).toInstance((Object)new RelayerDeltaTransformingLogicImpl());
                this.bind(CacheTrackingLogic.class).toInstance((Object)new RelayerCacheTrackingLogicImpl());
                this.bind(MessageEncoder.class).toInstance((Object)new RelayerMessageEncoderImpl());
            }

            public Aggregated(SportsConfig config) {
                this.config = config;
            }
        }

        public static class Stream
        extends AbstractModule {
            final SportsConfig config;

            public Stream(SportsConfig config) {
                this.config = config;
            }

            protected void configure() {
                this.install((com.google.inject.Module)new SportsFeedCoreComponentModule());
                this.install((com.google.inject.Module)new SportsFeedPEModule(this.config));
                this.binder().install(new FactoryModuleBuilder().build(FSRepoFactory.class));
                this.bind(StreamNameMapper.class).to(IdentityStreamNameMapper.class);
                this.bind(DeltaTransformingLogic.class).toInstance((Object)new RelayerDeltaTransformingLogicImpl());
                this.bind(CacheTrackingLogic.class).toInstance((Object)new RelayerCacheTrackingLogicImpl());
                this.bind(MessageEncoder.class).toInstance((Object)new RelayerMessageEncoderImpl());
            }
        }
    }

    public static class Client
    extends AbstractModule {
        SportsFeedInConfig config;

        public Client(SportsFeedInConfig config) {
            this.config = config;
        }

        protected void configure() {
            this.install((com.google.inject.Module)new SportsFeedCoreComponentModule());
            this.bind(TTLConfig.class).toInstance((Object)this.config.getTtlConfig());
            this.bind(SportsFeedInConfig.class).toInstance((Object)this.config);
            this.bind(SportsFeedClient.class).asEagerSingleton();
            this.binder().install(new FactoryModuleBuilder().build(FSRepoFactory.class));
            this.bind(StreamNameMapper.class).toInstance((Object)new AggregatedStreamNameMapper("MEMORY_AGGREGATED_STREAM"));
            this.bind(DeltaTransformingLogic.class).toInstance((Object)new ClientDeltaTransformingLogicImpl());
            this.bind(CacheTrackingLogic.class).toInstance((Object)new ClientCacheTrackingLogicImpl());
            this.bind(MessageEncoder.class).toInstance((Object)new ClientMessageEncoderImpl());
        }
    }
}

