/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.EventType;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.twoside.IB2Event;
import jayeson.lib.feed.api.twoside.IB2EventState;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IBetEventBuilder;
import jayeson.lib.sports.mutable.IBetRecordBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class B2EventBuilder
implements IBetEventBuilder {
    private static Logger log = LoggerFactory.getLogger(B2EventBuilder.class);
    protected String id;
    protected Map records = new HashMap();
    protected String matchId;
    protected EventType type;
    protected Map<String, String> meta;
    protected Map states = new HashMap();

    public void setId(String id) {
        this.id = id;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    protected void mergeFrom(IBetEvent t, boolean cloneChildren) {
        if (!(t instanceof IB2Event)) {
            throw new IllegalArgumentException("Expected IB2Event for B2EventBuilder");
        }
        IB2Event event = (IB2Event)t;
        this.id = t.id();
        if (cloneChildren && t.records() != null) {
            this.records = event.records().stream().collect(Collectors.toMap(r -> this.generateKey((IBetRecord)r), r -> r));
            this.setStates(event.eventStates());
        }
        this.matchId = event.matchId();
        this.type = event.eventType();
        this.meta = new HashMap<String, String>(t.meta());
    }

    @Override
    public void addState(IBetEventState state) {
        this.states.put(state.partitionKey(), state);
    }

    public void setStates(Collection<? extends IB2EventState> states) {
        if (states != null) {
            this.states = states.stream().collect(Collectors.toMap(s -> s.partitionKey(), s -> s));
        }
    }

    public B2EventBuilder(IBetEvent event, boolean cloneChildren) {
        this.mergeFrom(event, cloneChildren);
    }

    @Override
    public String insertChild(IBetRecord rec) {
        this.records.put(this.generateKey(rec), rec);
        return null;
    }

    @Override
    public void updateChild(IBetRecord rec) {
        Object temp = this.records.get(this.generateKey(rec));
        if (temp == null) {
            log.error("[UpdateOdd] Cannot find record {}_{}_{}_{}", new Object[]{this.matchId, this.id, rec.id(), rec.source()});
            return;
        }
        IBetRecord exist = (IBetRecord)temp;
        IBetRecordBuilder builder = BuilderProvider.getBuilder(exist);
        builder.merge(rec);
        this.records.put(this.generateKey(exist), builder.build());
    }

    @Override
    public String deleteChild(IBetRecord rec) {
        this.records.remove(this.generateKey(rec));
        return null;
    }

    @Override
    public void aggregateInsert(IBetEvent event) {
        for (IBetEventState state : event.eventStates()) {
            this.states.put(state.partitionKey(), state);
        }
    }

    @Override
    public void aggregateUpdate(IBetEvent event) {
        for (IBetEventState state : event.eventStates()) {
            this.states.put(state.partitionKey(), state);
        }
    }

    @Override
    public boolean aggregateDelete(IBetEvent event) {
        for (IBetEventState state : event.eventStates()) {
            this.states.remove(state.partitionKey());
        }
        return this.states.isEmpty();
    }

    @Override
    public IBetEventBuilder reset(PartitionKey key) {
        if (!this.states.containsKey(key)) {
            return null;
        }
        B2EventBuilder removedDataEventBuilder = (B2EventBuilder)BuilderProvider.getBuilder((IBetEvent)this.build());
        removedDataEventBuilder.states.clear();
        removedDataEventBuilder.records.clear();
        Iterator it = this.states.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry stateEntry = it.next();
            if (!((PartitionKey)stateEntry.getKey()).equals((Object)key)) continue;
            removedDataEventBuilder.states.put(stateEntry.getKey(), stateEntry.getValue());
            it.remove();
        }
        it = this.records.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry recordEntry = it.next();
            if (!((IBetRecord)recordEntry.getValue()).source().equals(key.source()) || !((IBetRecord)recordEntry.getValue()).oddType().equals((Object)key.oddType())) continue;
            removedDataEventBuilder.insertChild((IBetRecord)recordEntry.getValue());
            it.remove();
        }
        return removedDataEventBuilder;
    }

    @Override
    public boolean isEmpty() {
        if (this.states == null) {
            return true;
        }
        return this.states.isEmpty();
    }
}

