/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.mutable.BuilderProvider;
import jayeson.lib.sports.mutable.IBetMatchBuilder;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IndexedSnapshotBuilder
implements IIndexedSnapshotBuilder {
    private static final Logger log = LoggerFactory.getLogger(IndexedSnapshotBuilder.class);
    Map<String, IBetMatch> matches = new HashMap<String, IBetMatch>();
    Map<PartitionKey, Long> partitions;

    public IndexedSnapshotBuilder() {
        this.partitions = new HashMap<PartitionKey, Long>();
    }

    @Override
    public void markPartitionAsUpdated(PartitionKey partitionKey, Long time) {
        this.partitions.put(partitionKey, time);
    }

    @Override
    public void markPartitionAsUpdated(PartitionKey key) {
        this.markPartitionAsUpdated(key, System.currentTimeMillis());
    }

    public void setPartitions(Collection<PartitionKey> partitionKeySet) {
        this.partitions = new HashMap<PartitionKey, Long>();
        for (PartitionKey key : partitionKeySet) {
            this.markPartitionAsUpdated(key);
        }
    }

    public IndexedSnapshotBuilder(IndexedSnapshot input, boolean copyPartitions) {
        if (input != null) {
            for (IBetMatch match : input.matches()) {
                this.matches.put(match.id(), match);
            }
        }
        this.partitions = new HashMap<PartitionKey, Long>();
        if (copyPartitions && input != null && input.getPartitions() != null) {
            this.partitions.putAll(input.getPartitionMap());
        }
    }

    public IndexedSnapshotBuilder(IndexedSnapshot input) {
        this(input, true);
    }

    @Override
    public IndexedSnapshotImpl build() {
        IndexedSnapshotImpl ds = new IndexedSnapshotImpl(this.matches, this.partitions, false);
        return ds;
    }

    @Override
    public String insertChild(IBetMatch incoming) {
        IBetMatch existing = this.matches.get(incoming.id());
        String suppressMatch = null;
        if (existing == null) {
            this.matches.put(incoming.id(), incoming);
        } else {
            suppressMatch = incoming.id();
            IBetMatchBuilder builder = BuilderProvider.getBuilder(existing);
            builder.aggregateInsert(incoming);
            this.matches.put(incoming.id(), (IBetMatch)builder.build());
        }
        return suppressMatch;
    }

    @Override
    public void updateChild(IBetMatch incoming) {
        IBetMatch existing = this.matches.get(incoming.id());
        if (existing == null) {
            log.error("[UpdateMatch] Cannot found matchId {} to execute update match from {}", (Object)incoming.id(), incoming.meta().get("AGGREGATE_KEY"));
            return;
        }
        IBetMatchBuilder builder = BuilderProvider.getBuilder(existing);
        builder.aggregateUpdate(incoming);
        this.matches.put(incoming.id(), (IBetMatch)builder.build());
    }

    @Override
    public String deleteChild(IBetMatch incoming) {
        IBetMatch existing = this.matches.get(incoming.id());
        String suppressMatch = null;
        if (existing == null) {
            log.error("[DeleteMatch] Cannot find matchId {} to execute delete match from {}", (Object)incoming.id(), incoming.meta().get("AGGREGATE_KEY"));
            return null;
        }
        IBetMatchBuilder builder = BuilderProvider.getBuilder(existing);
        boolean isEmpty = builder.aggregateDelete(incoming);
        if (isEmpty) {
            this.matches.remove(incoming.id());
        } else {
            this.matches.put(incoming.id(), (IBetMatch)builder.build());
            suppressMatch = incoming.id();
        }
        return suppressMatch;
    }

    @Override
    public IIndexedSnapshotBuilder reset(PartitionKey key) {
        if (!this.partitions.containsKey(key)) {
            return null;
        }
        HashMap<String, IBetMatch> updatedMatches = new HashMap<String, IBetMatch>(this.matches);
        IndexedSnapshotBuilder removedDataSnapshotBuilder = (IndexedSnapshotBuilder)BuilderProvider.getSnapshotBuilder(this.build());
        removedDataSnapshotBuilder.matches.clear();
        removedDataSnapshotBuilder.partitions.clear();
        Long time = this.partitions.remove(key);
        removedDataSnapshotBuilder.partitions.put(key, time);
        for (IBetMatch match : this.matches.values()) {
            IBetMatchBuilder remainingMatchbuilder = BuilderProvider.getBuilder(match);
            IBetMatchBuilder removedMatchBuilder = remainingMatchbuilder.reset(key);
            if (removedMatchBuilder != null && !removedMatchBuilder.isEmpty()) {
                removedDataSnapshotBuilder.insertChild((IBetMatch)removedMatchBuilder.build());
            }
            if (!remainingMatchbuilder.isEmpty()) {
                updatedMatches.put(match.id(), (IBetMatch)remainingMatchbuilder.build());
                continue;
            }
            updatedMatches.remove(match.id());
        }
        this.matches = updatedMatches;
        return removedDataSnapshotBuilder;
    }

    @Override
    public void replaceMatch(IBetMatch match) {
        this.matches.put(match.id(), match);
    }

    @Override
    public int size() {
        return this.matches.size();
    }
}

