/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.receive;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.core.FSRepoFactory;
import jayeson.lib.sports.core.FSRepoImpl;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.StreamNameMapper;
import jayeson.lib.sports.core.TTLOutgoing;
import jayeson.lib.sports.core.TTLType;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.MergeableWrapper;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCommandProcessor {
    private static Logger log = LoggerFactory.getLogger(StreamCommandProcessor.class);
    private SportsFeedMessageGroup sportsGroup;
    private FSRepoFactory fsRepoFactory;
    private Map<String, FSRepo> fsRepoMap = new ConcurrentHashMap<String, FSRepo>();
    private StreamNameMapper streamMapper;
    private Set<IEndPointGroup> registeredEPGs;

    @Inject
    public StreamCommandProcessor(StreamNameMapper streamMapper, FSRepoFactory fsRepoFactory, SportsFeedMessageGroup sportsGrp) {
        this.streamMapper = streamMapper;
        this.fsRepoFactory = fsRepoFactory;
        this.sportsGroup = sportsGrp;
        this.registeredEPGs = ConcurrentHashMap.newKeySet();
        this.createInitialFSRepos();
    }

    public void process(String stream, Function<IndexedSnapshot, MergeableWrapper> function) {
        FSRepo fsRepo = this.createOrReturnFSRepo(stream);
        Collection<DeltaOutgoing> outgoing = fsRepo.appendSnapshot(stream, function);
        outgoing.stream().forEach(o -> {
            fsRepo.push((Outgoing)o);
            this.printMessage((Outgoing)o);
        });
    }

    public void process(String stream, Outgoing outgoing) {
        FSRepo fsRepo = this.createOrReturnFSRepo(stream);
        fsRepo.push(stream, outgoing);
        this.printMessage(outgoing);
    }

    private void printMessage(Outgoing outGng) {
        if (!(outGng instanceof TTLOutgoing) && outGng instanceof DeltaOutgoing) {
            IndexedSnapshot ss = ((DeltaOutgoing)outGng).delta();
            if (outGng.msgType().id() == this.sportsGroup.TTL_RESTORE.id()) {
                String identifier = "TTL_RESTORE";
                this.printPartitionKeys(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.TTL_REMOVE.id()) {
                String identifier = "TTL_REMOVE";
                this.printPartitionKeys(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_RESET.id()) {
                String identifier = "RESET";
                this.printPartitionKeys(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.ADMIN_REFRESH.id()) {
                String identifier = "REFRESH";
                this.printPartitionKeys(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_INSERT_MATCH.id()) {
                String identifier = "INSERT_MATCH";
                this.printPartitionKeys(identifier, ss);
                this.printMatch(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_UPDATE_MATCH.id()) {
                String identifier = "UPDATE_MATCH";
                this.printPartitionKeys(identifier, ss);
                this.printMatch(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_DELETE_MATCH.id()) {
                String identifier = "DELETE_MATCH";
                this.printPartitionKeys(identifier, ss);
                this.printMatch(identifier, ss);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_INSERT_EVENT.id()) {
                String identifier = "INSERT_EVENT";
                this.printPartitionKeys(identifier, ss);
                this.printEventState(identifier, ss, outGng);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_UPDATE_EVENT.id()) {
                String identifier = "UPDATE_EVENT";
                this.printPartitionKeys(identifier, ss);
                this.printEventState(identifier, ss, outGng);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_DELETE_EVENT.id()) {
                String identifier = "DELETE_EVENT";
                this.printPartitionKeys(identifier, ss);
                this.printEventState(identifier, ss, outGng);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_INSERT_ODD.id()) {
                String identifier = "INSERT_ODD";
                this.printPartitionKeys(identifier, ss);
                this.printRecord(identifier, ss, outGng);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_UPDATE_ODD.id()) {
                String identifier = "UPDATE_ODD";
                this.printPartitionKeys(identifier, ss);
                this.printRecord(identifier, ss, outGng);
            } else if (outGng.msgType().id() == this.sportsGroup.DATA_DELETE_ODD.id()) {
                String identifier = "DELETE_ODD";
                this.printPartitionKeys(identifier, ss);
                this.printRecord(identifier, ss, outGng);
            }
        } else if (outGng instanceof TTLOutgoing) {
            String identifier = "TTL";
            TTLOutgoing ts = (TTLOutgoing)outGng;
            identifier = ts.getTtlType() == TTLType.REMOVE ? "TTL_REM" : "TTL_RES";
            log.info("[{}][PK]{}", (Object)identifier, ts.delta().getPartitions());
        } else if (outGng instanceof Outgoing) {
            if (outGng.msgType().id() == this.sportsGroup.SWITCH_FILTER_START.id()) {
                log.info("[SWITCH_FILTER_START]");
            } else if (outGng.msgType().id() == this.sportsGroup.SWITCH_FILTER_END.id()) {
                log.info("[SWITCH_FILTER_END]");
            } else if (outGng.msgType().id() == this.sportsGroup.FULLSNAPSHOT_START.id()) {
                log.info("[FULLSNAPSHOT_START]");
            } else if (outGng.msgType().id() == this.sportsGroup.FULLSNAPSHOT_END.id()) {
                log.info("[FULLSNAPSHOT_END]");
            } else if (outGng.msgType().id() == this.sportsGroup.SWITCH_FILTER_FAIL.id()) {
                log.info("[SWITCH_FILTER_FAIL]");
            } else if (outGng.msgType().id() == this.sportsGroup.TTL_RESTORE_START.id()) {
                log.info("[TTL_RESTORE_START] {}", (Object)((IndexedSnapshot)((OutgoingImpl)outGng).msg()).getPartitions().toString());
            } else if (outGng.msgType().id() == this.sportsGroup.TTL_RESTORE_END.id()) {
                log.info("[TTL_RESTORE_END]");
            }
        }
    }

    private void printEventState(String identifier, IndexedSnapshot ss, Outgoing outGng) {
        for (IBetMatch match : ss.matches()) {
            Collection events = match.events();
            for (IBetEvent event : events) {
                String keys = event.eventStates().stream().map(s -> s.partitionKey().source()).collect(Collectors.toList()).toString();
                log.info("[{}] {}_{}_{}_{}", new Object[]{identifier, match.id(), event.id(), keys, outGng.getConverted()});
            }
        }
    }

    private void printMatch(String identifier, IndexedSnapshot ss) {
        for (IBetMatch match : ss.matches()) {
            log.info("[{}] {}_{}", new Object[]{identifier, match.id(), match.startTime()});
        }
    }

    private void printRecord(String identifier, IndexedSnapshot ss, Outgoing outGng) {
        for (IBetMatch match : ss.matches()) {
            Collection events = match.events();
            for (IBetEvent event : events) {
                for (IBetRecord rec : event.records()) {
                    log.info("[{}] {}_{}_{}_{}_{}_{}_{}", new Object[]{identifier, rec.matchId(), rec.eventId(), rec.id(), rec.source(), rec.oddType(), ((IB2Record)rec).pivotType(), ((DeltaOutgoing)outGng).after().match(match.id()).league()});
                }
            }
        }
    }

    private void printPartitionKeys(String identifier, IndexedSnapshot ss) {
        log.info("[{}][PK]{}", (Object)identifier, (Object)ss.getPartitions().toString());
    }

    private FSRepo createOrReturnFSRepo(String inputStream) {
        String outputStream = this.streamMapper.getOutputStreamName(inputStream);
        FSRepo fsRepo = this.createOrReturnFSRepoForOutputStream(outputStream);
        return fsRepo;
    }

    private FSRepo createOrReturnFSRepoForOutputStream(String outputStream) {
        FSRepo fsRepo = this.fsRepoMap.computeIfAbsent(outputStream, outputStreamName -> {
            FSRepoImpl newFSRepo = this.fsRepoFactory.create((String)outputStreamName, this.streamMapper.isAggregated());
            this.registeredEPGs.stream().forEach(epg -> epg.startGettingDeltaSnapshot(newFSRepo));
            return newFSRepo;
        });
        return fsRepo;
    }

    public void registerEPG(IEndPointGroup epg) {
        if (!this.registeredEPGs.contains(epg)) {
            this.fsRepoMap.values().stream().forEach(fsRepo -> fsRepo.registerSnapshotHandler(epg));
            this.registeredEPGs.add(epg);
        }
    }

    public void deregisterEPG(IEndPointGroup epg) {
        this.fsRepoMap.values().stream().forEach(fsRepo -> epg.stopGettingDeltaSnapshot((FSRepo)fsRepo));
        this.registeredEPGs.remove(epg);
    }

    public FSRepo getFSRepo(String outputStream) {
        return this.createOrReturnFSRepoForOutputStream(outputStream);
    }

    public Collection<FSRepo> getAllFSRepos() {
        return this.fsRepoMap.values();
    }

    private void createInitialFSRepos() {
        if (this.streamMapper.isAggregated()) {
            this.createOrReturnFSRepo("");
        }
    }
}

