/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.RecycleBin;
import jayeson.lib.sports.core.TTLCheck;
import jayeson.lib.sports.core.TTLConfig;
import jayeson.lib.sports.core.TTLOutgoing;
import jayeson.lib.sports.core.TTLType;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.Incoming;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.MergeableWrapper;
import jayeson.lib.sports.datastructure.TTLWrapper;

public class TTLRemoveCheck
extends TTLCheck {
    private TTLWrapper ttlRemoveWrapper;
    private DeltaTransformingLogic transformingLogic;

    public TTLRemoveCheck(RecycleBin recycleBin, Collection<PartitionKey> keys, String stream, DeltaTransformingLogic transformingLogic) {
        super(TTLType.REMOVE, recycleBin, keys, stream);
        this.transformingLogic = transformingLogic;
    }

    @Override
    public MergeableWrapper apply(IndexedSnapshot before) {
        Map<PartitionKey, Long> allKeys = before.getPartitionMap();
        HashMap<PartitionKey, Long> keysRemoved = new HashMap<PartitionKey, Long>();
        IndexedSnapshot removedSnapshot = before;
        ArrayList<IndexedSnapshot> ttlRemoveList = new ArrayList<IndexedSnapshot>();
        TTLConfig ttlConfig = this.getRecycleBin().getTtlConfig();
        boolean atleastOneKeyRemoved = false;
        for (PartitionKey key : this.getKeys()) {
            long threshold = 0L;
            if (!allKeys.containsKey(key)) continue;
            if (key.oddType() == OddType.LIVE) {
                threshold = allKeys.get(key) + (long)ttlConfig.getLivettl();
            }
            if (key.oddType() == OddType.TODAY) {
                threshold = allKeys.get(key) + (long)ttlConfig.getTodayttl();
            }
            if (key.oddType() == OddType.EARLY) {
                threshold = allKeys.get(key) + (long)ttlConfig.getEarlyttl();
            }
            if (threshold >= System.currentTimeMillis()) continue;
            atleastOneKeyRemoved = true;
            keysRemoved.put(key, allKeys.get(key));
            this.ttlRemoveWrapper = this.getRecycleBin().removeData(new TTLWrapper(), removedSnapshot, key);
            removedSnapshot = this.ttlRemoveWrapper.getRemainingSs();
            ttlRemoveList.add(this.ttlRemoveWrapper.getRemovedSs());
        }
        ArrayList<DeltaOutgoing> ttlOut = new ArrayList<DeltaOutgoing>();
        if (atleastOneKeyRemoved) {
            return this.transformingLogic.transformTTLRemove(ttlRemoveList, this.getRecycleBin().getGrp(), this.getStream(), before, removedSnapshot, keysRemoved);
        }
        MergeableWrapper wrapper = new MergeableWrapper();
        Incoming incoming = new Incoming((IMessageClass<?>)this.getRecycleBin().getGrp().ADMIN_REFRESH, this.getStream(), new IndexedSnapshotImpl((Map<SportType, Collection<IBetMatch>>)ISnapshot.matchesBySport(Arrays.asList(new IBetMatch[0])), this.getKeys()));
        ttlOut.add(new TTLOutgoing(this.getTtlType(), incoming, removedSnapshot, before));
        wrapper.setDeltaOut(ttlOut);
        wrapper.setAfter(removedSnapshot);
        return wrapper;
    }
}

