/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import jayeson.database.soccer.SoccerFeedUserConfig;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.lib.sports.dispatch.network.ConfigRepository;
import jayeson.lib.streamfinder.User;
import jayeson.lib.streamfinder.UserRepository;
import jayeson.service.delivery.ScopePersist;

@Singleton
public class ConfigLoader {
    public static final String EPF_CONFIG = "config";
    final ScopePersist scopeToPersist;
    final UserRepository userRepo;
    final ConfigRepository configRepo;

    @Inject
    public ConfigLoader(UserRepository userRepo, ConfigRepository configRepo, ScopePersist scopePersist) {
        this.userRepo = userRepo;
        this.configRepo = configRepo;
        this.scopeToPersist = scopePersist;
    }

    public void findConfigFor(ServerEndPoint socket, byte group, String stream) throws IOException {
        String username;
        User user;
        long configId;
        String scope = (String)socket.getData("scope");
        String puName = this.scopeToPersist.get(scope);
        SoccerFeedUserConfig config = this.configRepo.findById(puName, configId = (user = this.userRepo.findFeedUserByName(puName, username = (String)socket.getData("username"))).getConfigIdFor(group, stream));
        if (config == null) {
            throw new IOException("Cannot load configuration for " + scope + ":" + username);
        }
        socket.setData(EPF_CONFIG, (Object)config);
    }
}

