/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.session.AsyncSessionAccessor;
import jayeson.lib.session.SessionModel;
import jayeson.lib.session.SessionModelFactory;
import jayeson.lib.session.datastructure.AccessorSpecification;
import jayeson.lib.sports.dispatch.network.ScopedUser;
import jayeson.lib.sports.dispatch.network.SocketIdentity;
import jayeson.lib.sports.dispatch.network.SportsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SocketCounter {
    final SessionModel storage;
    final int ttlS;
    final Map<ScopedUser, Set<SocketIdentity>> localSockets;
    final Map<ScopedUser, Set<SocketIdentity>> removedSockets;
    final ScheduledExecutorService executor;
    static final int UPDATE_TIMEOUT_S = 7;
    static final Logger log = LoggerFactory.getLogger(SocketCounter.class);

    @Inject
    public SocketCounter(SessionModelFactory modelFactory, SportsConfig config, ScheduledExecutorService executor) {
        this.storage = modelFactory.getSessionModel(config.getSessionName());
        this.ttlS = config.getSocketMemoTtlS();
        this.localSockets = new HashMap<ScopedUser, Set<SocketIdentity>>();
        this.removedSockets = new ConcurrentHashMap<ScopedUser, Set<SocketIdentity>>();
        this.executor = executor;
        executor.submit(this::update);
    }

    public boolean hasSocket(String scope, String username, IEndPoint socket) {
        ScopedUser user = new ScopedUser(scope, username);
        if (this.localSockets.containsKey(user)) {
            SocketIdentity id = new SocketIdentity(socket);
            return this.localSockets.get(user).contains(id);
        }
        return false;
    }

    public void add(String scope, String username, IEndPoint socket) {
        ScopedUser user = new ScopedUser(scope, username);
        SocketIdentity id = new SocketIdentity(socket);
        this.localSockets.computeIfAbsent(user, k -> new HashSet()).add(id);
        Set<SocketIdentity> exSockets = this.removedSockets.get(user);
        if (exSockets != null) {
            exSockets.remove(new SocketIdentity(socket));
        }
        CompletionStage<AsyncSessionAccessor> session = this.getSessionFor(scope, username);
        CompletableFuture<Boolean> writeFuture = this.upsertUserSocket(session, id);
        writeFuture.exceptionally(exp -> {
            log.error("Error while adding user {} {} ", new Object[]{scope, user, exp});
            return false;
        });
        this.executor.schedule(() -> writeFuture.completeExceptionally(new TimeoutException()), 7L, TimeUnit.SECONDS);
    }

    public void remove(String scope, String username, IEndPoint socket) {
        ScopedUser user = new ScopedUser(scope, username);
        SocketIdentity id = new SocketIdentity(socket);
        this.localSockets.computeIfPresent(user, (u, sockets) -> {
            sockets.remove(id);
            if (sockets.isEmpty()) {
                return null;
            }
            return sockets;
        });
        this.removedSockets.computeIfAbsent(user, k -> new HashSet()).add(new SocketIdentity(socket));
        CompletionStage<AsyncSessionAccessor> session = this.getSessionFor(scope, username);
        CompletableFuture<Boolean> removeFuture = this.removeUserSocket(session, id);
        removeFuture.exceptionally(exp -> {
            log.error("Error while adding user {} {} ", new Object[]{scope, user, exp});
            return false;
        });
        this.executor.schedule(() -> removeFuture.completeExceptionally(new TimeoutException()), 7L, TimeUnit.SECONDS);
    }

    public CompletionStage<Integer> count(String scope, String username) {
        return this.getSessionFor(scope, username).thenCompose(session -> session.getKeys(".*")).thenApply(List::size);
    }

    CompletionStage<Void> update() {
        List upsertActions = this.localSockets.entrySet().stream().map(entry -> this.upsertUser(((ScopedUser)entry.getKey()).getScope(), ((ScopedUser)entry.getKey()).getUsername(), (Set)entry.getValue())).collect(Collectors.toList());
        List deleteActions = this.removedSockets.entrySet().stream().map(entry -> this.removeUser(((ScopedUser)entry.getKey()).getScope(), ((ScopedUser)entry.getKey()).getUsername(), (Set)entry.getValue())).collect(Collectors.toList());
        this.removedSockets.clear();
        ArrayList writeActions = new ArrayList(upsertActions);
        writeActions.addAll(deleteActions);
        CompletionStage<Void> whenWritten = this.within(this.waitForAll(writeActions), Duration.ofSeconds(7L));
        return whenWritten.exceptionally(e -> null).thenApply(result -> {
            this.executor.schedule(this::update, (long)(this.ttlS / 2), TimeUnit.SECONDS);
            return null;
        });
    }

    <T> CompletionStage<T> within(CompletionStage<T> future, Duration duration) {
        CompletionStage<T> timeout = this.failAfter(duration);
        return future.applyToEither(timeout, Function.identity());
    }

    <T> CompletionStage<T> failAfter(Duration duration) {
        CompletableFuture promise = new CompletableFuture();
        this.executor.schedule(() -> promise.completeExceptionally(new TimeoutException("Timeout after " + duration)), duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    CompletableFuture<Void> upsertUser(String scope, String username, Set<SocketIdentity> sockets) {
        CompletionStage<AsyncSessionAccessor> session = this.getSessionFor(scope, username);
        List userFuture = sockets.stream().map(sock -> this.upsertUserSocket(session, (SocketIdentity)sock)).collect(Collectors.toList());
        return this.waitForAll(userFuture);
    }

    CompletableFuture<Boolean> upsertUserSocket(CompletionStage<AsyncSessionAccessor> sessionStage, SocketIdentity socket) {
        return sessionStage.thenCompose(session -> session.write(socket.toString(), "", this.ttlS)).toCompletableFuture();
    }

    CompletableFuture<Void> removeUser(String scope, String username, Set<SocketIdentity> sockets) {
        CompletionStage<AsyncSessionAccessor> session = this.getSessionFor(scope, username);
        List userFuture = sockets.stream().map(sock -> this.removeUserSocket(session, (SocketIdentity)sock)).collect(Collectors.toList());
        return this.waitForAll(userFuture);
    }

    CompletableFuture<Boolean> removeUserSocket(CompletionStage<AsyncSessionAccessor> sessionStage, SocketIdentity socket) {
        return sessionStage.thenCompose(session -> session.remove(socket.toString())).toCompletableFuture();
    }

    <T> CompletableFuture<Void> waitForAll(List<CompletableFuture<T>> futures) {
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(futureArray);
    }

    CompletionStage<AsyncSessionAccessor> getSessionFor(String scope, String username) {
        return this.storage.getAccessor(new AccessorSpecification("sports_feed_pe", String.format("_sc_%s_%s", scope, username)));
    }
}

