/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.network;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.core.server.ServerEndPoint;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.dispatch.EPDispatcherException;
import jayeson.lib.sports.dispatch.network.ClientMsgHandler;
import jayeson.lib.sports.dispatch.network.ConfigLoader;
import jayeson.lib.sports.dispatch.network.FeedAccessChecker;
import jayeson.lib.sports.dispatch.network.FeedSubscriptions;
import jayeson.lib.sports.dispatch.network.SocketCounter;
import jayeson.lib.sports.dispatch.network.SocketIdentity;
import jayeson.lib.sports.dispatch.network.SportsConfig;
import jayeson.lib.sports.receive.InEndPointEventHandler;
import jayeson.lib.sports.receive.SportsFeedInConfig;
import jayeson.lib.sports.receive.SportsFeedInProcessor;
import jayeson.lib.sports.util.InjectLogger;
import jayeson.service.delivery.AbstractProcessingEngine;
import jayeson.service.delivery.IInProcessor;
import jayeson.service.delivery.IOutProcessor;
import org.slf4j.Logger;

@Singleton
public class SportsProcessingEngine
extends AbstractProcessingEngine {
    @InjectLogger
    Logger log;
    final SportsFeedMessageGroup msgGroup;
    final ClientMsgHandler outProcessor;
    final SportsFeedInProcessor inProcessor;
    final ConfigLoader configLoader;
    final FeedAccessChecker accessChecker;
    final SocketCounter userSockets;
    final FeedSubscriptions subscriptions;
    final InEndPointEventHandler inEventHandler;
    final SportsConfig sportsConfig;
    final Set<SocketIdentity> connectedSockets;

    @Inject
    public SportsProcessingEngine(SportsFeedMessageGroup msgGroup, ClientMsgHandler outProcessor, SportsFeedInProcessor inProcessor, ConfigLoader configLoader, FeedAccessChecker accessChecker, SocketCounter userSockets, FeedSubscriptions subscriptions, InEndPointEventHandler inEventHandler, SportsConfig soccerConfig, ScheduledExecutorService executor) {
        this.msgGroup = msgGroup;
        this.outProcessor = outProcessor;
        this.inProcessor = inProcessor;
        this.configLoader = configLoader;
        this.accessChecker = accessChecker;
        this.userSockets = userSockets;
        this.subscriptions = subscriptions;
        this.inEventHandler = inEventHandler;
        this.sportsConfig = soccerConfig;
        this.inProcessor.getRecycleBin().setTtlConfig(this.sportsConfig.getInConfig().getTtlConfig());
        this.connectedSockets = new HashSet<SocketIdentity>();
        this.startTTL(executor);
    }

    public void onStartUp() {
        this.getSubscriber().attachListener((IEndPointListener)this.inEventHandler);
        this.getSubscriber().attachMessageGroupProcessor((IMessageGroupProcessor)this.inProcessor);
        this.doAdvertisement();
    }

    private void startTTL(ScheduledExecutorService ses) {
        SportsFeedInConfig inConf = this.sportsConfig.getInConfig();
        if (inConf != null && inConf.isExcludeRateId()) {
            this.inEventHandler.excludeRateId();
        }
        this.inProcessor.startTTlVerification(ses);
    }

    private void doAdvertisement() {
        if (this.sportsConfig.getAggregatedStreamName() != null && !this.sportsConfig.getAggregatedStreamName().isEmpty()) {
            this.log.info("Advertising aggregated stream {} level {}", (Object)this.sportsConfig.getAggregatedStreamName(), (Object)this.sportsConfig.getLevel());
            this.getAdvertiser().advertise(this.getMessageGroup().id(), this.sportsConfig.getAggregatedStreamName(), this.sportsConfig.getLevel());
        } else if (!this.sportsConfig.getStreams().isEmpty()) {
            for (String stream : this.sportsConfig.getStreams()) {
                this.log.info("Advertising stream {} level {}", (Object)stream, (Object)this.sportsConfig.getLevel());
                this.getAdvertiser().advertise(this.getMessageGroup().id(), stream, this.sportsConfig.getLevel());
            }
        } else {
            this.log.info("No Aggregated Stream name or publishing stream names found. Stream based relayer setting is enabled.Readvertising received streams with increased level");
            this.getSubscriber().attachListener(new IEndPointListener(){

                public void onEvent(EPEvent event) {
                    SportsProcessingEngine.this.reAdvertise(event);
                }
            });
        }
    }

    private void reAdvertise(EPEvent event) {
        block3: {
            block2: {
                if (!(event instanceof ConsumptionStartEvent)) break block2;
                ConsumptionStartEvent castedEvent = (ConsumptionStartEvent)event;
                for (StreamId streamId : castedEvent.getStreams()) {
                    if (streamId.group.byteValue() != this.msgGroup.id()) continue;
                    this.log.info("Adding advertisement {} {} {}", new Object[]{streamId.group, streamId.stream, 2});
                    this.getAdvertiser().advertise(streamId.group.byteValue(), streamId.stream, 2);
                }
                break block3;
            }
            if (!(event instanceof ConsumptionErrorEvent)) break block3;
            for (StreamId streamId : ((ConsumptionErrorEvent)event).getStreams()) {
                if (streamId.group.byteValue() != this.msgGroup.id()) continue;
                this.log.info("Removing advertisement {} {}", (Object)streamId.group, (Object)streamId.stream);
                this.getAdvertiser().remove(streamId.group.byteValue(), streamId.stream);
            }
        }
    }

    protected synchronized boolean actOnStreamRegistrationRequest(IEndPoint ep, String stream) {
        try {
            this.configLoader.findConfigFor((ServerEndPoint)ep, this.msgGroup.id(), stream);
        }
        catch (IOException e) {
            this.log.debug(e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
            return false;
        }
        if (this.accessChecker.canConnect((ServerEndPoint)ep) && this.connectedSockets.contains(new SocketIdentity(ep))) {
            ServerEndPoint socket = (ServerEndPoint)ep;
            String scope = (String)socket.getData("scope");
            String username = (String)socket.getData("username");
            this.userSockets.add(scope, username, (IEndPoint)socket);
            this.subscriptions.add(ep, stream);
            return true;
        }
        return false;
    }

    protected synchronized boolean actOnStreamDeRegistrationRequest(IEndPoint ep, String stream) {
        try {
            this.subscriptions.remove(ep, stream);
        }
        catch (EPDispatcherException e) {
            this.log.error("", (Throwable)e);
        }
        return true;
    }

    protected synchronized void actOnEndPointAuthenticated(IEndPoint ep) {
        this.connectedSockets.add(new SocketIdentity(ep));
    }

    protected synchronized void actOnEndPointDiscontinued(IEndPoint ep) {
        this.connectedSockets.remove(new SocketIdentity(ep));
        Set consumingStreams = this.getStreamRegistry().getConsumingStreams(this.getMessageGroup().id(), ep);
        if (consumingStreams != null) {
            for (String stream : consumingStreams) {
                this.actOnStreamDeRegistrationRequest(ep, stream);
            }
        }
        this.removeSocket(ep);
    }

    protected void removeSocket(IEndPoint ep) {
        ServerEndPoint socket = (ServerEndPoint)ep;
        String scope = (String)socket.getData("scope");
        String username = (String)socket.getData("username");
        this.userSockets.remove(scope, username, (IEndPoint)socket);
    }

    protected void startPublishing(IEndPoint ep, String stream) {
    }

    public IMessageGroup getMessageGroup() {
        return this.msgGroup;
    }

    public IInProcessor getInProcessor() {
        return this.inProcessor;
    }

    public IOutProcessor getOutProcessor() {
        return this.outProcessor;
    }
}

