/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch.relay;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.core.TTLOutgoing;
import jayeson.lib.sports.core.TTLType;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.DeltaOutgoingImpl;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.dispatch.AbstractEPG;
import jayeson.lib.sports.dispatch.FullSnapshotWrapper;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.PartialSnapshotWrapper;
import jayeson.lib.sports.dispatch.SwitchFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.TTLSnapshotWrapper;
import jayeson.lib.sports.dispatch.UpdateFilterSnapshotWrapper;
import jayeson.lib.sports.dispatch.transform.MessageEncoder;
import jayeson.model.IDataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayEPG
extends AbstractEPG {
    private static Logger log = LoggerFactory.getLogger(RelayEPG.class);
    private MessageEncoder msgEncoder;

    @Inject
    public RelayEPG(ScheduledExecutorService executor, SportsFeedMessageGroup grp, MessageEncoder msgEncoder) {
        super(executor, grp);
        this.msgEncoder = msgEncoder;
        this.setInitialized(true);
    }

    @Override
    public void submitForProcess(IDispatchableWrapper wrap) {
        String queueName = this.generateQueueName(REPG_Q_TYPE.PROCESS_WRAPPER.id());
        CompletableFuture<Void> f = this.submitToQueue(queueName, wrap, wrap.process());
        f.exceptionally(this::onException);
    }

    public Void onException(Throwable e) {
        if (!(e instanceof CancellationException)) {
            log.error("Exception when dispatching snapshots to EPDs from FilteringEPG. ", e);
        }
        return null;
    }

    @Override
    public void submitForPostProcess(IDispatchableWrapper wrap) {
        String queueName = this.generateQueueName(REPG_Q_TYPE.PROCESSS_SPECIAL_WRAPPER.id());
        CompletionStage<Void> f = this.submitToQueue(queueName, wrap, wrap.postProcess());
        f = f.exceptionally(this::onException);
    }

    public List<Outgoing> serializeOutgoingMessages(Collection<Outgoing> messages) {
        ArrayList<Outgoing> result = new ArrayList<Outgoing>();
        for (Outgoing message : messages) {
            try {
                result.addAll(this.msgEncoder.encode(message, this.getSportsFeedGrp()));
            }
            catch (Exception exp) {
                log.error("Exception serializing message", (Throwable)exp);
            }
        }
        return result;
    }

    public List<Outgoing> generate(FullSnapshotWrapper wrapper) {
        try {
            IndexedSnapshot ss = wrapper.getFullSnapshot();
            ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
            messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().FULLSNAPSHOT_START));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_RESET, ss));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_MATCH, ss));
            messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_EVENT, ss));
            List matchesList = Lists.partition(new ArrayList(ss.matches()), (int)SnapshotUtil.SIZE_SPLIT_MATCH);
            for (List matches : matchesList) {
                IndexedSnapshotImpl delta = new IndexedSnapshotImpl(matches, ss.getPartitionMap());
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_ODD, delta));
            }
            messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().FULLSNAPSHOT_END));
            List<Outgoing> msg = this.serializeOutgoingMessages(messages);
            return msg;
        }
        catch (Exception exp) {
            log.error("Exception processing fullsnapshot wrapper", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    @Override
    public Collection<Outgoing> generate(PartialSnapshotWrapper wrapper) {
        try {
            DeltaOutgoing delta = wrapper.getDelta();
            if (delta instanceof TTLOutgoing) {
                try {
                    return this.generateTtl((TTLOutgoing)delta);
                }
                catch (Exception e) {
                    log.error("Exception generating TTL", (Throwable)e);
                }
            }
            List<Outgoing> msg = this.serializeOutgoingMessages(Arrays.asList(delta));
            return msg;
        }
        catch (Exception exp) {
            log.error("Exception processing partialsnapshot wrapper", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    @Override
    public Collection<Outgoing> generate(TTLSnapshotWrapper ttlWrapper, boolean fullSnapshot) {
        try {
            IndexedSnapshot ss = ttlWrapper.getFullSnapshot();
            ArrayList<Outgoing> messages = new ArrayList<Outgoing>();
            if (fullSnapshot) {
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().TTL_RESTORE_START, new IndexedSnapshotImpl(new HashMap<SportType, Collection<IBetMatch>>(), ss.getPartitions())));
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_MATCH, ss));
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_EVENT, ss));
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_ODD, ss, null, ss));
                messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().TTL_RESTORE_END));
            } else {
                messages.add(new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().TTL_RESTORE, new IndexedSnapshotImpl(new HashMap<SportType, Collection<IBetMatch>>(), ttlWrapper.getFullSnapshot().getPartitions())));
            }
            List<Outgoing> msg = this.serializeOutgoingMessages(messages);
            return msg;
        }
        catch (Exception exp) {
            log.error("Exception processing ttlsnapshot wrapper", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    @Override
    public Collection<Outgoing> generate(SwitchFilterSnapshotWrapper switchFilterWrapper) {
        try {
            IDataFilter oldFilter = switchFilterWrapper.getOldFilter();
            Collection<Outgoing> result = SnapshotUtil.getDiffSnapshots((IndexedSnapshot)switchFilterWrapper.getFullSnapshot(), (IDataFilter)oldFilter, null, (SportsFeedMessageGroup)this.getSportsFeedGrp()).messages;
            LinkedList<Outgoing> messages = new LinkedList<Outgoing>(result);
            messages.add(0, new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().SWITCH_FILTER_START, switchFilterWrapper.getRequestId()));
            messages.add(new OutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().SWITCH_FILTER_END));
            List<Outgoing> serializedMessages = this.serializeOutgoingMessages(result);
            return serializedMessages;
        }
        catch (Exception exp) {
            log.error("Exception processing switchfiltersnapshot wrapper", (Throwable)exp);
            return Arrays.asList(new Outgoing[0]);
        }
    }

    @Override
    public Collection<Outgoing> generate(UpdateFilterSnapshotWrapper updateFilterSnapshotWrapper) {
        throw new UnsupportedOperationException("Updating Filter is Not Applicable for Relay EPG");
    }

    private Collection<Outgoing> generateTtl(TTLOutgoing outGng) throws Exception {
        if (outGng.msgType().isSameFormat((IMessageClass)this.getSportsFeedGrp().ADMIN_REFRESH)) {
            return Arrays.asList(new Outgoing[0]);
        }
        TTLType ttlType = outGng.getTtlType();
        if (ttlType == TTLType.REMOVE) {
            ArrayList<Outgoing> msg = new ArrayList<Outgoing>();
            msg.addAll(this.msgEncoder.encode(outGng, this.getSportsFeedGrp()));
            return msg;
        }
        return this.generateTtlRestore(outGng);
    }

    private Collection<Outgoing> generateTtlRestore(TTLOutgoing outGng) {
        DeltaOutgoingImpl insertMatch = new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_MATCH, outGng.delta());
        DeltaOutgoingImpl insertEvent = new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_EVENT, outGng.delta());
        DeltaOutgoingImpl insertRecord = new DeltaOutgoingImpl((IMessageClass<?>)this.getSportsFeedGrp().DATA_INSERT_ODD, outGng.after(), null, outGng.delta());
        List<Outgoing> messages = Arrays.asList(insertMatch, insertEvent, insertRecord);
        List<Outgoing> serializedMessages = this.serializeOutgoingMessages(messages);
        return serializedMessages;
    }

    @Override
    public void cleanUp() {
        String normalQueue = this.generateQueueName(REPG_Q_TYPE.PROCESS_WRAPPER.id());
        String specialQueue = this.generateQueueName(REPG_Q_TYPE.PROCESSS_SPECIAL_WRAPPER.id());
        this.workers.clear(normalQueue);
        this.workers.clear(specialQueue);
    }

    static enum REPG_Q_TYPE {
        PROCESS_WRAPPER("relay-wrapper-processing:%s"),
        PROCESSS_SPECIAL_WRAPPER("relay-special-wrapper-processing:%s");

        private final String id;

        private REPG_Q_TYPE(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }
    }
}

