/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import java.util.Map;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.LBType;
import jayeson.lib.feed.api.OddFormat;
import jayeson.lib.feed.api.OddType;
import jayeson.lib.feed.api.TimeType;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.feed.api.twoside.PivotBias;
import jayeson.lib.feed.api.twoside.PivotType;
import jayeson.lib.sports.mutable.IBetRecordBuilder;

public abstract class B2RecordBuilder
implements IBetRecordBuilder {
    protected String eventId;
    protected String matchId;
    protected long id;
    protected OddType oddType;
    protected LBType lbType;
    protected TimeType timetype;
    protected String sportbook;
    protected Map<String, String> meta;
    protected OddFormat oddFormat;
    protected float rateOver;
    protected float rateUnder;
    protected float rateEqual;
    protected float pivotValue;
    protected PivotType pivotType;
    protected PivotBias pivotBias;
    protected String rateOverId;
    protected String rateUnderId;
    protected String rateEqualId;
    protected boolean isSwapped;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public void setMatchId(String matchId) {
        this.matchId = matchId;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setOddType(OddType oddType) {
        this.oddType = oddType;
    }

    public void setLbType(LBType lbType) {
        this.lbType = lbType;
    }

    public void setTimetype(TimeType timetype) {
        this.timetype = timetype;
    }

    public void setSportbook(String sportbook) {
        this.sportbook = sportbook;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public void setOddFormat(OddFormat oddFormat) {
        this.oddFormat = oddFormat;
    }

    public void setRateOver(float rateOver) {
        this.rateOver = rateOver;
    }

    public void setRateUnder(float rateUnder) {
        this.rateUnder = rateUnder;
    }

    public void setRateEqual(float rateEqual) {
        this.rateEqual = rateEqual;
    }

    public void setPivotValue(float pivotValue) {
        this.pivotValue = pivotValue;
    }

    public void setPivotType(PivotType pivotType) {
        this.pivotType = pivotType;
    }

    public void setPivotBias(PivotBias pivotBias) {
        this.pivotBias = pivotBias;
    }

    public void setRateOverId(String rateOverId) {
        this.rateOverId = rateOverId;
    }

    public void setRateUnderId(String rateUnderId) {
        this.rateUnderId = rateUnderId;
    }

    public void setRateEqualId(String rateEqualId) {
        this.rateEqualId = rateEqualId;
    }

    public void setSwapped(boolean isSwapped) {
        this.isSwapped = isSwapped;
    }

    public void mergeFrom(IBetRecord record) {
        if (!(record instanceof IB2Record)) {
            throw new IllegalArgumentException("Expected record for IB2Builder is IB2Record");
        }
        IB2Record rec = (IB2Record)record;
        this.eventId = rec.eventId();
        this.matchId = rec.matchId();
        this.id = rec.id();
        this.oddType = rec.oddType();
        this.lbType = rec.lbType();
        this.timetype = rec.timeType();
        this.sportbook = rec.source();
        this.meta = rec.meta();
        this.oddFormat = rec.oddFormat();
        this.rateOver = rec.rateOver();
        this.rateUnder = rec.rateUnder();
        this.rateEqual = rec.rateEqual();
        this.pivotValue = rec.pivotValue();
        this.pivotType = rec.pivotType();
        this.pivotBias = rec.pivotBias();
        this.rateOverId = rec.rateOverId();
        this.rateUnderId = rec.rateUnderId();
        this.rateEqualId = rec.rateEqualId();
        this.isSwapped = rec.isSwapped();
    }

    public B2RecordBuilder(IBetRecord rec) {
        this.mergeFrom(rec);
    }

    @Override
    public void merge(IBetRecord rec) {
        IB2Record b2Rec = (IB2Record)rec;
        this.setRateOver(b2Rec.rateOver());
        this.setRateUnder(b2Rec.rateUnder());
        this.setRateEqual(b2Rec.rateEqual());
        if (b2Rec.rateOverId() != null && !b2Rec.rateOverId().isEmpty()) {
            this.setRateOverId(b2Rec.rateOverId());
        }
        if (b2Rec.rateUnderId() != null && !b2Rec.rateUnderId().isEmpty()) {
            this.setRateUnderId(b2Rec.rateUnderId());
        }
        if (b2Rec.rateEqualId() != null && !b2Rec.rateEqualId().isEmpty()) {
            this.setRateEqualId(b2Rec.rateEqualId());
        }
    }
}

