/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.basketball.BasketballEventImpl;
import jayeson.lib.feed.basketball.BasketballEventState;
import jayeson.lib.feed.basketball.BasketballGender;
import jayeson.lib.feed.basketball.BasketballMatch;
import jayeson.lib.feed.basketball.BasketballMatchImpl;
import jayeson.lib.feed.basketball.BasketballRecord;
import jayeson.lib.feed.basketball.BasketballRecordImpl;
import jayeson.lib.feed.basketball.BasketballSegment;
import jayeson.lib.feed.soccer.LeagueType;
import jayeson.lib.feed.soccer.SoccerEventImpl;
import jayeson.lib.feed.soccer.SoccerEventState;
import jayeson.lib.feed.soccer.SoccerEventType;
import jayeson.lib.feed.soccer.SoccerGender;
import jayeson.lib.feed.soccer.SoccerMatch;
import jayeson.lib.feed.soccer.SoccerMatchImpl;
import jayeson.lib.feed.soccer.SoccerRecord;
import jayeson.lib.feed.soccer.SoccerRecordImpl;
import jayeson.lib.feed.soccer.SoccerSegment;
import jayeson.lib.feed.tennis.TennisEventImpl;
import jayeson.lib.feed.tennis.TennisEventState;
import jayeson.lib.feed.tennis.TennisEventType;
import jayeson.lib.feed.tennis.TennisGender;
import jayeson.lib.feed.tennis.TennisMatch;
import jayeson.lib.feed.tennis.TennisMatchImpl;
import jayeson.lib.feed.tennis.TennisRecord;
import jayeson.lib.feed.tennis.TennisRecordImpl;
import jayeson.lib.feed.tennis.TennisSegment;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.mutable.B2EventBuilder;
import jayeson.lib.sports.mutable.B2EventStateBuilder;
import jayeson.lib.sports.mutable.B2MatchBuilder;
import jayeson.lib.sports.mutable.B2RecordBuilder;
import jayeson.lib.sports.mutable.IndexedSnapshotBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder {
    private static Logger log = LoggerFactory.getLogger(Builder.class);

    public static class EventState {

        public static class Basketball
        extends B2EventStateBuilder {
            private BasketballSegment segment;
            private boolean isTimeout;
            private int bookPriority;

            public Basketball(IBetEventState state) {
                super(state);
            }

            @Override
            public IBetEventState build() {
                return new BasketballEventState(this.statsOne, this.statsTwo, this.duration, this.key, this.matchId, this.eventId, this.segment, this.isTimeout, this.bookPriority);
            }

            public void setBookPriority(int bookPriority) {
                this.bookPriority = bookPriority;
            }

            public void setSegment(BasketballSegment segment) {
                this.segment = segment;
            }

            public void setTimeout(boolean isTimeout) {
                this.isTimeout = isTimeout;
            }

            @Override
            public void mergeFrom(IBetEventState state) {
                super.mergeFrom(state);
                BasketballEventState be = (BasketballEventState)state;
                this.setSegment(be.segment());
                this.setTimeout(be.isTimeout());
                this.setBookPriority(be.bookPriority());
            }
        }

        public static class Tennis
        extends B2EventStateBuilder {
            private int set;
            private int game;
            private int bookPriority;
            private TennisSegment segment;

            public Tennis(IBetEventState state) {
                super(state);
            }

            @Override
            public IBetEventState build() {
                return new TennisEventState(this.statsOne, this.statsTwo, this.duration, this.key, this.matchId, this.eventId, this.set, this.game, this.segment, this.bookPriority);
            }

            public void setSet(int set) {
                this.set = set;
            }

            public void setGame(int game) {
                this.game = game;
            }

            public void setSegment(TennisSegment segment) {
                this.segment = segment;
            }

            public void setBookPriority(int bookPriority) {
                this.bookPriority = bookPriority;
            }

            @Override
            public void mergeFrom(IBetEventState state) {
                super.mergeFrom(state);
                TennisEventState st = (TennisEventState)state;
                this.setSet(st.set());
                this.setGame(st.game());
                this.setSegment(st.segment());
                this.setBookPriority(st.bookPriority());
            }
        }

        public static class Soccer
        extends B2EventStateBuilder {
            private int hostScore;
            private int hostCard;
            public int guestScore;
            private int guestCard;
            private SoccerSegment segment;
            private int bookPriority;

            public Soccer(IBetEventState state) {
                super(state);
            }

            @Override
            public IBetEventState build() {
                return new SoccerEventState(this.duration, this.key, this.matchId, this.eventId, this.hostScore, this.guestScore, this.hostCard, this.guestCard, this.segment, this.bookPriority);
            }

            public void setHostScore(int hostScore) {
                this.hostScore = hostScore;
            }

            public void setHostCard(int hostCard) {
                this.hostCard = hostCard;
            }

            public void setGuestScore(int guestScore) {
                this.guestScore = guestScore;
            }

            public void setGuestCard(int guestCard) {
                this.guestCard = guestCard;
            }

            public void setSegment(SoccerSegment segment) {
                this.segment = segment;
            }

            public void setBookPriority(int bookPriority) {
                this.bookPriority = bookPriority;
            }

            @Override
            public void mergeFrom(IBetEventState match) {
                super.mergeFrom(match);
                SoccerEventState se = (SoccerEventState)match;
                this.setHostCard(se.hostCard());
                this.setGuestCard(se.guestCard());
                this.setHostScore(se.hostScore());
                this.setGuestScore(se.guestScore());
                this.setSegment(se.segment());
                this.setBookPriority(se.bookPriority());
            }

            @Override
            public void merge(IBetEventState state) {
                super.merge(state);
                SoccerEventState se = (SoccerEventState)state;
                if (se.segment() != null) {
                    this.setSegment(se.segment());
                }
            }
        }
    }

    public static class Record {

        public static class Basketball
        extends B2RecordBuilder {
            public Basketball(IBetRecord rec) {
                super(rec);
            }

            @Override
            public BasketballRecord build() {
                return new BasketballRecordImpl(this.matchId, this.eventId, this.id, this.oddType, this.lbType, this.timetype, this.sportbook, this.oddFormat, this.meta, this.rateOver, this.rateUnder, this.rateEqual, this.pivotValue, this.pivotType, this.pivotBias, this.rateOverId, this.rateUnderId, this.rateEqualId, this.isSwapped);
            }
        }

        public static class Soccer
        extends B2RecordBuilder {
            public Soccer(IBetRecord rec) {
                super(rec);
            }

            @Override
            public SoccerRecord build() {
                return new SoccerRecordImpl(this.matchId, this.eventId, this.id, this.oddType, this.lbType, this.timetype, this.sportbook, this.oddFormat, this.meta, this.rateOver, this.rateUnder, this.rateEqual, this.pivotValue, this.pivotType, this.pivotBias, this.rateOverId, this.rateUnderId, this.rateEqualId, this.isSwapped);
            }
        }

        public static class Tennis
        extends B2RecordBuilder {
            public Tennis(IBetRecord rec) {
                super(rec);
            }

            @Override
            public TennisRecord build() {
                return new TennisRecordImpl(this.matchId, this.eventId, this.id, this.oddType, this.lbType, this.timetype, this.sportbook, this.oddFormat, this.meta, this.rateOver, this.rateUnder, this.rateEqual, this.pivotValue, this.pivotType, this.pivotBias, this.rateOverId, this.rateUnderId, this.rateEqualId, this.isSwapped);
            }
        }
    }

    public static class Event {

        public static class Basketball
        extends B2EventBuilder {
            public Basketball(IBetEvent event, boolean cloneChildren) {
                super(event, cloneChildren);
            }

            @Override
            public IBetEvent build() {
                return new BasketballEventImpl(this.id, this.records.values(), this.states.values(), this.matchId, this.type, this.meta);
            }
        }

        public static class Soccer
        extends B2EventBuilder {
            public Soccer(IBetEvent event, boolean cloneChildren) {
                super(event, cloneChildren);
            }

            @Override
            public IBetEvent build() {
                return new SoccerEventImpl(this.id, this.records.values(), this.states.values(), this.matchId, (SoccerEventType)this.type, this.meta);
            }
        }

        public static class Tennis
        extends B2EventBuilder {
            public Tennis(IBetEvent event, boolean cloneChildren) {
                super(event, cloneChildren);
            }

            @Override
            public IBetEvent build() {
                return new TennisEventImpl(this.id, this.records.values(), this.states.values(), this.matchId, (TennisEventType)this.type, this.meta);
            }
        }
    }

    public static class Match {

        public static class Basketball
        extends B2MatchBuilder {
            protected BasketballGender gender;
            protected String country;

            public Basketball(IBetMatch t, boolean cloneChildren) {
                super(t, cloneChildren);
            }

            public void setGender(BasketballGender gender) {
                this.gender = gender;
            }

            public void setCountry(String country) {
                this.country = country;
            }

            @Override
            public IBetMatch build() {
                return new BasketballMatchImpl(this.p1, this.p2, this.startTime, this.events.values(), this.id, this.league, this.gender, this.country, this.meta);
            }

            @Override
            public void mergeFrom(IBetMatch match, boolean cloneChildren) {
                super.mergeFrom(match, cloneChildren);
                BasketballMatch bm = (BasketballMatch)match;
                this.setGender(bm.gender());
                this.setCountry(bm.getCountry());
            }
        }

        public static class Soccer
        extends B2MatchBuilder {
            LeagueType leagueType;
            SoccerGender gender;
            String country;

            public Soccer(IBetMatch t, boolean cloneChildren) {
                super(t, cloneChildren);
            }

            public void setLeagueType(LeagueType leagueType) {
                this.leagueType = leagueType;
            }

            public void setGender(SoccerGender gender) {
                this.gender = gender;
            }

            public void setCountry(String country) {
                this.country = country;
            }

            @Override
            public void mergeFrom(IBetMatch t, boolean cloneChildren) {
                super.mergeFrom(t, cloneChildren);
                SoccerMatch sm = (SoccerMatch)t;
                this.setLeagueType(sm.leagueType());
                this.setCountry(sm.getCountry());
                this.setGender(sm.gender());
            }

            @Override
            public IBetMatch build() {
                return new SoccerMatchImpl(this.p1, this.p2, this.startTime, this.events.values(), this.id, this.league, this.meta, this.leagueType, this.gender, this.country);
            }
        }

        public static class Tennis
        extends B2MatchBuilder {
            TennisGender gender;
            String country;

            public Tennis(IBetMatch t, boolean cloneChildren) {
                super(t, cloneChildren);
            }

            public void setGender(TennisGender gender) {
                this.gender = gender;
            }

            public void setCountry(String country) {
                this.country = country;
            }

            @Override
            public void mergeFrom(IBetMatch t, boolean cloneChildren) {
                super.mergeFrom(t, cloneChildren);
                TennisMatch tm = (TennisMatch)t;
                this.setGender(tm.gender());
                this.setCountry(tm.getCountry());
            }

            @Override
            public IBetMatch build() {
                return new TennisMatchImpl(this.p1, this.p2, this.startTime, this.events.values(), this.id, this.league, this.gender, this.country, this.meta);
            }
        }
    }

    public static class Snapshot
    extends IndexedSnapshotBuilder {
        public Snapshot(IndexedSnapshot input) {
            super(input);
        }

        public Snapshot(IndexedSnapshot input, boolean copyPartitions) {
            super(input, copyPartitions);
        }
    }
}

