/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.mutable;

import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.basketball.BasketballEvent;
import jayeson.lib.feed.basketball.BasketballEventState;
import jayeson.lib.feed.basketball.BasketballMatch;
import jayeson.lib.feed.basketball.BasketballRecord;
import jayeson.lib.feed.soccer.SoccerEvent;
import jayeson.lib.feed.soccer.SoccerEventState;
import jayeson.lib.feed.soccer.SoccerMatch;
import jayeson.lib.feed.soccer.SoccerRecord;
import jayeson.lib.feed.tennis.TennisEvent;
import jayeson.lib.feed.tennis.TennisEventState;
import jayeson.lib.feed.tennis.TennisMatch;
import jayeson.lib.feed.tennis.TennisRecord;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.mutable.Builder;
import jayeson.lib.sports.mutable.IBetEventBuilder;
import jayeson.lib.sports.mutable.IBetEventStateBuilder;
import jayeson.lib.sports.mutable.IBetMatchBuilder;
import jayeson.lib.sports.mutable.IBetRecordBuilder;
import jayeson.lib.sports.mutable.IIndexedSnapshotBuilder;

public class BuilderProvider {
    public static IBetMatchBuilder getBuilder(IBetMatch match) {
        return BuilderProvider.getBuilder(match, true);
    }

    public static IBetMatchBuilder getBuilder(IBetMatch match, boolean cloneChildren) {
        if (match instanceof SoccerMatch) {
            return new Builder.Match.Soccer(match, cloneChildren);
        }
        if (match instanceof TennisMatch) {
            return new Builder.Match.Tennis(match, cloneChildren);
        }
        if (match instanceof BasketballMatch) {
            return new Builder.Match.Basketball(match, cloneChildren);
        }
        throw new UnsupportedOperationException("Cannot Create Builder for " + match.getClass());
    }

    public static IBetEventBuilder getBuilder(IBetEvent event) {
        return BuilderProvider.getBuilder(event, true);
    }

    public static IBetEventBuilder getBuilder(IBetEvent event, boolean cloneChildren) {
        if (event instanceof SoccerEvent) {
            return new Builder.Event.Soccer(event, cloneChildren);
        }
        if (event instanceof TennisEvent) {
            return new Builder.Event.Tennis(event, cloneChildren);
        }
        if (event instanceof BasketballEvent) {
            return new Builder.Event.Basketball(event, cloneChildren);
        }
        throw new UnsupportedOperationException("Cannot Create Builder for " + event.getClass());
    }

    public static IBetRecordBuilder getBuilder(IBetRecord record) {
        if (record instanceof SoccerRecord) {
            return new Builder.Record.Soccer(record);
        }
        if (record instanceof TennisRecord) {
            return new Builder.Record.Tennis(record);
        }
        if (record instanceof BasketballRecord) {
            return new Builder.Record.Basketball(record);
        }
        throw new UnsupportedOperationException("Cannot Create Builder for " + record.getClass());
    }

    public static IBetEventStateBuilder getBuilder(IBetEventState state) {
        if (state instanceof SoccerEventState) {
            return new Builder.EventState.Soccer(state);
        }
        if (state instanceof TennisEventState) {
            return new Builder.EventState.Tennis(state);
        }
        if (state instanceof BasketballEventState) {
            return new Builder.EventState.Basketball(state);
        }
        throw new UnsupportedOperationException("Cannot Create Builder for " + state.getClass());
    }

    public static IIndexedSnapshotBuilder getSnapshotBuilder(IndexedSnapshot parentSs) {
        return new Builder.Snapshot(parentSs);
    }

    public static IIndexedSnapshotBuilder getSnapshotBuilder(IndexedSnapshot parentSs, boolean copyPartitions) {
        return new Builder.Snapshot(parentSs, copyPartitions);
    }
}

