/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.protobuf.Sports;
import org.apache.commons.lang3.ArrayUtils;

public class PbufToApiConverter {
    private static final String SEPARATOR = ",";

    public static SportType asSportType(Sports.SportType pbuf) {
        return SportType.valueOf((String)pbuf.name());
    }

    public static String addKey(String existing, String incoming) {
        if (!existing.contains(incoming)) {
            StringBuilder b = new StringBuilder(existing);
            b.append(SEPARATOR).append(incoming);
            return b.toString();
        }
        return existing;
    }

    public static String removeKey(String existing, String incomingStr) {
        Object[] split = existing.split(SEPARATOR);
        String[] incomingArr = incomingStr.split(SEPARATOR);
        Arrays.sort(split);
        for (String incoming : incomingArr) {
            int index = Arrays.binarySearch(split, incoming);
            if (index < 0 || (split = (String[])ArrayUtils.remove((Object[])split, (int)index)).length != 0) continue;
            return "";
        }
        Object finalString = split[0];
        for (int i = 1; i < split.length; ++i) {
            finalString = PbufToApiConverter.addKey((String)finalString, (String)split[i]);
        }
        return finalString;
    }

    public static boolean containsKey(String existing, String incoming) {
        if (incoming.contains(SEPARATOR)) {
            throw new IllegalArgumentException("Incoming String cannot contain Separator: , Incoming: " + incoming);
        }
        Object[] split = existing.split(SEPARATOR);
        Arrays.sort(split);
        int index = Arrays.binarySearch(split, incoming);
        return index >= 0;
    }

    public static List<PartitionKey> getParitionKeys(String existing) {
        String[] split = existing.split(SEPARATOR);
        ArrayList<PartitionKey> keys = new ArrayList<PartitionKey>();
        for (String str : split) {
            keys.add(PartitionKey.fromString((String)str));
        }
        return keys;
    }
}

