/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.sslconfig.ssl.AlgorithmChecker;
import com.typesafe.sslconfig.ssl.AlgorithmConstraint;
import com.typesafe.sslconfig.ssl.AlgorithmConstraintsParser$;
import com.typesafe.sslconfig.ssl.Ciphers$;
import com.typesafe.sslconfig.ssl.ConfigSSLContextBuilder;
import com.typesafe.sslconfig.ssl.DefaultKeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.DefaultTrustManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.KeyManagerFactoryWrapper;
import com.typesafe.sslconfig.ssl.Protocols$;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.ssl.TrustManagerFactoryWrapper;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcConfigBuilder$;
import play.api.libs.ws.ahc.AhcLoggerFactory;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import play.shaded.ahc.io.netty.handler.ssl.SslContextBuilder;
import play.shaded.ahc.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.SslEngineFactory;
import play.shaded.ahc.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006c\u0001!\tA\r\u0005\bk\u0001\u0011\r\u0011\"\u00057\u0011\u0019I\u0005\u0001)A\u0005o!9!\n\u0001b\u0001\n\u0003Y\u0005B\u0002'\u0001A\u0003%!\b\u0003\u0005N\u0001\t\u0007I\u0011\u0001\u000eO\u0011\u00191\u0006\u0001)A\u0005\u001f\"Aq\u000b\u0001b\u0001\n\u0003Q\u0002\f\u0003\u0004]\u0001\u0001\u0006I!\u0017\u0005\u0006;\u0002!\tA\u0018\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006I\u0002!\t!\u001a\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u001dI\u00111\n\u000e\u0002\u0002#\u0005\u0011Q\n\u0004\t3i\t\t\u0011#\u0001\u0002P!1\u0011G\u0006C\u0001\u0003#B\u0011\"a\u0015\u0017#\u0003%\t!!\u0016\u0003!\u0005C7mQ8oM&<')^5mI\u0016\u0014(BA\u000e\u001d\u0003\r\t\u0007n\u0019\u0006\u0003;y\t!a^:\u000b\u0005}\u0001\u0013\u0001\u00027jENT!!\t\u0012\u0002\u0007\u0005\u0004\u0018NC\u0001$\u0003\u0011\u0001H.Y=\u0004\u0001M\u0011\u0001A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\u0013\u0005D7mQ8oM&<\u0007C\u0001\u00180\u001b\u0005Q\u0012B\u0001\u0019\u001b\u0005E\t\u0005nY,T\u00072LWM\u001c;D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M\"\u0004C\u0001\u0018\u0001\u0011\u001da#\u0001%AA\u00025\n\u0011#\u00193e\u0007V\u001cHo\\7TKR$\u0018N\\4t+\u00059\u0004\u0003B\u00149uiJ!!\u000f\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u001eG\u001d\taD)D\u0001>\u0015\tqt(A\bbgft7\r\u001b;ua\u000ed\u0017.\u001a8u\u0015\t\u0001\u0015)A\u0002pe\u001eT!a\u0007\"\u000b\u0005\r\u0013\u0013AB:iC\u0012,G-\u0003\u0002F{\u0005aB)\u001a4bk2$\u0018i]=oG\"#H\u000f]\"mS\u0016tGoQ8oM&<\u0017BA$I\u0005\u001d\u0011U/\u001b7eKJT!!R\u001f\u0002%\u0005$GmQ;ti>l7+\u001a;uS:<7\u000fI\u0001\bEVLG\u000eZ3s+\u0005Q\u0014\u0001\u00032vS2$WM\u001d\u0011\u0002\r1|wmZ3s+\u0005y\u0005C\u0001)U\u001b\u0005\t&B\u0001*T\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0015BA+R\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u00047pO\u001e,'OR1di>\u0014\u00180F\u0001Z!\tq#,\u0003\u0002\\5\t\u0001\u0012\t[2M_\u001e<WM\u001d$bGR|'/_\u0001\u000fY><w-\u001a:GC\u000e$xN]=!\u0003%\u0019wN\u001c4jOV\u0014X\rF\u0001;\u0003\u0015\u0011W/\u001b7e)\u0005\t\u0007C\u0001\u001fc\u0013\t\u0019WHA\u000bBgft7\r\u0013;ua\u000ec\u0017.\u001a8u\u0007>tg-[4\u0002!5|G-\u001b4z+:$WM\u001d7zS:<GCA\u001ag\u0011\u00159W\u00021\u00018\u0003\u0019iw\u000eZ5gs\u0006Y1m\u001c8gS\u001e,(/Z,T)\tQW\u000e\u0005\u0002(W&\u0011A\u000e\u000b\u0002\u0005+:LG\u000fC\u0003-\u001d\u0001\u0007Q&\u0001\nd_:4\u0017nZ;sKB\u0013x\u000e^8d_2\u001cH\u0003\u00029\u007f\u0003\u0003\u00012aJ9t\u0013\t\u0011\bFA\u0003BeJ\f\u0017\u0010\u0005\u0002uw:\u0011Q/\u001f\t\u0003m\"j\u0011a\u001e\u0006\u0003q\u0012\na\u0001\u0010:p_Rt\u0014B\u0001>)\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005iD\u0003\"B@\u0010\u0001\u0004\u0001\u0018!E3ySN$\u0018N\\4Qe>$xnY8mg\"9\u00111A\bA\u0002\u0005\u0015\u0011!C:tY\u000e{gNZ5h!\u0011\t9!!\u0007\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t1a]:m\u0015\u0011\ty!!\u0005\u0002\u0013M\u001cHnY8oM&<'\u0002BA\n\u0003+\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003/\t1aY8n\u0013\u0011\tY\"!\u0003\u0003#M\u001bFjQ8oM&<7+\u001a;uS:<7/A\u000bd_:4\u0017nZ;sK\u000eK\u0007\u000f[3s'VLG/Z:\u0015\u000bA\f\t#!\n\t\r\u0005\r\u0002\u00031\u0001q\u0003=)\u00070[:uS:<7)\u001b9iKJ\u001c\bbBA\u0002!\u0001\u0007\u0011QA\u0001\rG>tg-[4ve\u0016\u001c6\u000b\u0014\u000b\u0004U\u0006-\u0002bBA\u0002#\u0001\u0007\u0011QA\u0001\u0017EVLG\u000eZ&fs6\u000bg.Y4fe\u001a\u000b7\r^8ssR!\u0011\u0011GA\u001c!\u0011\t9!a\r\n\t\u0005U\u0012\u0011\u0002\u0002\u0019\u0017\u0016LX*\u00198bO\u0016\u0014h)Y2u_JLxK]1qa\u0016\u0014\bbBA\u0006%\u0001\u0007\u0011QA\u0001\u0019EVLG\u000e\u001a+skN$X*\u00198bO\u0016\u0014h)Y2u_JLH\u0003BA\u001f\u0003\u0007\u0002B!a\u0002\u0002@%!\u0011\u0011IA\u0005\u0005i!&/^:u\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z/J\f\u0007\u000f]3s\u0011\u001d\tYa\u0005a\u0001\u0003\u000b\t1D^1mS\u0012\fG/\u001a#fM\u0006,H\u000e\u001e+skN$X*\u00198bO\u0016\u0014Hc\u00016\u0002J!9\u00111\u0001\u000bA\u0002\u0005\u0015\u0011\u0001E!iG\u000e{gNZ5h\u0005VLG\u000eZ3s!\tqcc\u0005\u0002\u0017MQ\u0011\u0011QJ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]#fA\u0017\u0002Z-\u0012\u00111\f\t\u0005\u0003;\n9'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003%)hn\u00195fG.,GMC\u0002\u0002f!\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI'a\u0018\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class AhcConfigBuilder {
    public final AhcWSClientConfig play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig;
    private final Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings;
    private final DefaultAsyncHttpClientConfig.Builder builder;
    private final Logger logger;
    private final AhcLoggerFactory loggerFactory;

    public static AhcWSClientConfig $lessinit$greater$default$1() {
        return AhcConfigBuilder$.MODULE$.$lessinit$greater$default$1();
    }

    public Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings() {
        return this.addCustomSettings;
    }

    public DefaultAsyncHttpClientConfig.Builder builder() {
        return this.builder;
    }

    public Logger logger() {
        return this.logger;
    }

    public AhcLoggerFactory loggerFactory() {
        return this.loggerFactory;
    }

    public DefaultAsyncHttpClientConfig.Builder configure() {
        WSClientConfig config = this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig.wsClientConfig();
        this.configureWS(this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig);
        this.configureSSL(config.ssl());
        return (DefaultAsyncHttpClientConfig.Builder)this.addCustomSettings().apply((Object)this.builder());
    }

    public AsyncHttpClientConfig build() {
        return this.configure().build();
    }

    public AhcConfigBuilder modifyUnderlying(Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> modify) {
        return new AhcConfigBuilder(this, modify){
            private final Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings;
            private final DefaultAsyncHttpClientConfig.Builder builder;

            public Function1<DefaultAsyncHttpClientConfig.Builder, DefaultAsyncHttpClientConfig.Builder> addCustomSettings() {
                return this.addCustomSettings;
            }

            public DefaultAsyncHttpClientConfig.Builder builder() {
                return this.builder;
            }
            {
                this.addCustomSettings = modify$1.compose($outer.addCustomSettings());
                this.builder = $outer.builder();
            }
        };
    }

    public void configureWS(AhcWSClientConfig ahcConfig) {
        block0: {
            WSClientConfig config = ahcConfig.wsClientConfig();
            this.builder().setConnectTimeout(AhcConfigBuilder.toMillis$1(config.connectionTimeout())).setReadTimeout(AhcConfigBuilder.toMillis$1(config.idleTimeout())).setRequestTimeout(AhcConfigBuilder.toMillis$1(config.requestTimeout())).setFollowRedirect(config.followRedirects()).setUseProxyProperties(config.useProxyProperties()).setCompressionEnforced(config.compressionEnabled());
            config.userAgent().foreach((Function1 & Serializable & scala.Serializable)x$1 -> this.builder().setUserAgent(x$1));
            this.builder().setMaxConnectionsPerHost(ahcConfig.maxConnectionsPerHost());
            this.builder().setMaxConnections(ahcConfig.maxConnectionsTotal());
            this.builder().setConnectionTtl(AhcConfigBuilder.toMillis$1(ahcConfig.maxConnectionLifetime()));
            this.builder().setPooledConnectionIdleTimeout(AhcConfigBuilder.toMillis$1(ahcConfig.idleConnectionInPoolTimeout()));
            this.builder().setMaxRedirects(ahcConfig.maxNumberOfRedirects());
            this.builder().setMaxRequestRetry(ahcConfig.maxRequestRetry());
            this.builder().setDisableUrlEncodingForBoundRequests(ahcConfig.disableUrlEncoding());
            this.builder().setKeepAlive(ahcConfig.keepAlive());
            this.builder().setShutdownQuietPeriod(0);
            this.builder().setShutdownTimeout(0);
            this.builder().setUseLaxCookieEncoder(ahcConfig.useLaxCookieEncoder());
            if (ahcConfig.useCookieStore()) break block0;
            this.builder().setCookieStore(null);
        }
    }

    public String[] configureProtocols(String[] existingProtocols, SSLConfigSettings sslConfig) {
        String[] definedProtocols;
        block4: {
            String[] stringArray;
            Option option = sslConfig.enabledProtocols();
            if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Seq configuredProtocols = (scala.collection.immutable.Seq)some.value();
                Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
                stringArray = (String[])((TraversableOnce)configuredProtocols.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AhcConfigBuilder.$anonfun$configureProtocols$1(objectArray, elem)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else if (None$.MODULE$.equals(option)) {
                Object[] objectArray = Predef$.MODULE$.refArrayOps((Object[])existingProtocols);
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Protocols$.MODULE$.recommendedProtocols())).filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)AhcConfigBuilder.$anonfun$configureProtocols$2(objectArray, elem))))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                throw new MatchError((Object)option);
            }
            definedProtocols = stringArray;
            if (sslConfig.loose().allowWeakProtocols()) break block4;
            Set deprecatedProtocols = Protocols$.MODULE$.deprecatedProtocols();
            deprecatedProtocols.foreach((Function1 & Serializable & scala.Serializable)deprecatedProtocol -> {
                AhcConfigBuilder.$anonfun$configureProtocols$3(definedProtocols, deprecatedProtocol);
                return BoxedUnit.UNIT;
            });
        }
        return definedProtocols;
    }

    public String[] configureCipherSuites(String[] existingCiphers, SSLConfigSettings sslConfig) {
        String[] definedCiphers;
        block4: {
            String[] stringArray;
            Option option = sslConfig.enabledCipherSuites();
            if (option instanceof Some) {
                Some some = (Some)option;
                scala.collection.immutable.Seq configuredCiphers = (scala.collection.immutable.Seq)some.value();
                stringArray = (String[])((TraversableOnce)configuredCiphers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AhcConfigBuilder.$anonfun$configureCipherSuites$1(existingCiphers, x$1)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else if (None$.MODULE$.equals(option)) {
                stringArray = (String[])((TraversableOnce)Ciphers$.MODULE$.recommendedCiphers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AhcConfigBuilder.$anonfun$configureCipherSuites$2(existingCiphers, x$2)))).toArray(ClassTag$.MODULE$.apply(String.class));
            } else {
                throw new MatchError((Object)option);
            }
            definedCiphers = stringArray;
            if (sslConfig.loose().allowWeakCiphers()) break block4;
            Set deprecatedCiphers = Ciphers$.MODULE$.deprecatedCiphers();
            deprecatedCiphers.foreach((Function1 & Serializable & scala.Serializable)deprecatedCipher -> {
                AhcConfigBuilder.$anonfun$configureCipherSuites$3(definedCiphers, deprecatedCipher);
                return BoxedUnit.UNIT;
            });
        }
        return definedCiphers;
    }

    public void configureSSL(SSLConfigSettings sslConfig) {
        SSLContext sSLContext;
        if (sslConfig.default()) {
            this.logger().info("buildSSLContext: play.ws.ssl.default is true, using default SSLContext");
            this.validateDefaultTrustManager(sslConfig);
            sSLContext = SSLContext.getDefault();
        } else {
            KeyManagerFactoryWrapper keyManagerFactory = this.buildKeyManagerFactory(sslConfig);
            TrustManagerFactoryWrapper trustManagerFactory = this.buildTrustManagerFactory(sslConfig);
            sSLContext = new ConfigSSLContextBuilder((LoggerFactory)this.loggerFactory(), sslConfig, keyManagerFactory, trustManagerFactory).build();
        }
        SSLContext sslContext = sSLContext;
        SSLParameters defaultParams = sslContext.getDefaultSSLParameters();
        String[] defaultProtocols = defaultParams.getProtocols();
        String[] protocols = this.configureProtocols(defaultProtocols, sslConfig);
        defaultParams.setProtocols(protocols);
        this.builder().setEnabledProtocols(protocols);
        String[] defaultCiphers = defaultParams.getCipherSuites();
        String[] cipherSuites = this.configureCipherSuites(defaultCiphers, sslConfig);
        defaultParams.setCipherSuites(cipherSuites);
        this.builder().setEnabledCipherSuites(cipherSuites);
        this.builder().setUseInsecureTrustManager(sslConfig.loose().acceptAnyCertificate());
        if (sslConfig.loose().acceptAnyCertificate()) {
            this.builder().setSslContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
        } else {
            this.builder().setSslEngineFactory((SslEngineFactory)new JsseSslEngineFactory(sslContext));
        }
    }

    public KeyManagerFactoryWrapper buildKeyManagerFactory(SSLConfigSettings ssl) {
        return new DefaultKeyManagerFactoryWrapper(ssl.keyManagerConfig().algorithm());
    }

    public TrustManagerFactoryWrapper buildTrustManagerFactory(SSLConfigSettings ssl) {
        return new DefaultTrustManagerFactoryWrapper(ssl.trustManagerConfig().algorithm());
    }

    public void validateDefaultTrustManager(SSLConfigSettings sslConfig) {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager trustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        Set constraints = ((TraversableOnce)sslConfig.disabledKeyAlgorithms().map((Function1 & Serializable & scala.Serializable)a -> (AlgorithmConstraint)AlgorithmConstraintsParser$.MODULE$.parseAll(AlgorithmConstraintsParser$.MODULE$.expression(), (CharSequence)a).get(), Seq$.MODULE$.canBuildFrom())).toSet();
        AlgorithmChecker algorithmChecker = new AlgorithmChecker((LoggerFactory)this.loggerFactory(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), constraints);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trustManager.getAcceptedIssuers())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
            AhcConfigBuilder.$anonfun$validateDefaultTrustManager$2(this, algorithmChecker, cert);
            return BoxedUnit.UNIT;
        });
    }

    private static final int toMillis$1(Duration duration) {
        return duration.isFinite() ? (int)duration.toMillis() : -1;
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$1(Object[] eta$0$1$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$1$1).contains(elem);
    }

    public static final /* synthetic */ boolean $anonfun$configureProtocols$2(Object[] eta$0$2$1, Object elem) {
        return new ArrayOps.ofRef(eta$0$2$1).contains(elem);
    }

    public static final /* synthetic */ void $anonfun$configureProtocols$3(String[] definedProtocols$1, String deprecatedProtocol) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definedProtocols$1)).contains((Object)deprecatedProtocol)) {
            throw new IllegalStateException(new StringBuilder(41).append("Weak protocol ").append(deprecatedProtocol).append(" found in ws.ssl.protocols!").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$configureCipherSuites$1(String[] existingCiphers$1, String x$1) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingCiphers$1)).contains((Object)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$configureCipherSuites$2(String[] existingCiphers$1, String x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existingCiphers$1)).contains((Object)x$2);
    }

    public static final /* synthetic */ void $anonfun$configureCipherSuites$3(String[] definedCiphers$1, String deprecatedCipher) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])definedCiphers$1)).contains((Object)deprecatedCipher)) {
            throw new IllegalStateException(new StringBuilder(37).append("Weak cipher ").append(deprecatedCipher).append(" found in ws.ssl.ciphers!").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$validateDefaultTrustManager$2(AhcConfigBuilder $this, AlgorithmChecker algorithmChecker$1, X509Certificate cert) {
        try {
            algorithmChecker$1.checkKeyAlgorithms(cert);
        }
        catch (CertPathValidatorException e) {
            $this.logger().warn("You are using play.ws.ssl.default=true and have a weak certificate in your default trust store!  (You can modify play.ws.ssl.disabledKeyAlgorithms to remove this message.)", (Throwable)e);
        }
    }

    public AhcConfigBuilder(AhcWSClientConfig ahcConfig) {
        this.play$api$libs$ws$ahc$AhcConfigBuilder$$ahcConfig = ahcConfig;
        this.addCustomSettings = (Function1 & Serializable & scala.Serializable)x -> (DefaultAsyncHttpClientConfig.Builder)Predef$.MODULE$.identity(x);
        this.builder = new DefaultAsyncHttpClientConfig.Builder();
        this.logger = org.slf4j.LoggerFactory.getLogger((String)this.getClass().getName());
        this.loggerFactory = new AhcLoggerFactory(org.slf4j.LoggerFactory.getILoggerFactory());
    }
}

