/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u000153Aa\u0002\u0005\u0001'!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!A\u0004A!A!\u0002\u0013I\u0004\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002$\u0001\t\u00039\u0005\"\u0002%\u0001\t\u00039%aF!iG^\u001b6\t\\5f]R\u001cuN\u001c4jOB\u000b'o]3s\u0015\tI!\"A\u0002bQ\u000eT!a\u0003\u0007\u0002\u0005]\u001c(BA\u0007\u000f\u0003\u0011a\u0017NY:\u000b\u0005=\u0001\u0012aA1qS*\t\u0011#\u0001\u0003qY\u0006L8\u0001A\n\u0004\u0001Qa\u0002CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\u0011a\u0017M\\4\u000b\u0003e\tAA[1wC&\u00111D\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007u\u0011C%D\u0001\u001f\u0015\ty\u0002%\u0001\u0004j]*,7\r\u001e\u0006\u0002C\u0005)!.\u0019<bq&\u00111E\b\u0002\t!J|g/\u001b3feB\u0011QEJ\u0007\u0002\u0011%\u0011q\u0005\u0003\u0002\u0012\u0003\"\u001cwkU\"mS\u0016tGoQ8oM&<\u0017AD<t\u00072LWM\u001c;D_:4\u0017n\u001a\t\u0003U-j\u0011AC\u0005\u0003Y)\u0011abV*DY&,g\u000e^\"p]\u001aLw-A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003_Yj\u0011\u0001\r\u0006\u0003cI\naaY8oM&<'BA\u001a5\u0003!!\u0018\u0010]3tC\u001a,'\"A\u001b\u0002\u0007\r|W.\u0003\u00028a\t11i\u001c8gS\u001e\f1b\u00197bgNdu.\u00193feB\u0011QCO\u0005\u0003wY\u00111b\u00117bgNdu.\u00193fe\u00061A(\u001b8jiz\"BAP A\u0003B\u0011Q\u0005\u0001\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\u0006[\u0011\u0001\rA\f\u0005\u0006q\u0011\u0001\r!\u000f\u0015\u0003\t\r\u0003\"!\b#\n\u0005\u0015s\"AB%oU\u0016\u001cG/A\u0002hKR$\u0012\u0001J\u0001\u0006a\u0006\u00148/\u001a\u0015\u0003\u0001)\u0003\"!H&\n\u00051s\"!C*j]\u001edW\r^8o\u0001")
public class AhcWSClientConfigParser
implements Provider<AhcWSClientConfig> {
    private final WSClientConfig wsClientConfig;
    private final Config configuration;

    public AhcWSClientConfig get() {
        return this.parse();
    }

    public AhcWSClientConfig parse() {
        int maximumConnectionsPerHost = this.configuration.getInt("play.ws.ahc.maxConnectionsPerHost");
        int maximumConnectionsTotal = this.configuration.getInt("play.ws.ahc.maxConnectionsTotal");
        Duration maxConnectionLifetime = this.getDuration$1("play.ws.ahc.maxConnectionLifetime", (Duration)Duration$.MODULE$.Inf());
        Duration idleConnectionInPoolTimeout = this.getDuration$1("play.ws.ahc.idleConnectionInPoolTimeout", (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute());
        int maximumNumberOfRedirects = this.configuration.getInt("play.ws.ahc.maxNumberOfRedirects");
        int maxRequestRetry = this.configuration.getInt("play.ws.ahc.maxRequestRetry");
        boolean disableUrlEncoding = this.configuration.getBoolean("play.ws.ahc.disableUrlEncoding");
        boolean keepAlive = this.configuration.getBoolean("play.ws.ahc.keepAlive");
        boolean useLaxCookieEncoder = this.configuration.getBoolean("play.ws.ahc.useLaxCookieEncoder");
        boolean useCookieStore = this.configuration.getBoolean("play.ws.ahc.useCookieStore");
        return new AhcWSClientConfig(this.wsClientConfig, maximumConnectionsPerHost, maximumConnectionsTotal, maxConnectionLifetime, idleConnectionInPoolTimeout, maximumNumberOfRedirects, maxRequestRetry, disableUrlEncoding, keepAlive, useLaxCookieEncoder, useCookieStore);
    }

    private final Duration getDuration$1(String key, Duration duration) {
        Duration duration2;
        try {
            duration2 = Duration$.MODULE$.apply(this.configuration.getString(key));
        }
        catch (ConfigException.Null e) {
            duration2 = duration;
        }
        return duration2;
    }

    @Inject
    public AhcWSClientConfigParser(WSClientConfig wsClientConfig, Config configuration, ClassLoader classLoader) {
        this.wsClientConfig = wsClientConfig;
        this.configuration = configuration;
    }
}

