/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

public class StreamfinderConfig {
    String username;
    String password;
    String discoveryUri;
    String serviceId;
    long pollRateS;
    long discoverRetryMs;
    boolean noDelay;
    boolean discoverByScope;
    boolean advertiseWithScope;

    public StreamfinderConfig() {
        this("", "", "", "");
    }

    public StreamfinderConfig(String username, String password, String discoveryUri, String serviceId) {
        this(username, password, discoveryUri, serviceId, false);
    }

    public StreamfinderConfig(String username, String password, String discoveryUri, String serviceId, boolean discoverByScope) {
        this.setUsername(username);
        this.setPassword(password);
        this.setDiscoveryUri(discoveryUri);
        this.setServiceId(serviceId);
        this.setPollRateS(25L);
        this.setNoDelay(false);
        this.setDiscoverRetryMs(1000L);
        this.setDiscoverByScope(discoverByScope);
    }

    public String getUsername() {
        return this.username;
    }

    public StreamfinderConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public StreamfinderConfig setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public StreamfinderConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public long getPollRateS() {
        return this.pollRateS;
    }

    public StreamfinderConfig setPollRateS(long pollRateS) {
        this.pollRateS = pollRateS;
        return this;
    }

    public String getDiscoveryUri() {
        return this.discoveryUri;
    }

    public StreamfinderConfig setDiscoveryUri(String discoveryUri) {
        if (discoveryUri != null && discoveryUri.endsWith("/")) {
            discoveryUri = discoveryUri.substring(0, discoveryUri.length() - 1);
        }
        this.discoveryUri = discoveryUri;
        return this;
    }

    @Deprecated
    public boolean isNoDelay() {
        return this.noDelay;
    }

    @Deprecated
    public StreamfinderConfig setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
        return this;
    }

    public boolean isDiscoverByScope() {
        return this.discoverByScope;
    }

    public StreamfinderConfig setDiscoverByScope(boolean val) {
        this.discoverByScope = val;
        return this;
    }

    public boolean isAdvertiseWithScope() {
        return this.advertiseWithScope;
    }

    public StreamfinderConfig setAdvertiseWithScope(boolean val) {
        this.advertiseWithScope = val;
        return this;
    }

    public long getDiscoverRetryMs() {
        return this.discoverRetryMs;
    }

    public void setDiscoverRetryMs(long discoverRetryMs) {
        this.discoverRetryMs = discoverRetryMs;
    }
}

