/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.streamfinder.internal.AdvertDelta;
import jayeson.lib.streamfinder.internal.AdvertSnapshot;
import jayeson.lib.streamfinder.internal.IdStreamJson;
import jayeson.lib.streamfinder.internal.StreamJson;

public class AdvertMessageTools {
    int chunkSize;
    final ObjectMapper mapper;
    static final int DEFAULT_CHUNK_SIZE = 100;

    @Inject
    public AdvertMessageTools(@Named(value="SF_MAPPER") ObjectMapper mapper) {
        this.mapper = mapper;
        this.chunkSize = 100;
    }

    public AdvertDelta diffSnapshots(AdvertSnapshot before, AdvertSnapshot after) throws IOException {
        boolean isSnapshot = before == null;
        AdvertDelta delta = new AdvertDelta(after.getServiceId(), after.getScope(), isSnapshot);
        Collection<URI> addPorts = after.getConnections();
        if (before != null) {
            addPorts.removeAll(before.getConnections());
        }
        delta.setConnections(addPorts);
        Set<IdStreamJson> addStreams = AdvertMessageTools.toIdStreamJsonSet(after.getStreams());
        if (before != null) {
            addStreams.removeAll(AdvertMessageTools.toIdStreamJsonSet(before.getStreams()));
        }
        delta.setStreams(addStreams);
        if (isSnapshot) {
            return delta;
        }
        Collection<URI> deletePorts = before.getConnections();
        deletePorts.removeAll(after.getConnections());
        delta.setDelConnections(deletePorts);
        Set<IdStreamJson> deleteStreams = AdvertMessageTools.toIdStreamJsonSet(before.getStreams());
        deleteStreams.removeAll(AdvertMessageTools.toIdStreamJsonSet(after.getStreams()));
        delta.setDelStreams(deleteStreams);
        return delta;
    }

    public List<AdvertDelta> splitDelta(AdvertDelta orig) {
        List streamChunks = Lists.partition(new ArrayList<IdStreamJson>(orig.getStreams()), (int)this.chunkSize);
        ArrayList<AdvertDelta> deltas = new ArrayList<AdvertDelta>();
        AdvertDelta first = new AdvertDelta(orig);
        if (!streamChunks.isEmpty()) {
            first.setStreams((Collection)streamChunks.get(0));
        }
        deltas.add(first);
        for (int i = 1; i < streamChunks.size(); ++i) {
            AdvertDelta chunk = new AdvertDelta(orig.getServiceId(), orig.getScope(), false);
            chunk.setStreams((Collection)streamChunks.get(i));
            deltas.add(chunk);
        }
        return deltas;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public JsonNode toJson(Object value) {
        return this.mapper.valueToTree(value);
    }

    static Set<IdStreamJson> toIdStreamJsonSet(Collection<StreamJson> in) {
        List s = in.stream().map(IdStreamJson::new).collect(Collectors.toList());
        return new HashSet<IdStreamJson>(s);
    }
}

