/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jayeson.lib.streamfinder.internal.StreamJson;

public final class AdvertSnapshot {
    final String serviceId;
    final String scope;
    final Set<URI> connections;
    final Set<StreamJson> streams;

    public AdvertSnapshot(String serviceId, String scope) {
        this(serviceId, scope, null, null);
    }

    public AdvertSnapshot(String serviceId, String scope, Collection<StreamJson> streams, Collection<URI> connections) {
        if (serviceId == null) {
            throw new IllegalArgumentException("Service Id cannot be null");
        }
        this.serviceId = serviceId;
        this.scope = scope;
        this.connections = connections != null ? new HashSet<URI>(connections) : new HashSet<URI>();
        this.streams = streams != null ? new HashSet<StreamJson>(streams) : new HashSet<StreamJson>();
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getScope() {
        return this.scope;
    }

    public Collection<URI> getConnections() {
        return new HashSet<URI>(this.connections);
    }

    public AdvertSnapshot setConnections(Collection<URI> conns) {
        AdvertSnapshot updated = new AdvertSnapshot(this.serviceId, this.scope, this.streams, new HashSet<URI>(conns));
        return updated;
    }

    public Collection<StreamJson> getStreams() {
        return new HashSet<StreamJson>(this.streams);
    }

    public AdvertSnapshot setStreams(Collection<StreamJson> streams) {
        AdvertSnapshot updated = new AdvertSnapshot(this.serviceId, this.scope, new HashSet<StreamJson>(streams), this.connections);
        return updated;
    }
}

