/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriDeserializer
extends JsonDeserializer<URI> {
    public static Logger log = LoggerFactory.getLogger(UriDeserializer.class);
    protected List<String> webSchemes = Arrays.asList("ws", "wss", "http", "https");

    public URI deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode root = (JsonNode)jp.getCodec().readTree(jp);
        String protocol = root.path("protocol").textValue();
        if (protocol == null) {
            throw new IOException("Required protocol field is missing");
        }
        String host = root.path("hostname").textValue();
        if (host == null) {
            throw new IOException("Required hostname field is missing");
        }
        int port = root.path("port").asInt(-1);
        String path = root.path("path").textValue();
        try {
            URI uri = new URI(protocol, null, host, port, path, null, null);
            this.validateURI(uri);
            return uri;
        }
        catch (URISyntaxException e) {
            log.debug("deserialization exception {}", (Throwable)e);
            throw new IOException(e.getCause());
        }
    }

    public void validateURI(URI inputURI) {
        String path = inputURI.getPath();
        if (path == null || "".equals(path)) {
            return;
        }
        String scheme = inputURI.getScheme();
        if (!this.webSchemes.contains(scheme)) {
            throw new IllegalArgumentException("Paths can only be defined if the scheme is one of: " + this.webSchemes);
        }
    }
}

