/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.Cache;
import com.typesafe.play.cachecontrol.CacheDirectives$OnlyIfCached$;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.HttpDate$;
import com.typesafe.play.cachecontrol.ResponseSelectionAction;
import com.typesafe.play.cachecontrol.ResponseSelectionActions;
import com.typesafe.play.cachecontrol.ResponseSelectionCalculator$;
import com.typesafe.play.cachecontrol.StoredResponse;
import java.io.Serializable;
import java.time.ZonedDateTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0004\t\u00013!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003E\u0001\u0011EQ\tC\u0004M\u0001\t\u0007I\u0011A'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u0015\u0011\u0006\u0001\"\u0005T\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015a\u0007\u0001\"\u0005n\u000f\u0015y\u0007\u0003#\u0001q\r\u0015y\u0001\u0003#\u0001r\u0011\u0015)3\u0002\"\u0001s\u0011\u001d\u00198B1A\u0005\nQDa!`\u0006!\u0002\u0013)(a\u0007*fgB|gn]3TK2,7\r^5p]\u000e\u000bGnY;mCR|'O\u0003\u0002\u0012%\u0005a1-Y2iK\u000e|g\u000e\u001e:pY*\u00111\u0003F\u0001\u0005a2\f\u0017P\u0003\u0002\u0016-\u0005AA/\u001f9fg\u00064WMC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0003E\rj\u0011\u0001E\u0005\u0003IA\u0011QaQ1dQ\u0016\fa\u0001P5oSRtDCA\u0014)!\t\u0011\u0003\u0001C\u0003!\u0005\u0001\u0007\u0011%\u0001\btK2,7\r\u001e*fgB|gn]3\u0015\u0007-r3\u0007\u0005\u0002#Y%\u0011Q\u0006\u0005\u0002\u0018%\u0016\u001c\bo\u001c8tKN+G.Z2uS>t\u0017i\u0019;j_:DQaL\u0002A\u0002A\nqA]3rk\u0016\u001cH\u000f\u0005\u0002#c%\u0011!\u0007\u0005\u0002\r\u0007\u0006\u001c\u0007.\u001a*fcV,7\u000f\u001e\u0005\u0006i\r\u0001\r!N\u0001\ne\u0016\u001c\bo\u001c8tKN\u00042A\u000e B\u001d\t9DH\u0004\u00029w5\t\u0011H\u0003\u0002;1\u00051AH]8pizJ\u0011!H\u0005\u0003{q\tq\u0001]1dW\u0006<W-\u0003\u0002@\u0001\n\u00191+Z9\u000b\u0005ub\u0002C\u0001\u0012C\u0013\t\u0019\u0005C\u0001\bTi>\u0014X\r\u001a*fgB|gn]3\u0002#U\u0014\u0018.\u00118e\u001b\u0016$\bn\u001c3NCR\u001c\u0007\u000eF\u0002G\u0013*\u0003\"aG$\n\u0005!c\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006_\u0011\u0001\r\u0001\r\u0005\u0006\u0017\u0012\u0001\r!Q\u0001\te\u0016\u001c\bo\u001c8tK\u0006\u0011Rn\\:u%\u0016\u001cWM\u001c;Pe\u0012,'/\u001b8h+\u0005q\u0005c\u0001\u001cP\u0003&\u0011\u0001\u000b\u0011\u0002\t\u001fJ$WM]5oO\u0006\u0019Rn\\:u%\u0016\u001cWM\u001c;Pe\u0012,'/\u001b8hA\u0005!b-\u001b8e\u001b\u0006$8\r[5oOJ+7\u000f]8og\u0016$2\u0001\u00160`!\rYRkV\u0005\u0003-r\u0011aa\u00149uS>t\u0007C\u0001-\\\u001d\t\u0011\u0013,\u0003\u0002[!\u0005A\"+Z:q_:\u001cXmU3mK\u000e$\u0018n\u001c8BGRLwN\\:\n\u0005qk&\u0001E*fY\u0016\u001cG/\u001a3SKN\u0004xN\\:f\u0015\tQ\u0006\u0003C\u00030\u000f\u0001\u0007\u0001\u0007C\u00035\u000f\u0001\u0007Q'\u0001\u0004u_\u0012\u000bG/\u001a\u000b\u0003E*\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\tQLW.\u001a\u0006\u0002O\u0006!!.\u0019<b\u0013\tIGMA\u0007[_:,G\rR1uKRKW.\u001a\u0005\u0006W\"\u0001\r!Q\u0001\u0002e\u0006!bn\u001c,bY&$'+Z:q_:\u001cXMR8v]\u0012$\"a\u000b8\t\u000b=J\u0001\u0019\u0001\u0019\u00027I+7\u000f]8og\u0016\u001cV\r\\3di&|gnQ1mGVd\u0017\r^8s!\t\u00113b\u0005\u0002\f5Q\t\u0001/\u0001\u0004m_\u001e<WM]\u000b\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0006g24GG\u001b\u0006\u0002u\u0006\u0019qN]4\n\u0005q<(A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011")
public class ResponseSelectionCalculator {
    private final Cache cache;
    private final Ordering<StoredResponse> mostRecentOrdering;

    public ResponseSelectionAction selectResponse(CacheRequest request, Seq<StoredResponse> responses) {
        return (ResponseSelectionAction)this.findMatchingResponse(request, responses).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.noValidResponseFound(request));
    }

    public boolean uriAndMethodMatch(CacheRequest request, StoredResponse response) {
        return request.uri().equals(response.uri()) && request.method().equals(response.requestMethod());
    }

    public Ordering<StoredResponse> mostRecentOrdering() {
        return this.mostRecentOrdering;
    }

    public Option<ResponseSelectionActions.SelectedResponse> findMatchingResponse(CacheRequest request, Seq<StoredResponse> responses) {
        None$ none$;
        ResponseSelectionCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseSelectionCalculator$$logger().trace(new StringBuilder(46).append("findMatchingResponse: request = ").append(request).append(", responses = ").append(responses).toString());
        Seq matchingResponses = (Seq)((TraversableLike)responses.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.uriAndMethodMatch(request, x$1)))).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.cache.containsMatchingHeaders(request.headers(), r.nominatedHeaders())));
        if (matchingResponses.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            StoredResponse mostRecentResponse = (StoredResponse)((IterableLike)matchingResponses.sorted(this.mostRecentOrdering())).head();
            int mostRecentIndex = responses.indexOf((Object)mostRecentResponse);
            none$ = new Some((Object)new ResponseSelectionActions.SelectedResponse(mostRecentResponse, mostRecentIndex));
        }
        return none$;
    }

    public ZonedDateTime toDate(StoredResponse r) {
        return HttpDate$.MODULE$.parse((String)((IterableLike)r.headers().apply((Object)HeaderNames$.MODULE$.Date())).head());
    }

    public ResponseSelectionAction noValidResponseFound(CacheRequest request) {
        ResponseSelectionCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseSelectionCalculator$$logger().trace(new StringBuilder(32).append("noValidResponseFound: request = ").append(request).toString());
        return request.directives().contains((Object)CacheDirectives$OnlyIfCached$.MODULE$) ? new ResponseSelectionActions.GatewayTimeout("Response not found and request contains only-if-cached") : new ResponseSelectionActions.ForwardToOrigin("Valid response not found for request");
    }

    public ResponseSelectionCalculator(Cache cache) {
        this.cache = cache;
        this.mostRecentOrdering = new Ordering<StoredResponse>(this){
            private final /* synthetic */ ResponseSelectionCalculator $outer;

            public Some tryCompare(Object x, Object y) {
                return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.max$((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.min$((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<StoredResponse> reverse() {
                return Ordering.reverse$((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, StoredResponse> f) {
                return Ordering.on$((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
            }

            public int compare(StoredResponse r1, StoredResponse r2) {
                return this.$outer.toDate(r2).compareTo(this.$outer.toDate(r1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }
        };
    }
}

