/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.cachecontrol;

import com.typesafe.play.cachecontrol.Cache;
import com.typesafe.play.cachecontrol.CacheDirective;
import com.typesafe.play.cachecontrol.CacheDirectives;
import com.typesafe.play.cachecontrol.CacheDirectives$;
import com.typesafe.play.cachecontrol.CacheDirectives$MustRevalidate$;
import com.typesafe.play.cachecontrol.CacheDirectives$ProxyRevalidate$;
import com.typesafe.play.cachecontrol.CacheRequest;
import com.typesafe.play.cachecontrol.FreshnessCalculator;
import com.typesafe.play.cachecontrol.HeaderName;
import com.typesafe.play.cachecontrol.HeaderNames$;
import com.typesafe.play.cachecontrol.ResponseServeAction;
import com.typesafe.play.cachecontrol.ResponseServeActions;
import com.typesafe.play.cachecontrol.ResponseServeActions$Validate$;
import com.typesafe.play.cachecontrol.ResponseServingCalculator$;
import com.typesafe.play.cachecontrol.Seconds;
import com.typesafe.play.cachecontrol.StoredResponse;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\n\u0015\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006S\u0001!\tA\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0011\u0019\u0011\u0004\u0001)A\u0005_!)1\u0007\u0001C\u0001i!)q\t\u0001C\t\u0011\")Q\u000b\u0001C\t-\")A\f\u0001C\t;\")!\r\u0001C\tG\")a\u000f\u0001C\to\"9\u0011\u0011\u0001\u0001\u0005\u0012\u0005\r\u0001bBA\u000b\u0001\u0011E\u0011q\u0003\u0005\b\u0003K\u0001A\u0011CA\u0014\u000f\u001d\tI\u0004\u0006E\u0001\u0003w1aa\u0005\u000b\t\u0002\u0005u\u0002BB\u0015\u0010\t\u0003\ty\u0004C\u0005\u0002B=\u0011\r\u0011\"\u0003\u0002D!A\u0011QK\b!\u0002\u0013\t)EA\rSKN\u0004xN\\:f'\u0016\u0014h/\u001b8h\u0007\u0006d7-\u001e7bi>\u0014(BA\u000b\u0017\u00031\u0019\u0017m\u00195fG>tGO]8m\u0015\t9\u0002$\u0001\u0003qY\u0006L(BA\r\u001b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-A\u0003dC\u000eDW\r\u0005\u0002'O5\tA#\u0003\u0002))\t)1)Y2iK\u00061A(\u001b8jiz\"\"a\u000b\u0017\u0011\u0005\u0019\u0002\u0001\"\u0002\u0013\u0003\u0001\u0004)\u0013a\u00054sKNDg.Z:t\u0007\u0006d7-\u001e7bi>\u0014X#A\u0018\u0011\u0005\u0019\u0002\u0014BA\u0019\u0015\u0005M1%/Z:i]\u0016\u001c8oQ1mGVd\u0017\r^8s\u0003Q1'/Z:i]\u0016\u001c8oQ1mGVd\u0017\r^8sA\u0005i1/\u001a:wKJ+7\u000f]8og\u0016$B!\u000e\u001d>\u0005B\u0011aEN\u0005\u0003oQ\u00111CU3ta>t7/Z*feZ,\u0017i\u0019;j_:DQ!O\u0003A\u0002i\nqA]3rk\u0016\u001cH\u000f\u0005\u0002'w%\u0011A\b\u0006\u0002\r\u0007\u0006\u001c\u0007.\u001a*fcV,7\u000f\u001e\u0005\u0006}\u0015\u0001\raP\u0001\te\u0016\u001c\bo\u001c8tKB\u0011a\u0005Q\u0005\u0003\u0003R\u0011ab\u0015;pe\u0016$'+Z:q_:\u001cX\rC\u0003D\u000b\u0001\u0007A)\u0001\u0006dkJ\u0014XM\u001c;BO\u0016\u0004\"AJ#\n\u0005\u0019#\"aB*fG>tGm]\u0001\u0012C2dwn^*uC2,\u0017JZ#se>\u0014HCA%T)\rQ\u0015K\u0015\t\u0003\u0017:s!A\n'\n\u00055#\u0012\u0001\u0006*fgB|gn]3TKJ4X-Q2uS>t7/\u0003\u0002P!\nAa+\u00197jI\u0006$XM\u0003\u0002N)!)\u0011H\u0002a\u0002u!)aH\u0002a\u0002\u007f!)AK\u0002a\u0001\t\u0006\u0019\u0011mZ3\u0002\u00199|7)Y2iK\u001a{WO\u001c3\u0015\u0007]S6\fE\u0002 1*K!!\u0017\u0011\u0003\r=\u0003H/[8o\u0011\u0015It\u0001q\u0001;\u0011\u0015qt\u0001q\u0001@\u0003U\u0019wN\u001c;bS:\u001c\bK]1h[\u0006tunQ1dQ\u0016$\"AX1\u0011\u0005}y\u0016B\u00011!\u0005\u001d\u0011un\u001c7fC:DQ!\u000f\u0005A\u0004i\nA\u0002[3bI\u0016\u00148OR8v]\u0012$2A\u00183v\u0011\u0015)\u0017\u00021\u0001g\u00039qwnQ1dQ\u0016DU-\u00193feN\u00042aZ8s\u001d\tAWN\u0004\u0002jY6\t!N\u0003\u0002l9\u00051AH]8pizJ\u0011!I\u0005\u0003]\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002qc\n\u00191+Z9\u000b\u00059\u0004\u0003C\u0001\u0014t\u0013\t!HC\u0001\u0006IK\u0006$WM\u001d(b[\u0016DQAP\u0005A\u0002}\nQ#[:DC\u000eDW\r\u001a*fgB|gn]3Ge\u0016\u001c\b\u000e\u0006\u0002y\u007fR\u0019\u00110 @\u0011\u0007}A&\u0010\u0005\u0002Lw&\u0011A\u0010\u0015\u0002\u000b'\u0016\u0014h/\u001a$sKND\u0007\"B\u001d\u000b\u0001\bQ\u0004\"\u0002 \u000b\u0001\by\u0004\"B\"\u000b\u0001\u0004!\u0015AF5t'R\fG.\u001a*fgB|gn]3BY2|w/\u001a3\u0015\t\u0005\u0015\u00111\u0003\u000b\u0007\u0003\u000f\ty!!\u0005\u0011\t}A\u0016\u0011\u0002\t\u0004\u0017\u0006-\u0011bAA\u0007!\nQ1+\u001a:wKN#\u0018\r\\3\t\u000beZ\u00019\u0001\u001e\t\u000byZ\u00019A \t\u000b\r[\u0001\u0019\u0001#\u0002G%\u001c8\u000b^1mKJ+7\u000f]8og\u0016,\u0005\u0010\u001d7jG&$H.\u001f)s_\"L'-\u001b;fIR1\u0011\u0011DA\u0011\u0003G\u0001Ba\b-\u0002\u001cA\u00191*!\b\n\u0007\u0005}\u0001KA\tWC2LG-\u0019;f\u001fJ$\u0016.\\3pkRDQ!\u000f\u0007A\u0004iBQA\u0010\u0007A\u0004}\n!dY1o'\u0016\u0014h/Z*uC2,\u0017I\u001c3SKZ\fG.\u001b3bi\u0016$B!!\u000b\u00028Q1\u00111FA\u001a\u0003k\u0001Ba\b-\u0002.A\u00191*a\f\n\u0007\u0005E\u0002KA\u000bTKJ4Xm\u0015;bY\u0016\fe\u000e\u001a,bY&$\u0017\r^3\t\u000bej\u00019\u0001\u001e\t\u000byj\u00019A \t\u000bQk\u0001\u0019\u0001#\u00023I+7\u000f]8og\u0016\u001cVM\u001d<j]\u001e\u001c\u0015\r\\2vY\u0006$xN\u001d\t\u0003M=\u0019\"a\u0004\u0010\u0015\u0005\u0005m\u0012A\u00027pO\u001e,'/\u0006\u0002\u0002FA!\u0011qIA)\u001b\t\tIE\u0003\u0003\u0002L\u00055\u0013!B:mMRR'BAA(\u0003\ry'oZ\u0005\u0005\u0003'\nIE\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0001")
public class ResponseServingCalculator {
    private final Cache cache;
    private final FreshnessCalculator freshnessCalculator;

    private FreshnessCalculator freshnessCalculator() {
        return this.freshnessCalculator;
    }

    public ResponseServeAction serveResponse(CacheRequest request, StoredResponse response, Seconds currentAge) {
        ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(45).append("serveResponse: response found for '").append(request.method()).append(" ").append(request.uri()).append("', age = ").append(currentAge.seconds()).toString());
        CacheRequest req = request;
        StoredResponse res = response;
        Option<ResponseServeActions.Validate> explicitValidate = this.noCacheFound(req, res);
        return (ResponseServeAction)explicitValidate.orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<ResponseServeActions.ServeFresh> serveFresh = this.isCachedResponseFresh(currentAge, req, res);
            return serveFresh;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_3;
            Option<ResponseServeActions.ValidateOrTimeout> notAllowedStale = this.isStaleResponseExplicitlyProhibited(req, res);
            return var3_3;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<ResponseServeActions.ServeStale> serveStale = this.isStaleResponseAllowed(currentAge, req, res);
            return serveStale;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<ResponseServeActions.ServeStaleAndValidate> serveStaleAndRevalidate = this.canServeStaleAndRevalidate(currentAge, req, res);
            return serveStaleAndRevalidate;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            ResponseServeActions.Validate defaultValidation = this.allowStaleIfError(currentAge, req, res);
            return defaultValidation;
        });
    }

    public ResponseServeActions.Validate allowStaleIfError(Seconds age, CacheRequest request, StoredResponse response) {
        ResponseServeActions.Validate v = new ResponseServeActions.Validate("Response is stale, and stale response is not allowed", ResponseServeActions$Validate$.MODULE$.apply$default$2());
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
        return (ResponseServeActions.Validate)CacheDirectives$.MODULE$.staleIfError(response.directives()).map((Function1 & Serializable & scala.Serializable)staleIfError2 -> {
            Seconds delta = staleIfError2.delta();
            boolean serveStale = age.isLessThan(freshnessLifetime.plus(delta));
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(44).append("allowStaleIfError: delta = ").append(delta).append(", staleIfError = ").append(serveStale).toString());
            boolean x$1 = serveStale;
            String x$2 = v.copy$default$1();
            return v.copy(x$2, x$1);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> v);
    }

    public Option<ResponseServeActions.Validate> noCacheFound(CacheRequest request, StoredResponse response) {
        None$ none$;
        if (ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().trace(new StringBuilder(37).append("noCacheFound: request = ").append(request).append(", response = ").append(response).toString());
        }
        if (request.directives().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResponseServingCalculator.$anonfun$noCacheFound$1(x$1)))) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().trace("noCacheFound: no-cache directive found!");
            String msg = "Request contains no-cache directive, validation required";
            none$ = new Some((Object)new ResponseServeActions.Validate(msg, ResponseServeActions$Validate$.MODULE$.apply$default$2()));
        } else if (request.directives().isEmpty()) {
            if (this.containsPragmaNoCache(request)) {
                String msg = "Request does not contain Cache-Control header found, but does contains no-cache Pragma header, validation required";
                none$ = new Some((Object)new ResponseServeActions.Validate(msg, ResponseServeActions$Validate$.MODULE$.apply$default$2()));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ requestContainsNoCache = none$;
        Option result = requestContainsNoCache.orElse((Function0 & Serializable & scala.Serializable)() -> CacheDirectives$.MODULE$.noCache(response.directives()).flatMap((Function1 & Serializable & scala.Serializable)noCache2 -> {
            None$ none$;
            Option<scala.collection.immutable.Seq<String>> option = noCache2.headerNames();
            if (option instanceof Some) {
                ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(57).append("noCacheFound: no-cache response directive qualified with ").append(noCache2.headerNames()).toString());
                none$ = None$.MODULE$;
            } else if (None$.MODULE$.equals(option)) {
                String msg = "Response contains no-args no-cache directive";
                none$ = new Some((Object)new ResponseServeActions.Validate(msg, ResponseServeActions$Validate$.MODULE$.apply$default$2()));
            } else {
                throw new MatchError(option);
            }
            return none$;
        }));
        return result;
    }

    public boolean containsPragmaNoCache(CacheRequest request) {
        return request.headers().get((Object)HeaderNames$.MODULE$.Pragma()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("no-cache")))));
    }

    public boolean headersFound(Seq<HeaderName> noCacheHeaders, StoredResponse response) {
        Set keySet = response.headers().keySet();
        return keySet.exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)noCacheHeaders.contains((Object)elem)));
    }

    public Option<ResponseServeActions.ServeFresh> isCachedResponseFresh(Seconds currentAge, CacheRequest request, StoredResponse response) {
        None$ none$;
        Some some;
        Seconds maxAge2;
        if (ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().trace(new StringBuilder(46).append("isCachedResponseFresh: request = ").append(request).append(", response = ").append(response).toString());
        }
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
        ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(58).append("isCachedResponseFresh: freshnessLifetime = ").append(freshnessLifetime).append(", currentAge = ").append(currentAge).toString());
        Option option = CacheDirectives$.MODULE$.maxAge((Seq<CacheDirective>)request.directives()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.delta());
        if (option instanceof Some && currentAge.isGreaterThan(maxAge2 = (Seconds)(some = (Some)option).value())) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(66).append("isCachedResponseFresh: maxAge = ").append(maxAge2).append(", currentAge = ").append(currentAge).append(", not fresh enough.").toString());
            none$ = None$.MODULE$;
        } else {
            None$ none$2;
            Some some2;
            Seconds minFresh2;
            Option option2 = CacheDirectives$.MODULE$.minFresh(request.directives()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.delta());
            if (option2 instanceof Some && !freshnessLifetime.isLessThan(currentAge.plus(minFresh2 = (Seconds)(some2 = (Some)option2).value()))) {
                ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(71).append("isCachedResponseFresh: freshnessLifetime = ").append(freshnessLifetime).append(", currentAge = ").append(currentAge).append(", minFresh = ").append(minFresh2).toString());
                none$2 = new Some((Object)new ResponseServeActions.ServeFresh(new StringBuilder(64).append("Fresh response: minFresh = ").append(minFresh2).append(", freshnessLifetime = ").append(freshnessLifetime).append(", currentAge = ").append(currentAge).toString()));
            } else {
                None$ none$3;
                boolean responseIsFresh = freshnessLifetime.isGreaterThan(currentAge);
                ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(58).append("isCachedResponseFresh: freshnessLifetime = ").append(freshnessLifetime).append(", currentAge = ").append(currentAge).toString());
                if (responseIsFresh) {
                    Seconds secondsLeft = freshnessLifetime.minus(currentAge);
                    String reason = new StringBuilder(42).append("Fresh response: lifetime = ").append(freshnessLifetime).append(", ").append(secondsLeft).append(" seconds left").toString();
                    none$3 = new Some((Object)new ResponseServeActions.ServeFresh(reason));
                } else {
                    none$3 = None$.MODULE$;
                }
                none$2 = none$3;
            }
            none$ = none$2;
        }
        return none$;
    }

    public Option<ResponseServeActions.ServeStale> isStaleResponseAllowed(Seconds currentAge, CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().trace(new StringBuilder(49).append("isStaleResponseAllowed: ").append(currentAge).append(", request = ").append(request).append(", response = ").append(response).toString());
        }
        Option result = CacheDirectives$.MODULE$.maxStale(request.directives()).flatMap((Function1 & Serializable & scala.Serializable)maxStale2 -> {
            Some some;
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(35).append("isStaleResponseAllowed: maxStale = ").append(maxStale2).toString());
            Option<Seconds> option = maxStale2.delta();
            if (option instanceof Some) {
                None$ none$;
                Some some2 = (Some)option;
                Seconds maxStaleDelta = (Seconds)some2.value();
                Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
                Seconds totalLifetime = freshnessLifetime.plus(maxStaleDelta);
                ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(88).append("isStaleResponseAllowed: freshnessLifetime = ").append(freshnessLifetime).append(", maxAge = ").append(maxStaleDelta).append(", totalLifetime = ").append(totalLifetime).append(", currentAge = ").append(currentAge).toString());
                if (totalLifetime.isGreaterThan(currentAge)) {
                    ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(56).append("isStaleResponseAllowed: (").append(freshnessLifetime).append(" + ").append(maxStaleDelta).append(") > = ").append(currentAge).append(", allowing serve stale").toString());
                    String msg = new StringBuilder(55).append("Request contains ").append(maxStale2).append(", current age = ").append(currentAge.seconds()).append(" which is inside range").toString();
                    none$ = new Some((Object)new ResponseServeActions.ServeStale(msg));
                } else {
                    ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(60).append("isStaleResponseAllowed: stale response outside of max-stale ").append(maxStale2).toString());
                    none$ = None$.MODULE$;
                }
                some = none$;
            } else if (None$.MODULE$.equals(option)) {
                ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: maxStale has no delta, stale response allowed");
                String msg = "Request contains no-args max-stale directive";
                some = new Some((Object)new ResponseServeActions.ServeStale(msg));
            } else {
                throw new MatchError(option);
            }
            return some;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug("isStaleResponseAllowed: stale response not allowed");
            return None$.MODULE$;
        });
        return result;
    }

    public Option<ResponseServeActions.ValidateOrTimeout> isStaleResponseExplicitlyProhibited(CacheRequest request, StoredResponse response) {
        Some some;
        if (ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().trace(new StringBuilder(50).append("isStaleResponseProhibited: request = ").append(request).append(", response = ").append(response).toString());
        }
        if (response.directives().contains((Object)CacheDirectives$MustRevalidate$.MODULE$)) {
            some = new Some((Object)new ResponseServeActions.ValidateOrTimeout("Response is stale, response contains must-revalidate directive"));
        } else if (this.cache.isShared()) {
            if (response.directives().contains((Object)CacheDirectives$ProxyRevalidate$.MODULE$)) {
                String msg = "Response is stale, response contains proxy-revalidate directive and cache is shared";
                some = new Some((Object)new ResponseServeActions.ValidateOrTimeout(msg));
            } else if (CacheDirectives$.MODULE$.sMaxAge(response.directives()).isDefined()) {
                String msg = "Response is stale, response contains s-maxage directive and cache is shared";
                some = new Some((Object)new ResponseServeActions.ValidateOrTimeout(msg));
            } else {
                some = None$.MODULE$;
            }
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<ResponseServeActions.ServeStaleAndValidate> canServeStaleAndRevalidate(Seconds age, CacheRequest request, StoredResponse response) {
        if (ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().isTraceEnabled()) {
            ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().trace(new StringBuilder(39).append("canServeStaleAndRevalidate: response = ").append(response).toString());
        }
        Seconds freshnessLifetime = this.freshnessCalculator().calculateFreshnessLifetime(request, response);
        return CacheDirectives$.MODULE$.staleWhileRevalidate(response.directives()).iterator().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.delta()).collectFirst((PartialFunction)new scala.Serializable(null, age, freshnessLifetime){
            public static final long serialVersionUID = 0L;
            private final Seconds age$2;
            private final Seconds freshnessLifetime$2;

            public final <A1 extends Seconds, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (this.age$2.isLessThan(this.freshnessLifetime$2.plus(A1))) {
                    ResponseServingCalculator$.MODULE$.com$typesafe$play$cachecontrol$ResponseServingCalculator$$logger().debug(new StringBuilder(44).append("canServeStaleAndRevalidate: age = ").append(this.age$2).append(", delta = ").append(A1).toString());
                    String reason = new StringBuilder(67).append("Response contains stale-while-revalidate and is within delta range ").append(A1).toString();
                    object = new ResponseServeActions.ServeStaleAndValidate(reason);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Seconds x1) {
                Seconds seconds = x1;
                boolean bl = this.age$2.isLessThan(this.freshnessLifetime$2.plus(seconds));
                return bl;
            }
            {
                this.age$2 = age$2;
                this.freshnessLifetime$2 = freshnessLifetime$2;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$noCacheFound$1(CacheDirective x$1) {
        return x$1 instanceof CacheDirectives.NoCache;
    }

    public ResponseServingCalculator(Cache cache) {
        this.cache = cache;
        this.freshnessCalculator = new FreshnessCalculator(cache);
    }
}

