/*
 * Decompiled with CFR 0.152.
 */
package imageserviceclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ImageServiceConfig {
    private static String TAG_CAPTCHA_SERVER = "captcha-server";
    private static String TAG_PROCESS_IMAGE_URL = "process-image-url";
    private static String TAG_LOGGING_URL = "logging-url";
    private static String TAG_PORT = "port";
    private static String TAG_USERNAME = "username";
    private static String TAG_PASSWORD = "password";
    private static String TAG_ANTIGATE = "antigate";
    private static String TAG_KEY = "key";
    private static String TAG_DEATH = "death";
    private static String TAG_USER = "user";
    private static String TAG_PWD = "pwd";
    private String processImageUrl;
    private String loggingUrl;
    private int port;
    private String username;
    private String password;
    private String antigate_key;
    private String user;
    private String pwd;
    private static ImageServiceConfig _inst;

    private ImageServiceConfig() {
    }

    public static ImageServiceConfig instance() {
        if (_inst == null) {
            _inst = new ImageServiceConfig();
        }
        return _inst;
    }

    public void loadWithoutEncrpt(String filePath) throws JDOMException, IOException {
        Document d = new SAXBuilder().build((InputStream)new FileInputStream(filePath));
        this.load(d);
    }

    private void load(Document doc) {
        Element rootElement = doc.getRootElement();
        Element captcha = rootElement.getChild(TAG_CAPTCHA_SERVER);
        this.processImageUrl = this.getEntryContent(captcha, TAG_PROCESS_IMAGE_URL);
        this.loggingUrl = this.getEntryContent(captcha, TAG_LOGGING_URL);
        this.port = Integer.parseInt(this.getEntryContent(captcha, TAG_PORT));
        this.username = this.getEntryContent(captcha, TAG_USERNAME);
        this.password = this.getEntryContent(captcha, TAG_PASSWORD);
        Element antigate = rootElement.getChild(TAG_ANTIGATE);
        this.antigate_key = this.getEntryContent(antigate, TAG_KEY);
        Element death = rootElement.getChild(TAG_DEATH);
        this.user = this.getEntryContent(death, TAG_USER);
        this.pwd = this.getEntryContent(death, TAG_PWD);
    }

    public String getLoggingUrl() {
        return this.loggingUrl;
    }

    public void setLoggingUrl(String loggingUrl) {
        this.loggingUrl = loggingUrl;
    }

    private String getEntryContent(Element parentElem, String key) {
        Element elem = parentElem.getChild(key);
        if (elem != null) {
            return elem.getText();
        }
        return "";
    }

    public String getProcessImageUrl() {
        return this.processImageUrl;
    }

    public void setProcessImageUrl(String processImageUrl) {
        this.processImageUrl = processImageUrl;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAntigate_key() {
        return this.antigate_key;
    }

    public void setAntigate_key(String antigate_key) {
        this.antigate_key = antigate_key;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }
}

