/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.sslconfig.ssl.SSLConfigParser;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.util.EnrichedConfig$;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u00113AAB\u0004\u0001!!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015a\u0004\u0001\"\u0001>\u0011!q\u0004\u0001#b\u0001\n\u0003z$AD,T\u0007>tg-[4QCJ\u001cXM\u001d\u0006\u0003\u0011%\t!a^:\u000b\u0005)Y\u0011\u0001\u00027jENT!\u0001D\u0007\u0002\u0007\u0005\u0004\u0018NC\u0001\u000f\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001!E\r\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012\u0001\u00027b]\u001eT\u0011AF\u0001\u0005U\u00064\u0018-\u0003\u0002\u0019'\t1qJ\u00196fGR\u00042AG\u0010\"\u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0019IgN[3di*\ta$A\u0003kCZ\f\u00070\u0003\u0002!7\tA\u0001K]8wS\u0012,'\u000f\u0005\u0002#G5\tq!\u0003\u0002%\u000f\tqqkU\"mS\u0016tGoQ8oM&<\u0017AB2p]\u001aLw\r\u0005\u0002([5\t\u0001F\u0003\u0002&S)\u0011!fK\u0001\tif\u0004Xm]1gK*\tA&A\u0002d_6L!A\f\u0015\u0003\r\r{gNZ5h\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0011\u0005I\t\u0014B\u0001\u001a\u0014\u0005-\u0019E.Y:t\u0019>\fG-\u001a:\u0002\rqJg.\u001b;?)\r)dg\u000e\t\u0003E\u0001AQ!J\u0002A\u0002\u0019BQaL\u0002A\u0002AB#aA\u001d\u0011\u0005iQ\u0014BA\u001e\u001c\u0005\u0019IeN[3di\u0006)\u0001/\u0019:tKR\t\u0011%A\u0002hKR,\u0012!\t\u0015\u0003\u0001\u0005\u0003\"A\u0007\"\n\u0005\r[\"!C*j]\u001edW\r^8o\u0001")
public class WSConfigParser
implements Provider<WSClientConfig> {
    private WSClientConfig get;
    private final Config config;
    private final ClassLoader classLoader;
    private volatile boolean bitmap$0;

    public WSClientConfig parse() {
        Some some;
        Config wsConfig = this.config.getConfig("play.ws");
        Duration connectionTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.connection"));
        Duration idleTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.idle"));
        Duration requestTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.request"));
        boolean followRedirects = wsConfig.getBoolean("followRedirects");
        boolean useProxyProperties = wsConfig.getBoolean("useProxyProperties");
        try {
            some = new Some((Object)wsConfig.getString("useragent"));
        }
        catch (ConfigException.Null e) {
            some = None$.MODULE$;
        }
        Some userAgent = some;
        boolean compressionEnabled = wsConfig.getBoolean("compressionEnabled");
        SSLConfigSettings sslConfig = new SSLConfigParser(EnrichedConfig$.MODULE$.apply(wsConfig.getConfig("ssl")), this.classLoader).parse();
        return new WSClientConfig(connectionTimeout, idleTimeout, requestTimeout, followRedirects, useProxyProperties, (Option<String>)userAgent, compressionEnabled, sslConfig);
    }

    private WSClientConfig get$lzycompute() {
        WSConfigParser wSConfigParser = this;
        synchronized (wSConfigParser) {
            if (!this.bitmap$0) {
                this.get = this.parse();
                this.bitmap$0 = true;
            }
        }
        return this.get;
    }

    public WSClientConfig get() {
        return !this.bitmap$0 ? this.get$lzycompute() : this.get;
    }

    @Inject
    public WSConfigParser(Config config, ClassLoader classLoader) {
        this.config = config;
        this.classLoader = classLoader;
    }
}

