/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch;

import akka.ConfigurationException;
import akka.actor.ActorSystem;
import akka.annotation.DoNotInherit;
import akka.annotation.InternalApi;
import akka.dispatch.BalancingDispatcherConfigurator;
import akka.dispatch.CachingConfig;
import akka.dispatch.DispatcherConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import akka.dispatch.Dispatchers$;
import akka.dispatch.MessageDispatcher;
import akka.dispatch.MessageDispatcherConfigurator;
import akka.dispatch.PinnedDispatcherConfigurator;
import akka.event.LoggingAdapter;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@DoNotInherit
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005v!\u0002\u0013&\u0011\u0003Qc!\u0002\u0017&\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%)a\u000e\u0005\u0007w\u0005\u0001\u000bQ\u0002\u001d\t\u000fq\n!\u0019!C\u0003{!1\u0011*\u0001Q\u0001\u000eyB\u0001BS\u0001C\u0002\u0013\u0015qe\u0013\u0005\u0007\u001f\u0006\u0001\u000bQ\u0002'\t\u000f]\u000b!\u0019!C\u00051\"1A,\u0001Q\u0001\ne3A\u0001L\u0013\u0001;\"Aal\u0003BC\u0002\u0013\u0005q\f\u0003\u0005k\u0017\t\u0005\t\u0015!\u0003a\u0011!Y7B!b\u0001\n\u0003a\u0007\u0002\u00039\f\u0005\u0003\u0005\u000b\u0011B7\t\u0011E\\!\u0011!Q\u0001\nIDa\u0001N\u0006\u0005\u0002\u001dB\bb\u0002@\f\u0005\u0004%\ta \u0005\t\u0003\u000fY\u0001\u0015!\u0003\u0002\u0002!I\u0011\u0011B\u0006C\u0002\u0013\u0005\u00111\u0002\u0005\t\u0003CY\u0001\u0015!\u0003\u0002\u000e!9\u00111E\u0006\u0005\u0002\u0005\u0015\u0002\"CA\u0017\u0017\t\u0007I\u0011BA\u0018\u0011!\tYe\u0003Q\u0001\n\u0005E\u0002BCA'\u0017\t\u0007I\u0011A\u0014\u0002&!A\u0011qJ\u0006!\u0002\u0013\t9\u0003C\u0004\u0002R-!\t!a\u0015\t\u000f\u0005e3\u0002\"\u0001\u0002\\!9\u0011QM\u0006\u0005\n\u0005\u001d\u0004bBA8\u0017\u0011\u0005\u0011\u0011\u000f\u0005\t\u0003'YA\u0011A\u0014\u0002z!A\u00111C\u0006\u0005\u0002\u001d\ni\bC\u0004\u0002\u0006.!I!a\"\t\u0011\u0005-5\u0002\"\u0001(\u0003\u001bCq!a%\f\t\u0013\t)*A\u0006ESN\u0004\u0018\r^2iKJ\u001c(B\u0001\u0014(\u0003!!\u0017n\u001d9bi\u000eD'\"\u0001\u0015\u0002\t\u0005\\7.Y\u0002\u0001!\tY\u0013!D\u0001&\u0005-!\u0015n\u001d9bi\u000eDWM]:\u0014\u0005\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002U\u0005\u0019B)\u001a4bk2$H)[:qCR\u001c\u0007.\u001a:JIV\t\u0001hD\u0001:C\u0005Q\u0014!H1lW\u0006t\u0013m\u0019;pe:\"WMZ1vYRlC-[:qCR\u001c\u0007.\u001a:\u0002)\u0011+g-Y;mi\u0012K7\u000f]1uG\",'/\u00133!\u0003m!UMZ1vYR\u0014En\\2lS:<G)[:qCR\u001c\u0007.\u001a:JIV\ta\b\u0005\u0002@\r:\u0011\u0001\t\u0012\t\u0003\u0003Bj\u0011A\u0011\u0006\u0003\u0007&\na\u0001\u0010:p_Rt\u0014BA#1\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0003\u0014\u0001\b#fM\u0006,H\u000e\u001e\"m_\u000e\\\u0017N\\4ESN\u0004\u0018\r^2iKJLE\rI\u0001\u0015\u0013:$XM\u001d8bY\u0012K7\u000f]1uG\",'/\u00133\u0016\u00031{\u0011!T\u0011\u0002\u001d\u0006q\u0012m[6b]\u0005\u001cGo\u001c:/S:$XM\u001d8bY6\"\u0017n\u001d9bi\u000eDWM]\u0001\u0016\u0013:$XM\u001d8bY\u0012K7\u000f]1uG\",'/\u00133!Q\tA\u0011\u000b\u0005\u0002S+6\t1K\u0003\u0002UO\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001b&aC%oi\u0016\u0014h.\u00197Ba&\fq#T1y\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018\t\\5bg\u0012+\u0007\u000f\u001e5\u0016\u0003e\u0003\"a\f.\n\u0005m\u0003$aA%oi\u0006AR*\u0019=ESN\u0004\u0018\r^2iKJ\fE.[1t\t\u0016\u0004H\u000f\u001b\u0011\u0014\u0005-q\u0013\u0001C:fiRLgnZ:\u0016\u0003\u0001\u0004\"!Y4\u000f\u0005\t,W\"A2\u000b\u0005\u0011<\u0013!B1di>\u0014\u0018B\u00014d\u0003-\t5\r^8s'f\u001cH/Z7\n\u0005!L'\u0001C*fiRLgnZ:\u000b\u0005\u0019\u001c\u0017!C:fiRLgnZ:!\u00035\u0001(/\u001a:fcVL7/\u001b;fgV\tQ\u000e\u0005\u0002,]&\u0011q.\n\u0002\u0018\t&\u001c\b/\u0019;dQ\u0016\u0014\bK]3sKF,\u0018n]5uKN\fa\u0002\u001d:fe\u0016\fX/[:ji\u0016\u001c\b%\u0001\u0004m_\u001e<WM\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u001e\nQ!\u001a<f]RL!a\u001e;\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;feR!\u0011P_>}!\tY3\u0002C\u0003_#\u0001\u0007\u0001\rC\u0003l#\u0001\u0007Q\u000eC\u0003r#\u0001\u0007!\u000f\u000b\u0002\u0012#\u0006i1-Y2iS:<7i\u001c8gS\u001e,\"!!\u0001\u0011\u0007-\n\u0019!C\u0002\u0002\u0006\u0015\u0012QbQ1dQ&twmQ8oM&<\u0017AD2bG\"LgnZ\"p]\u001aLw\rI\u0001\u0018I\u00164\u0017-\u001e7u\t&\u001c\b/\u0019;dQ\u0016\u00148i\u001c8gS\u001e,\"!!\u0004\u0011\t\u0005=\u0011QD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u000511m\u001c8gS\u001eTA!a\u0006\u0002\u001a\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002\u001c\u0005\u00191m\\7\n\t\u0005}\u0011\u0011\u0003\u0002\u0007\u0007>tg-[4\u00021\u0011,g-Y;mi\u0012K7\u000f]1uG\",'oQ8oM&<\u0007%A\feK\u001a\fW\u000f\u001c;HY>\u0014\u0017\r\u001c#jgB\fGo\u00195feV\u0011\u0011q\u0005\t\u0004W\u0005%\u0012bAA\u0016K\t\tR*Z:tC\u001e,G)[:qCR\u001c\u0007.\u001a:\u0002/\u0011L7\u000f]1uG\",'oQ8oM&<WO]1u_J\u001cXCAA\u0019!\u001d\t\u0019$!\u0011?\u0003\u000bj!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u001e\u0003{\tA!\u001e;jY*\u0011\u0011qH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005U\"!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u00191&a\u0012\n\u0007\u0005%SEA\u000fNKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJ\u001cuN\u001c4jOV\u0014\u0018\r^8s\u0003a!\u0017n\u001d9bi\u000eDWM]\"p]\u001aLw-\u001e:bi>\u00148\u000fI\u0001\u0013S:$XM\u001d8bY\u0012K7\u000f]1uG\",'/A\nj]R,'O\\1m\t&\u001c\b/\u0019;dQ\u0016\u0014\b%\u0001\u0004m_>\\W\u000f\u001d\u000b\u0005\u0003O\t)\u0006\u0003\u0004\u0002Xm\u0001\rAP\u0001\u0003S\u0012\fQ\u0002[1t\t&\u001c\b/\u0019;dQ\u0016\u0014H\u0003BA/\u0003G\u00022aLA0\u0013\r\t\t\u0007\r\u0002\b\u0005>|G.Z1o\u0011\u0019\t9\u0006\ba\u0001}\u0005\u0011Bn\\8lkB\u001cuN\u001c4jOV\u0014\u0018\r^8s)\u0019\t)%!\u001b\u0002l!1\u0011qK\u000fA\u0002yBa!!\u001c\u001e\u0001\u0004I\u0016!\u00023faRD\u0017\u0001\u0006:fO&\u001cH/\u001a:D_:4\u0017nZ;sCR|'\u000f\u0006\u0004\u0002^\u0005M\u0014Q\u000f\u0005\u0007\u0003/r\u0002\u0019\u0001 \t\u000f\u0005]d\u00041\u0001\u0002F\u0005a1m\u001c8gS\u001e,(/\u0019;peR!\u0011QBA>\u0011\u0019\t9f\ba\u0001}Q1\u0011QBA@\u0003\u0003Ca!a\u0016!\u0001\u0004q\u0004bBABA\u0001\u0007\u0011QB\u0001\nCB\u00048i\u001c8gS\u001e\f\u0001\"\u001b3D_:4\u0017n\u001a\u000b\u0005\u0003\u001b\tI\t\u0003\u0004\u0002X\u0005\u0002\rAP\u0001\u0005MJ|W\u000e\u0006\u0003\u0002(\u0005=\u0005bBAIE\u0001\u0007\u0011QB\u0001\u0004G\u001a<\u0017\u0001E2p]\u001aLw-\u001e:bi>\u0014hI]8n)\u0011\t)%a&\t\u000f\u0005E5\u00051\u0001\u0002\u000e!\u001a1\"a'\u0011\u0007I\u000bi*C\u0002\u0002 N\u0013A\u0002R8O_RLe\u000e[3sSR\u0004")
public class Dispatchers {
    private final ActorSystem.Settings settings;
    private final DispatcherPrerequisites prerequisites;
    private final LoggingAdapter logger;
    private final CachingConfig cachingConfig;
    private final Config defaultDispatcherConfig;
    private final ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators;
    private final MessageDispatcher internalDispatcher;

    public static String DefaultBlockingDispatcherId() {
        return Dispatchers$.MODULE$.DefaultBlockingDispatcherId();
    }

    public static String DefaultDispatcherId() {
        return Dispatchers$.MODULE$.DefaultDispatcherId();
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public CachingConfig cachingConfig() {
        return this.cachingConfig;
    }

    public Config defaultDispatcherConfig() {
        return this.defaultDispatcherConfig;
    }

    public MessageDispatcher defaultGlobalDispatcher() {
        return this.lookup("akka.actor.default-dispatcher");
    }

    private ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators() {
        return this.dispatcherConfigurators;
    }

    public MessageDispatcher internalDispatcher() {
        return this.internalDispatcher;
    }

    public MessageDispatcher lookup(String id) {
        return this.lookupConfigurator(id, 0).dispatcher();
    }

    public boolean hasDispatcher(String id) {
        return this.dispatcherConfigurators().containsKey(id) || this.cachingConfig().hasPath(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MessageDispatcherConfigurator lookupConfigurator(String id, int depth) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (depth > Dispatchers$.MODULE$.akka$dispatch$Dispatchers$$MaxDispatcherAliasDepth()) {
            throw new ConfigurationException(new StringBuilder(114).append("Didn't find a concrete dispatcher config after following ").append(Dispatchers$.MODULE$.akka$dispatch$Dispatchers$$MaxDispatcherAliasDepth()).append(", ").append("is there a loop in your config? last looked for id was ").append(id).toString());
        }
        MessageDispatcherConfigurator messageDispatcherConfigurator2 = this.dispatcherConfigurators().get(id);
        if (messageDispatcherConfigurator2 != null) return messageDispatcherConfigurator2;
        if (!this.cachingConfig().hasPath(id)) throw new ConfigurationException(new StringBuilder(28).append("Dispatcher [").append(id).append("] not configured").toString());
        ConfigValue valueAtPath = this.cachingConfig().getValue(id);
        ConfigValueType configValueType = valueAtPath.valueType();
        if (ConfigValueType.STRING.equals(configValueType)) {
            String actualId = (String)valueAtPath.unwrapped();
            this.logger.debug("Dispatcher id [{}] is an alias, actual dispatcher will be [{}]", id, actualId);
            messageDispatcherConfigurator = this.lookupConfigurator(actualId, depth + 1);
        } else {
            if (!ConfigValueType.OBJECT.equals(configValueType)) throw new ConfigurationException(new StringBuilder(66).append("Expected either a dispatcher config or an alias at [").append(id).append("] but found [").append(configValueType).append("]").toString());
            messageDispatcherConfigurator = this.configuratorFrom(this.config(id));
        }
        MessageDispatcherConfigurator newConfigurator = messageDispatcherConfigurator;
        MessageDispatcherConfigurator messageDispatcherConfigurator3 = this.dispatcherConfigurators().putIfAbsent(id, newConfigurator);
        MessageDispatcherConfigurator messageDispatcherConfigurator4 = messageDispatcherConfigurator3 == null ? newConfigurator : messageDispatcherConfigurator3;
        return messageDispatcherConfigurator4;
    }

    public boolean registerConfigurator(String id, MessageDispatcherConfigurator configurator2) {
        return this.dispatcherConfigurators().putIfAbsent(id, configurator2) == null;
    }

    public Config config(String id) {
        return this.config(id, this.settings().config().getConfig(id));
    }

    public Config config(String id, Config appConfig) {
        return this.idConfig(id).withFallback((ConfigMergeable)appConfig).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)((java.util.Map)package$JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)Dispatchers.simpleName$1(id))}))).asJava()))).withFallback((ConfigMergeable)this.defaultDispatcherConfig());
    }

    private Config idConfig(String id) {
        return ConfigFactory.parseMap((java.util.Map)((java.util.Map)package$JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)id)}))).asJava()));
    }

    public MessageDispatcher from(Config cfg) {
        return this.configuratorFrom(cfg).dispatcher();
    }

    private MessageDispatcherConfigurator configuratorFrom(Config cfg) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (!cfg.hasPath("id")) {
            throw new ConfigurationException(new StringBuilder(44).append("Missing dispatcher 'id' property in config: ").append(cfg.root().render()).toString());
        }
        String string = cfg.getString("type");
        if ("Dispatcher".equals(string)) {
            messageDispatcherConfigurator = new DispatcherConfigurator(cfg, this.prerequisites());
        } else {
            if ("BalancingDispatcher".equals(string)) {
                throw new IllegalArgumentException(new StringBuilder(163).append("BalancingDispatcher is deprecated, use a BalancingPool instead. During a migration period you can still use BalancingDispatcher by specifying the full class name: ").append(BalancingDispatcherConfigurator.class.getName()).toString());
            }
            if ("PinnedDispatcher".equals(string)) {
                messageDispatcherConfigurator = new PinnedDispatcherConfigurator(cfg, this.prerequisites());
            } else {
                .colon.colon args = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class), (Object)this.prerequisites()), (List)Nil$.MODULE$));
                messageDispatcherConfigurator = (MessageDispatcherConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(string, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MessageDispatcherConfigurator.class)).recover((PartialFunction)new Serializable(null, string, cfg){
                    public static final long serialVersionUID = 0L;
                    private final String x1$1;
                    private final Config cfg$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        throw new ConfigurationException(new StringOps(Predef$.MODULE$.augmentString("Cannot instantiate MessageDispatcherConfigurator type [%s], defined in [%s], make sure it has constructor with [com.typesafe.config.Config] and [akka.dispatch.DispatcherPrerequisites] parameters")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1, this.cfg$1.getString("id")})), A1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.x1$1 = x1$1;
                        this.cfg$1 = cfg$1;
                    }
                }).get();
            }
        }
        return messageDispatcherConfigurator;
    }

    private static final String simpleName$1(String id$1) {
        return id$1.substring(id$1.lastIndexOf(46) + 1);
    }

    @InternalApi
    public Dispatchers(ActorSystem.Settings settings, DispatcherPrerequisites prerequisites, LoggingAdapter logger) {
        this.settings = settings;
        this.prerequisites = prerequisites;
        this.logger = logger;
        this.cachingConfig = new CachingConfig(settings.config());
        this.defaultDispatcherConfig = this.idConfig("akka.actor.default-dispatcher").withFallback((ConfigMergeable)settings.config().getConfig("akka.actor.default-dispatcher"));
        this.dispatcherConfigurators = new ConcurrentHashMap();
        this.internalDispatcher = this.lookup("akka.actor.internal-dispatcher");
    }
}

