/*
 * Decompiled with CFR 0.152.
 */
package akka.event;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogMarker$;
import akka.actor.ActorRef;
import akka.actor.ActorRef$;
import akka.actor.AllDeadLetters;
import akka.actor.DeadLetter;
import akka.actor.DeadLetterActorRef;
import akka.actor.Dropped;
import akka.actor.SupervisorStrategy;
import akka.actor.WrappedMessage;
import akka.actor.WrappedMessage$;
import akka.annotation.InternalApi;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.Logging$Info$;
import akka.util.PrettyDuration$;
import akka.util.PrettyDuration$PrettyPrintableDuration$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\f\u0019\u0001uAQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u00044\u0001\u0001\u0006I\u0001\r\u0005\bi\u0001\u0011\r\u0011\"\u00056\u0011\u0019I\u0004\u0001)A\u0005m!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u0004A\u0001\u0001\u0007I\u0011C\u001b\t\u000f\u0005\u0003\u0001\u0019!C\t\u0005\"1\u0001\n\u0001Q!\nYBQ!\u0013\u0001\u0005B)CQa\u0013\u0001\u0005B1CQa\u0017\u0001\u0005BqCQA\u001a\u0001\u0005B)CQa\u001a\u0001\u0005\n)CQ\u0001\u001b\u0001\u0005\u0002%DQA\u001c\u0001\u0005\n%DQa\u001c\u0001\u0005\n%DQ\u0001\u001d\u0001\u0005\nEDQ\u0001 \u0001\u0005\nuDq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002,\u0001!I!!\f\u0003%\u0011+\u0017\r\u001a'fiR,'\u000fT5ti\u0016tWM\u001d\u0006\u00033i\tQ!\u001a<f]RT\u0011aG\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K!j\u0011A\n\u0006\u0003Oi\tQ!Y2u_JL!!\u000b\u0014\u0003\u000b\u0005\u001bGo\u001c:\u0002\rqJg.\u001b;?)\u0005a\u0003CA\u0017\u0001\u001b\u0005A\u0012aC3wK:$8\u000b\u001e:fC6,\u0012\u0001\r\t\u0003[EJ!A\r\r\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\\\u0001\rKZ,g\u000e^*ue\u0016\fW\u000eI\u0001\t[\u0006D8i\\;oiV\ta\u0007\u0005\u0002 o%\u0011\u0001\b\t\u0002\u0004\u0013:$\u0018!C7bq\u000e{WO\u001c;!\u0003iI7/\u00117xCf\u001cHj\\4hS:<G)Z1e\u0019\u0016$H/\u001a:t+\u0005a\u0004CA\u0010>\u0013\tq\u0004EA\u0004C_>dW-\u00198\u00027%\u001c\u0018\t\\<bsNdunZ4j]\u001e$U-\u00193MKR$XM]:!\u0003\u0015\u0019w.\u001e8u\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011q\u0004R\u0005\u0003\u000b\u0002\u0012A!\u00168ji\"9q)CA\u0001\u0002\u00041\u0014a\u0001=%c\u000511m\\;oi\u0002\n\u0001\u0002\u001d:f'R\f'\u000f\u001e\u000b\u0002\u0007\u0006Y\u0001o\\:u%\u0016\u001cH/\u0019:u)\t\u0019U\nC\u0003O\u0019\u0001\u0007q*\u0001\u0004sK\u0006\u001cxN\u001c\t\u0003!bs!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Qc\u0012A\u0002\u001fs_>$h(C\u0001\"\u0013\t9\u0006%A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&!\u0003+ie><\u0018M\u00197f\u0015\t9\u0006%\u0001\u0006qe\u0016\u0014Vm\u001d;beR$2aQ/_\u0011\u0015qU\u00021\u0001P\u0011\u0015yV\u00021\u0001a\u0003\u001diWm]:bO\u0016\u00042aH1d\u0013\t\u0011\u0007E\u0001\u0004PaRLwN\u001c\t\u0003?\u0011L!!\u001a\u0011\u0003\u0007\u0005s\u00170\u0001\u0005q_N$8\u000b^8q\u00039Ign\u0019:f[\u0016tGoQ8v]R\fqA]3dK&4X-F\u0001k!\tYG.D\u0001\u0001\u0013\ti\u0007FA\u0004SK\u000e,\u0017N^3\u00021I,7-Z5wK^KG\u000f[!mo\u0006L8\u000fT8hO&tw-\u0001\u000esK\u000e,\u0017N^3XSRDW*\u0019=D_VtG\u000fT8hO&tw-A\rsK\u000e,\u0017N^3XSRD7+^:qK:$Gj\\4hS:<GC\u00016s\u0011\u0015\u00198\u00031\u0001u\u0003=\u0019Xo\u001d9f]\u0012$UO]1uS>t\u0007CA;{\u001b\u00051(BA<y\u0003!!WO]1uS>t'BA=!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003wZ\u0014aBR5oSR,G)\u001e:bi&|g.\u0001\u000bsK\u000e,\u0017N^3XQ\u0016t7+^:qK:$W\r\u001a\u000b\u0004Uz|\b\"B:\u0015\u0001\u0004!\bbBA\u0001)\u0001\u0007\u00111A\u0001\u0010gV\u001c\b/\u001a8e\t\u0016\fG\r\\5oKB\u0019Q/!\u0002\n\u0007\u0005\u001daO\u0001\u0005EK\u0006$G.\u001b8f\u00035awn\u001a#fC\u0012dU\r\u001e;feR)1)!\u0004\u0002\u0018!9\u0011qB\u000bA\u0002\u0005E\u0011!\u00013\u0011\u0007\u0015\n\u0019\"C\u0002\u0002\u0016\u0019\u0012a\"\u00117m\t\u0016\fG\rT3ui\u0016\u00148\u000fC\u0004\u0002\u001aU\u0001\r!a\u0007\u0002\u000f\u0011|g.Z'tOB!\u0011QDA\u0013\u001d\u0011\ty\"!\t\u0011\u0005I\u0003\u0013bAA\u0012A\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t!\u0003\u0019I7OU3bYR\u0019A(a\f\t\u000f\u0005Eb\u00031\u0001\u00024\u0005\u00191O\u001c3\u0011\u0007\u0015\n)$C\u0002\u00028\u0019\u0012\u0001\"Q2u_J\u0014VM\u001a")
public class DeadLetterListener
implements Actor {
    private final EventStream eventStream;
    private final int maxCount;
    private final boolean isAlwaysLoggingDeadLetters;
    private int count;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public EventStream eventStream() {
        return this.eventStream;
    }

    public int maxCount() {
        return this.maxCount;
    }

    private boolean isAlwaysLoggingDeadLetters() {
        return this.isAlwaysLoggingDeadLetters;
    }

    public int count() {
        return this.count;
    }

    public void count_$eq(int x$1) {
        this.count = x$1;
    }

    @Override
    public void preStart() {
        this.eventStream().subscribe(this.self(), DeadLetter.class);
        this.eventStream().subscribe(this.self(), Dropped.class);
    }

    @Override
    public void postRestart(Throwable reason) {
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) {
    }

    @Override
    public void postStop() {
        this.eventStream().unsubscribe(this.self());
    }

    public void akka$event$DeadLetterListener$$incrementCount() {
        if (this.count() == Integer.MAX_VALUE) {
            Logging$.MODULE$.getLogger(this).info("Resetting DeadLetterListener counter after reaching Int.MaxValue.");
            this.count_$eq(1);
        } else {
            this.count_$eq(this.count() + 1);
        }
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        PartialFunction<Object, BoxedUnit> partialFunction;
        if (this.isAlwaysLoggingDeadLetters()) {
            partialFunction = this.receiveWithAlwaysLogging();
        } else {
            PartialFunction<Object, BoxedUnit> partialFunction2;
            Duration duration = this.context().system().settings().LogDeadLettersSuspendDuration();
            if (duration instanceof FiniteDuration) {
                FiniteDuration finiteDuration = (FiniteDuration)duration;
                partialFunction2 = this.akka$event$DeadLetterListener$$receiveWithSuspendLogging(finiteDuration);
            } else {
                partialFunction2 = this.receiveWithMaxCountLogging();
            }
            partialFunction = partialFunction2;
        }
        return partialFunction;
    }

    private PartialFunction<Object, BoxedUnit> receiveWithAlwaysLogging() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AllDeadLetters) {
                    AllDeadLetters allDeadLetters = (AllDeadLetters)A1;
                    this.$outer.akka$event$DeadLetterListener$$incrementCount();
                    this.$outer.akka$event$DeadLetterListener$$logDeadLetter(allDeadLetters, "");
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof AllDeadLetters;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private PartialFunction<Object, BoxedUnit> receiveWithMaxCountLogging() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AllDeadLetters) {
                    BoxedUnit boxedUnit;
                    AllDeadLetters allDeadLetters = (AllDeadLetters)A1;
                    this.$outer.akka$event$DeadLetterListener$$incrementCount();
                    if (this.$outer.count() == this.$outer.maxCount()) {
                        this.$outer.akka$event$DeadLetterListener$$logDeadLetter(allDeadLetters, ", no more dead letters will be logged");
                        this.$outer.context().stop(this.$outer.self());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.akka$event$DeadLetterListener$$logDeadLetter(allDeadLetters, "");
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof AllDeadLetters;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> akka$event$DeadLetterListener$$receiveWithSuspendLogging(FiniteDuration suspendDuration) {
        return new Serializable(this, suspendDuration){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;
            private final FiniteDuration suspendDuration$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AllDeadLetters) {
                    BoxedUnit boxedUnit;
                    AllDeadLetters allDeadLetters = (AllDeadLetters)A1;
                    this.$outer.akka$event$DeadLetterListener$$incrementCount();
                    if (this.$outer.count() == this.$outer.maxCount()) {
                        String doneMsg = new StringBuilder(48).append(", no more dead letters will be logged in next [").append(PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension0(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.suspendDuration$1))).append("]").toString();
                        this.$outer.akka$event$DeadLetterListener$$logDeadLetter(allDeadLetters, doneMsg);
                        this.$outer.context().become(this.$outer.akka$event$DeadLetterListener$$receiveWhenSuspended(this.suspendDuration$1, Deadline$.MODULE$.now().$plus(this.suspendDuration$1)));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.akka$event$DeadLetterListener$$logDeadLetter(allDeadLetters, "");
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof AllDeadLetters;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.suspendDuration$1 = suspendDuration$1;
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> akka$event$DeadLetterListener$$receiveWhenSuspended(FiniteDuration suspendDuration, Deadline suspendDeadline) {
        return new Serializable(this, suspendDeadline, suspendDuration){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeadLetterListener $outer;
            private final Deadline suspendDeadline$1;
            private final FiniteDuration suspendDuration$2;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AllDeadLetters) {
                    BoxedUnit boxedUnit;
                    AllDeadLetters allDeadLetters = (AllDeadLetters)A1;
                    this.$outer.akka$event$DeadLetterListener$$incrementCount();
                    if (this.suspendDeadline$1.isOverdue()) {
                        String doneMsg = new StringBuilder(58).append(", of which ").append(this.$outer.count() - this.$outer.maxCount() - 1).append(" were not logged. The counter will be reset now").toString();
                        this.$outer.akka$event$DeadLetterListener$$logDeadLetter(allDeadLetters, doneMsg);
                        this.$outer.count_$eq(0);
                        this.$outer.context().become(this.$outer.akka$event$DeadLetterListener$$receiveWithSuspendLogging(this.suspendDuration$2));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof AllDeadLetters;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.suspendDeadline$1 = suspendDeadline$1;
                this.suspendDuration$2 = suspendDuration$2;
            }
        };
    }

    public void akka$event$DeadLetterListener$$logDeadLetter(AllDeadLetters d, String doneMsg) {
        String string;
        String origin = this.isReal(d.sender()) ? new StringBuilder(6).append(" from ").append(d.sender()).toString() : "";
        Object unwrapped = WrappedMessage$.MODULE$.unwrap(d.message());
        String messageStr = unwrapped.getClass().getName();
        String wrappedIn = d.message() instanceof WrappedMessage ? new StringBuilder(14).append(" wrapped in [").append(d.message().getClass().getName()).append("]").toString() : "";
        AllDeadLetters allDeadLetters = d;
        if (allDeadLetters instanceof Dropped) {
            Dropped dropped = (Dropped)allDeadLetters;
            String destination = this.isReal(d.recipient()) ? new StringBuilder(4).append(" to ").append(d.recipient()).toString() : "";
            string = new StringBuilder(55).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(destination).append(" was dropped. ").append(dropped.reason()).append(". ").append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").toString();
        } else {
            string = new StringBuilder(139).append("Message [").append(messageStr).append("]").append(wrappedIn).append(origin).append(" to ").append(d.recipient()).append(" was not delivered. ").append("[").append(this.count()).append("] dead letters encountered").append(doneMsg).append(". ").append("If this is not an expected behavior then ").append(d.recipient()).append(" may have terminated unexpectedly. ").toString();
        }
        String logMessage = string;
        this.eventStream().publish(Logging$Info$.MODULE$.apply(d.recipient().path().toString(), d.recipient().getClass(), new StringBuilder(139).append(logMessage).append("This logging can be turned off or adjusted with configuration settings 'akka.log-dead-letters' ").append("and 'akka.log-dead-letters-during-shutdown'.").toString(), Logging$.MODULE$.emptyMDC(), ActorLogMarker$.MODULE$.deadLetter(messageStr)));
    }

    private boolean isReal(ActorRef snd) {
        return snd != ActorRef$.MODULE$.noSender() && snd != this.context().system().deadLetters() && !(snd instanceof DeadLetterActorRef);
    }

    public DeadLetterListener() {
        Actor.$init$(this);
        this.eventStream = this.context().system().eventStream();
        this.maxCount = this.context().system().settings().LogDeadLetters();
        this.isAlwaysLoggingDeadLetters = this.maxCount() == Integer.MAX_VALUE;
        this.count = 0;
    }
}

