/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011ev!\u0002/^\u0011\u0003\u0011g!\u00023^\u0011\u0003)\u0007\"\u00027\u0002\t\u0003iW\u0001\u00028\u0002\u0001=D!\"!\u0007\u0002\u0005\u0004%\taXA\u000e\u0011!\t9.\u0001Q\u0001\n\u0005uaABAs\u0003\u0001\t9\u000f\u0003\u0006\u0002j\u001a\u0011)\u0019!C\u0001\u0003WD!\"a@\u0007\u0005\u0003\u0005\u000b\u0011BAw\u0011\u0019ag\u0001\"\u0001\u0003\u0002!I!q\u0001\u0004C\u0002\u0013\u0005!\u0011\u0002\u0005\t\u0005+1\u0001\u0015!\u0003\u0003\f!I!q\u0003\u0004C\u0002\u0013\u0005!\u0011\u0002\u0005\t\u000531\u0001\u0015!\u0003\u0003\f!9!1\u0004\u0004\u0005\u000e\tu\u0001b\u0002B\u0012\u0003\u0011\u0005!Q\u0005\u0004\u0007\u0003[\t!)a\f\t\u0015\u0005u\u0002C!f\u0001\n\u0003\ty\u0004\u0003\u0006\u0002NA\u0011\t\u0012)A\u0005\u0003\u0003B!\"a\u0014\u0011\u0005+\u0007I\u0011AA)\u0011)\tI\u0006\u0005B\tB\u0003%\u00111\u000b\u0005\u0007YB!\t!a\u0017\t\u0013\u0005\u0005\u0004#!A\u0005\u0002\u0005\r\u0004\"CA5!E\u0005I\u0011AA6\u0011%\t\t\tEI\u0001\n\u0003\t\u0019\tC\u0005\u0002\bB\t\t\u0011\"\u0011\u0002\n\"I\u00111\u0014\t\u0002\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003K\u0003\u0012\u0011!C\u0001\u0003OC\u0011\"!,\u0011\u0003\u0003%\t%a,\t\u0013\u0005u\u0006#!A\u0005\u0002\u0005}\u0006\"CAe!\u0005\u0005I\u0011IAf\u0011%\ti\rEA\u0001\n\u0003\ny\rC\u0005\u0002RB\t\t\u0011\"\u0011\u0002T\u001eI!\u0011G\u0001\u0002\u0002#\u0005!1\u0007\u0004\n\u0003[\t\u0011\u0011!E\u0001\u0005kAa\u0001\u001c\u0012\u0005\u0002\t\r\u0003\"CAgE\u0005\u0005IQIAh\u0011%\u0011)EIA\u0001\n\u0003\u00139\u0005C\u0005\u0003N\t\n\t\u0011\"!\u0003P!I!Q\f\u0012\u0002\u0002\u0013%!q\f\u0005\b\u0005O\nA\u0011\u0001B5\u0011\u001d\u00119)\u0001C\u0001\u0005\u00133Q\u0001Z/\u0001\u0005\u0017C!\"a\u0014+\u0005\u000b\u0007I\u0011\u0001BJ\u0011)\tIF\u000bB\u0001B\u0003%!\u0011\u0011\u0005\u0007Y*\"\tA!&\t\u0013\tm%F1A\u0005\u0002\tu\u0005\u0002\u0003BRU\u0001\u0006IAa(\t\u0013\t\u0015&F1A\u0005\u0002\t\u001d\u0006\u0002\u0003BUU\u0001\u0006I!!1\t\u0011\t-&\u0006)A\u0005\u0005[C\u0011B!/+\u0005\u0004%\tAa/\t\u0011\t\r'\u0006)A\u0005\u0005{C\u0011B!2+\u0005\u0004%IAa2\t\u0011\tM(\u0006)A\u0005\u0005\u0013D\u0001B!>+\t\u0003y&q\u001f\u0005\b\u0005ORC\u0011\u0002B\u007f\u0011\u001d\u0019IA\u000bC\u0001\u0007\u0017Aqaa\t+\t\u0003\u0019)\u0003C\u0004\u0004$)\"\ta!\u001b\t\u000f\rU$\u0006\"\u0003\u0004x!91\u0011\u0011\u0016\u0005\u0002\r\r\u0005bBB\u0012U\u0011\u00051q\u0016\u0005\b\u0007\u007fSC\u0011ABa\u0011\u001d\u0019)M\u000bC\u0001\u0007\u000fDqaa6+\t\u0003\u0019I\u000eC\u0004\u0004X*\"Ia!9\t\u0013\r%(F1A\u0005\n\r-\b\u0002CB}U\u0001\u0006Ia!<\t\u0013\rm(F1A\u0005\n\ru\b\u0002\u0003C\u0001U\u0001\u0006Iaa@\t\u0015\u0011\r!F1A\u0005\u0002}#)\u0001\u0003\u0005\u0005\f)\u0002\u000b\u0011\u0002C\u0004\u0011\u001d!iA\u000bC\u0005\t\u001fAq\u0001b\u000b+\t\u0013!i\u0003C\u0004\u0005@)\"I\u0001\"\u0011\t\u000f\u0011\u001d#\u0006\"\u0003\u0005J!9AQ\n\u0016\u0005\n\u0011=\u0003b\u0002C,U\u0011%A\u0011\f\u0005\n\tKR#\u0019!C\u0005\tOB\u0001\u0002b\u001f+A\u0003%A\u0011\u000e\u0005\n\t{R#\u0019!C\u0001\t\u007fB\u0001\u0002b!+A\u0003%A\u0011\u0011\u0005\n\t\u000bS#\u0019!C\u0005\t\u000fC\u0001\u0002b#+A\u0003%A\u0011\u0012\u0005\b\t\u001bSC\u0011\u0002CH\u0011%!)J\u000bb\u0001\n\u0013\u00119\u000b\u0003\u0005\u0005\u0018*\u0002\u000b\u0011BAa\u0011%!IJ\u000bb\u0001\n\u0013\u00119\u000b\u0003\u0005\u0005\u001c*\u0002\u000b\u0011BAa\u0011\u001d!iJ\u000bC\u0005\t?C\u0001\u0002b)+\t\u0003yFQU\u0001\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005y{\u0016!D:fe&\fG.\u001b>bi&|gNC\u0001a\u0003\u0011\t7n[1\u0004\u0001A\u00111-A\u0007\u0002;\ni1+\u001a:jC2L'0\u0019;j_:\u001c\"!\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0003%\fQa]2bY\u0006L!a\u001b5\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!MA\bDY\u0006\u001c8oU3sS\u0006d\u0017N_3s!\u00159\u0007O]A\n\u0013\t\t\bN\u0001\u0004UkBdWM\r\u0019\u0004g\u0006\u0005\u0001c\u0001;|}:\u0011Q/\u001f\t\u0003m\"l\u0011a\u001e\u0006\u0003q\u0006\fa\u0001\u0010:p_Rt\u0014B\u0001>i\u0003\u0019\u0001&/\u001a3fM&\u0011A0 \u0002\u0006\u00072\f7o\u001d\u0006\u0003u\"\u00042a`A\u0001\u0019\u0001!1\"a\u0001\u0004\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\t\u0019q\fJ\u0019\u0012\t\u0005\u001d\u0011Q\u0002\t\u0004O\u0006%\u0011bAA\u0006Q\n9aj\u001c;iS:<\u0007cA4\u0002\u0010%\u0019\u0011\u0011\u00035\u0003\u0007\u0005s\u0017\u0010E\u0002d\u0003+I1!a\u0006^\u0005)\u0019VM]5bY&TXM]\u0001\u001cGV\u0014(/\u001a8u)J\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8\u0016\u0005\u0005u\u0001CBA\u0010\u0003K\tI#\u0004\u0002\u0002\")\u0019\u00111\u00055\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003O\t\tCA\bEs:\fW.[2WCJL\u0017M\u00197f!\r\tY\u0003E\u0007\u0002\u0003\tY\u0011J\u001c4pe6\fG/[8o'\u0019\u0001b-!\r\u00028A\u0019q-a\r\n\u0007\u0005U\u0002NA\u0004Qe>$Wo\u0019;\u0011\u0007\u001d\fI$C\u0002\u0002<!\u0014AbU3sS\u0006d\u0017N_1cY\u0016\fq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002BA!\u00111IA%\u001b\t\t)EC\u0002\u0002H}\u000bQ!Y2u_JLA!a\u0013\u0002F\t9\u0011\t\u001a3sKN\u001c\u0018\u0001C1eIJ,7o\u001d\u0011\u0002\rML8\u000f^3n+\t\t\u0019\u0006\u0005\u0003\u0002D\u0005U\u0013\u0002BA,\u0003\u000b\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004CCBA\u0015\u0003;\ny\u0006C\u0004\u0002>U\u0001\r!!\u0011\t\u000f\u0005=S\u00031\u0001\u0002T\u0005!1m\u001c9z)\u0019\tI#!\u001a\u0002h!I\u0011Q\b\f\u0011\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003\u001f2\u0002\u0013!a\u0001\u0003'\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002n)\"\u0011\u0011IA8W\t\t\t\b\u0005\u0003\u0002t\u0005uTBAA;\u0015\u0011\t9(!\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA>Q\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0014Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000bSC!a\u0015\u0002p\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006!A.\u00198h\u0015\t\t)*\u0001\u0003kCZ\f\u0017\u0002BAM\u0003\u001f\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAP!\r9\u0017\u0011U\u0005\u0004\u0003GC'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0007\u0003SC\u0011\"a+\u001c\u0003\u0003\u0005\r!a(\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\f\u0005\u0004\u00024\u0006e\u0016QB\u0007\u0003\u0003kS1!a.i\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\u000b)L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAa\u0003\u000f\u00042aZAb\u0013\r\t)\r\u001b\u0002\b\u0005>|G.Z1o\u0011%\tY+HA\u0001\u0002\u0004\ti!\u0001\u0005iCND7i\u001c3f)\t\ty*\u0001\u0005u_N#(/\u001b8h)\t\tY)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0003\f)\u000eC\u0005\u0002,\u0002\n\t\u00111\u0001\u0002\u000e\u0005a2-\u001e:sK:$HK]1ogB|'\u000f^%oM>\u0014X.\u0019;j_:\u0004\u0003fA\u0003\u0002\\B!\u0011Q\\Aq\u001b\t\tyNC\u0002\u0002|}KA!a9\u0002`\nY\u0011J\u001c;fe:\fG.\u00119j\u0005!\u0019V\r\u001e;j]\u001e\u001c8C\u0001\u0004g\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u001e\t\u0005\u0003_\fY0\u0004\u0002\u0002r*!\u0011\u0011^Az\u0015\u0011\t)0a>\u0002\u0011QL\b/Z:bM\u0016T!!!?\u0002\u0007\r|W.\u0003\u0003\u0002~\u0006E(AB\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0015\t\t\r!Q\u0001\t\u0004\u0003W1\u0001bBAu\u0013\u0001\u0007\u0011Q^\u0001\f'\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0006\u0002\u0003\fA9AO!\u0004\u0003\u0012\tE\u0011b\u0001B\b{\n\u0019Q*\u00199\u0011\u0007Q\u0014\u0019\"C\u0002\u0002\u001av\fAbU3sS\u0006d\u0017N_3sg\u0002\nQcU3sS\u0006d\u0017N_1uS>t')\u001b8eS:<7/\u0001\fTKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:!\u0003-\u0019wN\u001c4jOR{W*\u00199\u0015\t\t-!q\u0004\u0005\b\u0005Cq\u0001\u0019AAw\u0003\r\u0019gmZ\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016$\u0017i\u0019;peB\u000bG\u000f\u001b\u000b\u0005\u0005#\u00119\u0003C\u0004\u0003*=\u0001\rAa\u000b\u0002\u0011\u0005\u001cGo\u001c:SK\u001a\u0004B!a\u0011\u0003.%!!qFA#\u0005!\t5\r^8s%\u00164\u0017aC%oM>\u0014X.\u0019;j_:\u00042!a\u000b#'\u0015\u0011#qGA\u001c!)\u0011IDa\u0010\u0002B\u0005M\u0013\u0011F\u0007\u0003\u0005wQ1A!\u0010i\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0011\u0003<\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tM\u0012!B1qa2LHCBA\u0015\u0005\u0013\u0012Y\u0005C\u0004\u0002>\u0015\u0002\r!!\u0011\t\u000f\u0005=S\u00051\u0001\u0002T\u00059QO\\1qa2LH\u0003\u0002B)\u00053\u0002Ra\u001aB*\u0005/J1A!\u0016i\u0005\u0019y\u0005\u000f^5p]B1q\r]A!\u0003'B\u0011Ba\u0017'\u0003\u0003\u0005\r!!\u000b\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B1!\u0011\tiIa\u0019\n\t\t\u0015\u0014q\u0012\u0002\u0007\u001f\nTWm\u0019;\u00021]LG\u000f\u001b+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g.\u0006\u0003\u0003l\tED\u0003\u0002B7\u0005\u007f\"BAa\u001c\u0003vA\u0019qP!\u001d\u0005\u000f\tM\u0004F1\u0001\u0002\u0006\t\tA\u000bC\u0004\u0003x!\u0002\rA!\u001f\u0002\u0003\u0019\u0004Ra\u001aB>\u0005_J1A! i\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0002P!\u0002\rA!!\u0011\t\u0005\r#1Q\u0005\u0005\u0005\u000b\u000b)EA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0010hKR\u001cUO\u001d:f]R$&/\u00198ta>\u0014H/\u00138g_Jl\u0017\r^5p]R\u0011\u0011\u0011F\n\u0005U\u0019\u0014i\t\u0005\u0003\u0002D\t=\u0015\u0002\u0002BI\u0003\u000b\u0012\u0011\"\u0012=uK:\u001c\u0018n\u001c8\u0016\u0005\t\u0005E\u0003\u0002BL\u00053\u0003\"a\u0019\u0016\t\u000f\u0005=S\u00061\u0001\u0003\u0002\u0006A1/\u001a;uS:<7/\u0006\u0002\u0003 B\u0019!\u0011\u0015\u0004\u000f\u0005\r\u0004\u0011!C:fiRLgnZ:!\u0003Y\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>tWCAAa\u0003]\tE\u000e\\8x\u0015\u00064\u0018mU3sS\u0006d\u0017N_1uS>t\u0007%\u0001\u0003`Y><\u0007\u0003\u0002BX\u0005kk!A!-\u000b\u0007\tMv,A\u0003fm\u0016tG/\u0003\u0003\u00038\nE&\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'/A\u0002m_\u001e,\"A!0\u0011\t\t=&qX\u0005\u0005\u0005\u0003\u0014\tL\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u000e[\u0006t\u0017NZ3ti\u000e\u000b7\r[3\u0016\u0005\t%\u0007C\u0002Bf\u0005/\u0014Y.\u0004\u0002\u0003N*!!q\u001aBi\u0003\u0019\tGo\\7jG*!!1\u001bBk\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003G\t\u0019*\u0003\u0003\u0003Z\n5'aD!u_6L7MU3gKJ,gnY3\u0011\u0011\tu'1\u001dB\t\u0005Kl!Aa8\u000b\t\t\u0005\u0018QW\u0001\nS6lW\u000f^1cY\u0016LAAa\u0004\u0003`B)qMa\u0015\u0003hB\"!\u0011\u001eBx!\u0019\tiIa;\u0003n&\u0019A0a$\u0011\u0007}\u0014y\u000fB\u0006\u0003rZ\n\t\u0011!A\u0003\u0002\u0005\u0015!aA0%e\u0005qQ.\u00198jM\u0016\u001cHoQ1dQ\u0016\u0004\u0013\u0001G:fe&\fG.\u001b>bi&|g.\u00138g_Jl\u0017\r^5p]V\u0011!\u0011 \t\u0004\u0005C\u0003\u0002fA\u001c\u0002\\V!!q`B\u0002)\u0011\u0019\ta!\u0002\u0011\u0007}\u001c\u0019\u0001B\u0004\u0003ta\u0012\r!!\u0002\t\u000f\t]\u0004\b1\u0001\u0004\bA)qMa\u001f\u0004\u0002\u0005I1/\u001a:jC2L'0\u001a\u000b\u0005\u0007\u001b\u0019y\u0002\u0005\u0004\u0002 \r=11C\u0005\u0005\u0007#\t\tCA\u0002Uef\u0004RaZB\u000b\u00073I1aa\u0006i\u0005\u0015\t%O]1z!\r971D\u0005\u0004\u0007;A'\u0001\u0002\"zi\u0016Daa!\t:\u0001\u00041\u0017!A8\u0002\u0017\u0011,7/\u001a:jC2L'0Z\u000b\u0005\u0007O\u0019i\u0003\u0006\u0005\u0004*\r=21GB\u001c!\u0019\tyba\u0004\u0004,A\u0019qp!\f\u0005\u000f\tM$H1\u0001\u0002\u0006!91\u0011\u0007\u001eA\u0002\rM\u0011!\u00022zi\u0016\u001c\bbBB\u001bu\u0001\u0007\u0011qT\u0001\rg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\n\u001a\u0005\b\u0007sQ\u0004\u0019AB\u001e\u0003\u0015\u0019G.\u0019>{!\u00159'1KB\u001fa\u0011\u0019yda\u0011\u0011\tQ\\8\u0011\t\t\u0004\u007f\u000e\rC\u0001DB#\u0007\u000f\n\t\u0011!A\u0003\u0002\r]#aA0%i!91\u0011\b\u001eA\u0002\r%\u0003#B4\u0003T\r-\u0003\u0007BB'\u0007#\u0002B\u0001^>\u0004PA\u0019qp!\u0015\u0005\u0019\r\u00153qIA\u0001\u0002\u0003\u0015\taa\u0015\u0012\t\u0005\u001d1Q\u000b\t\u0004\u007f\u000e5\u0012\u0003BA\u0004\u0007WAsAOB.\u0007C\u001a)\u0007E\u0002h\u0007;J1aa\u0018i\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0007G\nA(V:fA\u0011,7/\u001a:jC2L'0\u001a\u0011uQ\u0006$\b%Y2dKB$8\u000f\t;iK\u0002\u0002W.\u00198jM\u0016\u001cH\u000f\u0019\u0011bg\u0002\n\u0007e\u00197bgN\u0004c.Y7f]\u0005\u00121qM\u0001\u0006e92d\u0006\r\u000b\t\u0007W\u001aiga\u001c\u0004rA)\u0011qDB\bM\"91\u0011G\u001eA\u0002\rM\u0001bBB\u001bw\u0001\u0007\u0011q\u0014\u0005\b\u0007gZ\u0004\u0019\u0001B\t\u0003!i\u0017M\\5gKN$\u0018\u0001\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0015\u0010^3BeJ\f\u0017\u0010F\u0004g\u0007s\u001aYha \t\u000f\rEB\b1\u0001\u0004\u0014!91Q\u0010\u001fA\u0002\u0005M\u0011AC:fe&\fG.\u001b>fe\"911\u000f\u001fA\u0002\tE\u0011!\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\bM\u000e\u00155QSBL\u0011\u001d\u00199)\u0010a\u0001\u0007\u0013\u000b1AY;g!\u0011\u0019Yi!%\u000e\u0005\r5%\u0002BBH\u0003'\u000b1A\\5p\u0013\u0011\u0019\u0019j!$\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u00046u\u0002\r!a(\t\u000f\rMT\b1\u0001\u0003\u0012!*Qha'\u0004.B)qm!(\u0004\"&\u00191q\u00145\u0003\rQD'o\\<t!\u0011\u0019\u0019k!+\u000e\u0005\r\u0015&\u0002BBT\u0003'\u000b!![8\n\t\r-6Q\u0015\u0002\u0019\u001d>$8+\u001a:jC2L'0\u00192mK\u0016C8-\u001a9uS>t7EABQ+\u0011\u0019\tla.\u0015\r\rM6\u0011XB^!\u0019\tyba\u0004\u00046B\u0019qpa.\u0005\u000f\tMdH1\u0001\u0002\u0006!91\u0011\u0007 A\u0002\rM\u0001bBB\u001d}\u0001\u00071Q\u0018\t\u0005in\u001c),A\tgS:$7+\u001a:jC2L'0\u001a:G_J$B!a\u0005\u0004D\"11\u0011E A\u0002\u0019\fQb]3sS\u0006d\u0017N_3s\r>\u0014H\u0003BA\n\u0007\u0013Dqa!\u000fA\u0001\u0004\u0019Y\r\r\u0003\u0004N\u000eE\u0007\u0003\u0002;|\u0007\u001f\u00042a`Bi\t1\u0019\u0019n!3\u0002\u0002\u0003\u0005)\u0011AA\u0003\u0005\ryF\u0005\u000f\u0015\u0006\u0001\u000em5QV\u0001\rg\u0016\u0014\u0018.\u00197ju\u0016\u0014xJ\u001a\u000b\u0005\u00077\u001ci\u000e\u0005\u0004\u0002 \r=\u00111\u0003\u0005\b\u0007?\f\u0005\u0019\u0001B\t\u00035\u0019XM]5bY&TXM\u001d$R\u001dR111\\Br\u0007ODqa!:C\u0001\u0004\u0011\t\"A\u0006cS:$\u0017N\\4OC6,\u0007bBBp\u0005\u0002\u0007!\u0011C\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\u0014H)\u001a;bS2\u001cXCABw!\u0019\u0011ina<\u0004t&!1\u0011\u001fBp\u0005\r\u0019V-\u001d\t\u0004G\u000eU\u0018bAB|;\n\t2+\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0002%M,'/[1mSj,'\u000fR3uC&d7\u000fI\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148/\u0006\u0002\u0004\u0000B9AO!\u0004\u0003\u0012\u0005M\u0011\u0001D:fe&\fG.\u001b>feN\u0004\u0013\u0001\u00032j]\u0012LgnZ:\u0016\u0005\u0011\u001d\u0001C\u0002Bo\u0007_$I\u0001E\u0002\u0003\"\u000e\t\u0011BY5oI&twm\u001d\u0011\u00029\u0015t7/\u001e:f\u001f:d\u00170\u00117m_^,GmU3sS\u0006d\u0017N_3sgR!A\u0011\u0003C\f!\r9G1C\u0005\u0004\t+A'\u0001B+oSRDq\u0001\"\u0007J\u0001\u0004!Y\"\u0001\u0003ji\u0016\u0014\bC\u0002C\u000f\tO\t\u0019B\u0004\u0003\u0005 \u0011\rbb\u0001<\u0005\"%\t\u0011.C\u0002\u0005&!\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0012%\"b\u0001C\u0013Q\u0006yr/\u0019:o+:,\u0007\u0010]3di\u0016$gj\u001c8BW.\f7+\u001a:jC2L'0\u001a:\u0015\r\u0005\u0005Gq\u0006C\u001e\u0011\u001d\u0019ID\u0013a\u0001\tc\u0001D\u0001b\r\u00058A!Ao\u001fC\u001b!\ryHq\u0007\u0003\r\ts!y#!A\u0001\u0002\u000b\u0005\u0011Q\u0001\u0002\u0005?\u0012\n\u0004\u0007C\u0004\u0005>)\u0003\r!a\u0005\u0002\u0007M,'/A\ndQ\u0016\u001c7nR8pO2,\u0007K]8u_\n,h\r\u0006\u0003\u0002B\u0012\r\u0003b\u0002C#\u0017\u0002\u0007!\u0011C\u0001\nG2\f7o\u001d(b[\u0016\f\u0011c\u00195fG.\f5n[1Qe>$xNY;g)\u0011\t\t\rb\u0013\t\u000f\u0011\u0015C\n1\u0001\u0003\u0012\u0005Q1\r[3dW\u000ec\u0017m]:\u0015\r\u0005\u0005G\u0011\u000bC+\u0011\u001d!\u0019&\u0014a\u0001\u0005#\ta\u0001\u001d:fM&D\bb\u0002C#\u001b\u0002\u0007!\u0011C\u0001\u0005g>\u0014H\u000f\u0006\u0003\u0005\b\u0011m\u0003b\u0002C/\u001d\u0002\u0007AqL\u0001\u0003S:\u0004b\u0001\"\b\u0005b\u0011%\u0011\u0002\u0002C2\tS\u0011\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00199\u0016\u0005\u0011%\u0004\u0003\u0003C6\t[\"\t(a\u0005\u000e\u0005\tE\u0017\u0002\u0002C8\u0005#\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1qa\u0011!\u0019\bb\u001e\u0011\tQ\\HQ\u000f\t\u0004\u007f\u0012]Da\u0003C=!\u0006\u0005\t\u0011!B\u0001\u0003\u000b\u0011Aa\u0018\u00132c\u0005q1/\u001a:jC2L'0\u001a:NCB\u0004\u0013\u0001F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u00180\u0006\u0002\u0005\u0002B9AO!\u0004\u0002 \u0006M\u0011!F:fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u0018\u0010I\u0001\u001acVL7m[*fe&\fG.\u001b>fe\nK\u0018\nZ3oi&$\u00180\u0006\u0002\u0005\nB)qm!\u0006\u0002\u0014\u0005Q\u0012/^5dWN+'/[1mSj,'OQ=JI\u0016tG/\u001b;zA\u0005\tr-\u001a;TKJL\u0017\r\\5{KJ\u0014\u00150\u00133\u0015\t\u0005MA\u0011\u0013\u0005\b\t'+\u0006\u0019AAP\u0003\tIG-A\u0011jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G-\u0001\u0012jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G\rI\u0001!SN<\u0016M\u001d8j]\u001e|eNT8WKJLg-[2bi&|g.\u00128bE2,G-A\u0011jg^\u000b'O\\5oO>sgj\u001c,fe&4\u0017nY1uS>tWI\\1cY\u0016$\u0007%\u0001\u000ejg\u0012K7/\u00197m_^,GMS1wCN+'/[1mSj,'\u000f\u0006\u0003\u0002B\u0012\u0005\u0006bBB?5\u0002\u0007\u00111C\u0001\u001eg\"|W\u000f\u001c3XCJt\u0017IY8vi*\u000bg/Y*fe&\fG.\u001b>feR1\u0011\u0011\u0019CT\tkCq\u0001\"+\\\u0001\u0004!Y+A\btKJL\u0017\r\\5{K\u0012\u001cE.Y:ta\u0011!i\u000b\"-\u0011\tQ\\Hq\u0016\t\u0004\u007f\u0012EF\u0001\u0004CZ\tO\u000b\t\u0011!A\u0003\u0002\u0005\u0015!\u0001B0%cMBqa! \\\u0001\u0004\t\u0019\u0002K\u0002\\\u00037\u0004")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        Object object;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            object = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return (T)object;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(154).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(168).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                object = serializerWithStringManifest.fromBinary(bytes, manifest);
            } else {
                Object object2;
                String string = manifest;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    object2 = serializer.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
                } else {
                    Object object3;
                    Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                    Option option = cache.get((Object)manifest);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Option cachedClassManifest = (Option)some.value();
                        object3 = serializer.fromBinary(bytes, cachedClassManifest);
                    } else if (None$.MODULE$.equals(option)) {
                        Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                        if (!(try_ instanceof Success)) {
                            if (try_ instanceof Failure) {
                                throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                            }
                            throw new MatchError(try_);
                        }
                        Success success = (Success)try_;
                        Class classManifest = (Class)success.value();
                        Some classManifestOption = new Some((Object)classManifest);
                        this.updateCache$1(cache, manifest, (Option)classManifestOption);
                        Object object4 = serializer.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                        object3 = object4;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    object2 = object3;
                }
                object = object2;
            }
            return object;
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("akka.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = (Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Object object2;
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object2 = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object2 = this.deserializeByteArray(bytes, serializer2, manifest);
            }
            object = object2;
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Serializer serializer5;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.bindings().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer5 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                scala.collection.immutable.Seq possibilitiesWithoutJavaSerializer = (scala.collection.immutable.Seq)seq.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Serializer s = (Serializer)tuple2._2();
                        String string = s.getClass().getName();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer5 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer4 = serializer5;
            Serializer serializer6 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer6 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonAkkaSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                serializer3 = ser;
            } else {
                serializer3 = serializer6;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this, fqn, bindingName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            public final String fqn$1;
            public final String bindingName$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$serializerOf$1 $outer;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Try<T> try_;
                        A1 A1 = x1;
                        if (A1 instanceof NoSuchMethodException) {
                            NoSuchMethodException noSuchMethodException = (NoSuchMethodException)A1;
                            String string = this.$outer.bindingName$1;
                            String string2 = "";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                throw noSuchMethodException;
                            }
                            try_ = this.$outer.akka$serialization$Serialization$$anonfun$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.$outer.akka$serialization$Serialization$$anonfun$$$outer().system()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), (Object)this.$outer.bindingName$1), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class));
                        } else {
                            try_ = function1.apply(x1);
                        }
                        return (B1)try_;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof NoSuchMethodException;
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException;
                return bl;
            }

            public /* synthetic */ Serialization akka$serialization$Serialization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
                this.bindingName$1 = bindingName$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0 & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean warnUnexpectedNonAkkaSerializer(Class<?> clazz, Serializer ser) {
        boolean bl;
        if (clazz.getName().startsWith("akka.") && !ser.getClass().getName().startsWith("akka.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Akka. It's not recommended to replace serializers for messages provided by Akka.", ser.getClass().getName(), clazz.getName());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkAkkaProtobuf(String className) {
        return this.checkClass("akka.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return (scala.collection.immutable.Seq)((TraversableLike)in.foldLeft((Object)new ArrayBuffer(in.size()), (Function2 & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF(Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(scala.collection.immutable.Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(scala.collection.immutable.Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 != null && tuple2._2() instanceof JavaSerializer ? false : tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string;
        String string2;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string2 = className;
                if (alias != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string3 = string = alias;
        String string4 = "none";
        boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string2) && $this.checkAkkaProtobuf(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class clazz = (Class)tuple2._1();
        Serializer ser = (Serializer)tuple2._2();
        boolean bl = $this.warnUnexpectedNonAkkaSerializer(clazz, ser);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (scala.collection.immutable.Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (scala.collection.immutable.Seq)vector.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x1;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            String string;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = v;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string, string2).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Map result = fromConfig.$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result.iterator().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        this.serializers = result;
        scala.collection.immutable.Iterable fromConfig2 = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            String string;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string = className;
                    if (alias != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1 & Serializable & scala.Serializable)detail -> (scala.collection.immutable.Seq)detail.useFor().map((Function1 & Serializable & scala.Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)result2.iterator().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }));
        result2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = (ConcurrentHashMap)this.bindings().foldLeft(new ConcurrentHashMap(), (Function2 & Serializable & scala.Serializable)(x0$4, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$4, x1$1);
                    if (tuple22 == null) break block2;
                    map = (ConcurrentHashMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            ConcurrentHashMap concurrentHashMap = map;
            return concurrentHashMap;
        });
        this.serializerByIdentity = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus((GenTraversableOnce)this.serializers().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom()));
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)package$JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config bindings = config.getConfig("akka.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

