/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.access.playframework;

import java.util.concurrent.CompletionStage;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.datastructure.AccessRequest;
import jayeson.lib.access.datastructure.LoginData;
import jayeson.lib.access.datastructure.LogoutData;
import jayeson.lib.access.playframework.AccessRequestAttrs;
import jayeson.lib.access.playframework.TokenAccessRequest;
import jayeson.lib.session.AsyncSessionAccessor;
import play.libs.typedmap.TypedKey;
import play.mvc.Http;

public class AccessChecker {
    protected Http.Request request;

    public AccessChecker(Http.Request req) {
        this.request = req;
    }

    public boolean isLoggedInSuccessful() {
        LoginData ld = this.getAttr(AccessRequestAttrs.LOGIN_DATA);
        if (ld == null) {
            return false;
        }
        return ld.isSuccessful();
    }

    public String getLoginMessage() {
        LoginData ld = this.getAttr(AccessRequestAttrs.LOGIN_DATA);
        if (ld == null) {
            return "Unable to find login data to extract login message.";
        }
        return ld.getLoginMessage();
    }

    public TokenAccessRequest getAccessRequest() {
        AccessRequest o = this.getAttr(AccessRequestAttrs.ACCESS_REQUEST);
        if (o instanceof TokenAccessRequest) {
            return (TokenAccessRequest)o;
        }
        return null;
    }

    public boolean isLoggedOutSuccessful() {
        LogoutData ld = this.getAttr(AccessRequestAttrs.LOGOUT_DATA);
        if (ld == null) {
            return false;
        }
        return ld.isSuccessful();
    }

    public String getLogoutMessage() {
        LogoutData ld = this.getAttr(AccessRequestAttrs.LOGOUT_DATA);
        if (ld == null) {
            return "Unable to find logout data to build logout message.";
        }
        return ld.getLogoutMessage();
    }

    public CompletionStage<AsyncSessionAccessor> getAsyncLoginSession() {
        AccessManager o = this.getAttr(AccessRequestAttrs.ACCESS_MANAGER);
        if (o != null) {
            return o.getLoginSession((AccessRequest)this.getAccessRequest());
        }
        return null;
    }

    public AccessManager getAccessManager() {
        AccessManager o = this.getAttr(AccessRequestAttrs.ACCESS_MANAGER);
        if (o != null) {
            return o;
        }
        throw new RuntimeException("AccessManager isn't defined. Make sure you have annotated your controller with DoLogin or RequireLogin");
    }

    public String getReturnUrl() {
        return this.getAttr(AccessRequestAttrs.RETURN_URL);
    }

    private <T> T getAttr(TypedKey<T> key) {
        return this.request.attrs().getOptional(key).orElse(null);
    }
}

