/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.access.playframework;

import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.AccessManagerFactory;
import jayeson.lib.access.datastructure.AccessRequest;
import jayeson.lib.access.datastructure.LoginData;
import jayeson.lib.access.playframework.AccessRequestAttrs;
import jayeson.lib.access.playframework.DataMethod;
import jayeson.lib.access.playframework.PlayAccessRequestBuilder;
import jayeson.lib.access.playframework.TokenAccessRequest;
import jayeson.lib.access.playframework.annotation.DoLogin;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

public class ActionDoLogin
extends Action<DoLogin> {
    private PlayAccessRequestBuilder requestBuilder;
    AccessManagerFactory amFactory;

    @Inject
    public ActionDoLogin(PlayAccessRequestBuilder requestBuilder, AccessManagerFactory factory) {
        this.amFactory = factory;
        this.requestBuilder = requestBuilder;
    }

    Result writeSession(Http.Request req, Result r, TokenAccessRequest ar, LoginData ld) {
        r = r.addingToSession(req, "_u", ld.getUserData().getUsername()).addingToSession(req, "_at", ld.getAccessToken()).addingToSession(req, "_to", String.valueOf(ld.getTimeout()));
        if (ar.getSessionID() != null) {
            r = r.addingToSession(req, "_sid", ar.getSessionID());
        }
        return r;
    }

    String getReturnUrl(DoLogin configuration, Http.Request req, TokenAccessRequest ar) {
        if (configuration.returnUrl() != null && !configuration.returnUrl().equals("")) {
            return configuration.returnUrl();
        }
        switch (configuration.lastUrlRememberMethod()) {
            case COOKIE: {
                Optional encodedUrl = req.session().getOptional(AccessRequestAttrs.RETURN_URL.toString());
                if (!encodedUrl.isPresent()) break;
                try {
                    return new String(Base64.getDecoder().decode((String)encodedUrl.get()), "UTF8");
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case FORM: {
                if (ar.getReturnUrl() == null) break;
                try {
                    return new String(Base64.getDecoder().decode(ar.getReturnUrl()), "UTF8");
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    public CompletionStage<Result> call(Http.Request req) {
        System.out.println("Doing login");
        AccessManager am = null;
        am = ((DoLogin)this.configuration).amName().equals("") ? this.amFactory.getAM() : this.amFactory.getAM(((DoLogin)this.configuration).amName());
        req = req.addAttr(AccessRequestAttrs.ACCESS_MANAGER, (Object)am);
        this.requestBuilder.setRequest(req);
        this.requestBuilder.setDataMethod(((DoLogin)this.configuration).credentialSource());
        TokenAccessRequest ar = this.requestBuilder.build(am);
        if (ar == null) {
            req = req.addAttr(AccessRequestAttrs.LOGIN_DATA, null);
            System.out.println("Cannot build access request");
            return this.delegate.call(req);
        }
        req = ar.getPlayHttpRequest();
        ar.setRequestedTimeout(-1L);
        if (((DoLogin)this.configuration).allowRememberMe() && ar.isRememberMe()) {
            ar.setRequestedTimeout(((DoLogin)this.configuration).rememberMeDuration());
        }
        Http.Request oldReq = req;
        return am.login((AccessRequest)ar).thenComposeAsync(ld -> {
            Http.Request newRequest = oldReq.addAttr(AccessRequestAttrs.LOGIN_DATA, ld);
            if (ld.isSuccessful()) {
                String returnUrl = this.getReturnUrl((DoLogin)this.configuration, newRequest, ar);
                CompletableFuture<Result> result = returnUrl != null && ((DoLogin)this.configuration).autoReturn() ? CompletableFuture.completedFuture(ActionDoLogin.redirect((String)returnUrl)) : this.delegate.call(newRequest.addAttr(AccessRequestAttrs.RETURN_URL, (Object)returnUrl));
                return result.thenApply(r -> {
                    if (((DoLogin)this.configuration).storeCookie()) {
                        r = this.writeSession(newRequest, (Result)r, ar, (LoginData)ld);
                    }
                    if (returnUrl != null && ((DoLogin)this.configuration).lastUrlRememberMethod() == DataMethod.COOKIE) {
                        return r.removingFromSession(newRequest, new String[]{AccessRequestAttrs.RETURN_URL.toString()});
                    }
                    return r;
                });
            }
            return this.delegate.call(newRequest);
        });
    }

    @Inject
    public void setAmFactory(AccessManagerFactory amFactory) {
        this.amFactory = amFactory;
    }
}

