/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.access.playframework;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.AccessManagerFactory;
import jayeson.lib.access.datastructure.AccessRequest;
import jayeson.lib.access.playframework.AccessRequestAttrs;
import jayeson.lib.access.playframework.PlayAccessRequestBuilder;
import jayeson.lib.access.playframework.TokenAccessRequest;
import jayeson.lib.access.playframework.annotation.DoLogout;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

public class ActionDoLogout
extends Action<DoLogout> {
    private PlayAccessRequestBuilder requestBuilder;
    AccessManagerFactory amFactory;

    @Inject
    public ActionDoLogout(PlayAccessRequestBuilder requestBuilder, AccessManagerFactory factory) {
        this.amFactory = factory;
        this.requestBuilder = requestBuilder;
    }

    private Result removeSession(Http.Request req, Result res) {
        return res.removingFromSession(req, new String[]{"_u", "_at", "_to", "_sid"});
    }

    public CompletionStage<Result> call(Http.Request req) {
        AccessManager am = this.amFactory.getAM();
        this.requestBuilder.setRequest(req);
        this.requestBuilder.setDataMethod(((DoLogout)this.configuration).credentialSource());
        TokenAccessRequest ar = this.requestBuilder.build(am);
        Http.Request oldRequest = ar == null ? req : ar.getPlayHttpRequest();
        return am.logout((AccessRequest)ar).thenComposeAsync(ld -> {
            Http.Request newRequest = oldRequest.addAttr(AccessRequestAttrs.LOGOUT_DATA, ld);
            if (ld.isSuccessful()) {
                CompletableFuture<Result> result = ((DoLogout)this.configuration).autoAnswer() ? (((DoLogout)this.configuration).returnUrl() != null && ((DoLogout)this.configuration).returnUrl().length() > 0 ? CompletableFuture.completedFuture(ActionDoLogout.redirect((String)((DoLogout)this.configuration).returnUrl())) : CompletableFuture.completedFuture(ActionDoLogout.ok((String)((DoLogout)this.configuration).successMessage()))) : this.delegate.call(newRequest);
                return result.thenApply(r -> this.removeSession(newRequest, (Result)r));
            }
            if (((DoLogout)this.configuration).autoAnswer()) {
                return CompletableFuture.completedFuture(ActionDoLogout.ok((String)((DoLogout)this.configuration).failMessage()));
            }
            return this.delegate.call(newRequest);
        });
    }

    @Inject
    public void setAmFactory(AccessManagerFactory amFactory) {
        this.amFactory = amFactory;
    }
}

