/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.access.playframework;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.AccessManagerFactory;
import jayeson.lib.access.datastructure.AccessRequest;
import jayeson.lib.access.playframework.AccessRequestAttrs;
import jayeson.lib.access.playframework.PlayAccessRequestBuilder;
import jayeson.lib.access.playframework.TokenAccessRequest;
import jayeson.lib.access.playframework.annotation.PassThroughUnauthorizedAccessHandler;
import jayeson.lib.access.playframework.annotation.RequireLogin;
import jayeson.lib.access.playframework.annotation.UnauthorizedAccessHandler;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;

public class ActionRequireLogin
extends Action<RequireLogin> {
    private PlayAccessRequestBuilder requestBuilder;
    AccessManagerFactory amFactory;

    @Inject
    public ActionRequireLogin(PlayAccessRequestBuilder requestBuilder, AccessManagerFactory factory) {
        this.amFactory = factory;
        this.requestBuilder = requestBuilder;
    }

    private AccessManager getAccessManager() {
        if (((RequireLogin)this.configuration).amName().equals("")) {
            return this.amFactory.getAM();
        }
        return this.amFactory.getAM(((RequireLogin)this.configuration).amName());
    }

    public CompletionStage<Result> call(Http.Request req) {
        AccessManager am = this.getAccessManager();
        this.requestBuilder.setRequest(req);
        this.requestBuilder.setDataMethod(((RequireLogin)this.configuration).credentialSource());
        TokenAccessRequest ar = this.requestBuilder.build(am);
        if (ar == null) {
            return this.unauthorizedAccessHandler(req, (RequireLogin)this.configuration);
        }
        Http.Request oldRequest = ar.getPlayHttpRequest().addAttr(AccessRequestAttrs.ACCESS_MANAGER, (Object)am);
        return am.isLoggedIn((AccessRequest)ar).thenComposeAsync(loggedIn -> {
            if (loggedIn.booleanValue()) {
                if (((RequireLogin)this.configuration).autoRenew()) {
                    ar.setRequestedTimeout(((RequireLogin)this.configuration).renewDurationConfig());
                    am.renewLogin((AccessRequest)ar);
                }
                return this.delegate.call(oldRequest);
            }
            return this.unauthorizedAccessHandler(oldRequest, (RequireLogin)this.configuration);
        });
    }

    private CompletionStage<Result> unauthorizedAccessHandler(Http.Request req, RequireLogin config) {
        try {
            Class<? extends UnauthorizedAccessHandler> c = ((RequireLogin)this.configuration).unauthAccessHandler();
            if (c == PassThroughUnauthorizedAccessHandler.class) {
                return this.delegate.call(req);
            }
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).handleUnauthorizedAccess(req, config);
        }
        catch (Exception ex) {
            CompletableFuture<Result> future = new CompletableFuture<Result>();
            future.complete(ActionRequireLogin.badRequest((String)"Interval error"));
            return future;
        }
    }

    @Inject
    public void setAmFactory(AccessManagerFactory amFactory) {
        this.amFactory = amFactory;
    }
}

