/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.access.playframework;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import jayeson.lib.access.AccessManager;
import jayeson.lib.access.AccessRequestBuilder;
import jayeson.lib.access.basic.BasicAccessManager;
import jayeson.lib.access.basic.SessionAccessManager;
import jayeson.lib.access.playframework.AccessRequestAttrs;
import jayeson.lib.access.playframework.DataMethod;
import jayeson.lib.access.playframework.TokenAccessRequest;
import play.Logger;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Lang;
import play.libs.typedmap.TypedEntry;
import play.libs.typedmap.TypedKey;
import play.libs.typedmap.TypedMap;
import play.mvc.Http;

public class PlayAccessRequestBuilder
implements AccessRequestBuilder {
    private static Logger.ALogger logger = Logger.of(PlayAccessRequestBuilder.class);
    protected DataMethod dataMethod;
    protected Http.Request req;
    private FormFactory formFactory;

    @Inject
    public PlayAccessRequestBuilder(FormFactory formFactory) {
        this.setDataMethod(DataMethod.FORM);
        this.formFactory = formFactory;
    }

    public TokenAccessRequest build(AccessManager am) {
        TokenAccessRequest r;
        if (!(am instanceof BasicAccessManager)) {
            logger.error("Can't recognize am's type");
            return null;
        }
        TokenAccessRequest request = r = new TokenAccessRequest();
        Http.Session sess = this.req.session();
        switch (this.dataMethod) {
            case FORM: {
                Form form = this.formFactory.form(request.getClass());
                logger.info("class name {}", new Object[]{request.getClass()});
                form = form.bindFromRequest(this.req, new String[0]);
                if (form.hasErrors() && form.rawData().isEmpty()) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    this.fillDataWith(data, this.req.queryString());
                    logger.info("built form from query string {}", new Object[]{data});
                    form = this.formFactory.form(request.getClass()).bind(Lang.defaultLang(), this.buildTypedMap(data), data, new String[0]);
                }
                if (form.hasErrors() || !form.value().isPresent()) {
                    logger.info("Access request is not correct! Form error: " + form.errorsAsJson().toString());
                    return null;
                }
                request = (TokenAccessRequest)form.get();
                logger.info("received form {}", new Object[]{request});
                this.req = this.req.addAttr(AccessRequestAttrs.ACCESS_FORM, (Object)form);
                break;
            }
            case HEADER: {
                if (!this.req.hasHeader("X-Username")) {
                    logger.error("Missing username header");
                    return null;
                }
                if (!this.req.hasHeader("X-AccessToken")) {
                    logger.error("Missing access token header");
                    return null;
                }
                if (this.req.header("X-SessionId").isPresent()) {
                    request.setSessionID((String)this.req.header("X-SessionId").get());
                }
                request.setUsername((String)this.req.getHeaders().get("X-Username").get());
                request.setAccessToken((String)this.req.getHeaders().get("X-AccessToken").get());
                break;
            }
            case COOKIE: {
                Optional cookie_username = sess.getOptional("_u");
                Optional cookie_password = sess.getOptional("_at");
                Optional cookie_sessId = sess.getOptional("_sid");
                if (!cookie_username.isPresent() || !cookie_password.isPresent()) {
                    logger.error("Missing information in cookie COOKIE_USERNAME={} COOKIE_ACCESS_TOKEN={} session={}", new Object[]{"_u", "_at", sess});
                    return null;
                }
                request.setUsername((String)cookie_username.get());
                request.setAccessToken((String)cookie_password.get());
                if (!cookie_sessId.isPresent()) break;
                request.setSessionID((String)cookie_sessId.get());
                break;
            }
            case JSON: {
                Http.RequestBody body = this.req.body();
                JsonNode node = body.asJson();
                if (!node.has("username") || !node.has("password") && !node.has("accessToken")) {
                    logger.error("Missing information from JSON request: ", new Object[]{node.toString()});
                    return null;
                }
                request.setUsername(node.get("username").asText());
                if (node.has("accessToken")) {
                    request.setAccessToken(node.get("accessToken").asText());
                } else if (node.has("password")) {
                    request.setAccessToken(node.get("password").asText());
                }
                if (!node.has("sessionId")) break;
                request.setSessionID(node.get("sessionId").asText());
            }
        }
        if (am instanceof SessionAccessManager && (request.getSessionID() == null || request.getSessionID().isEmpty())) {
            request.setSessionID(this.getSessionID());
        }
        this.req = this.req.addAttr(AccessRequestAttrs.ACCESS_REQUEST, (Object)request);
        System.out.println("Store access request with session id: " + request.getSessionID());
        request.setPlayHttpRequest(this.req);
        return request;
    }

    private void fillDataWith(Map<String, String> data, Map<String, String[]> urlFormEncoded) {
        urlFormEncoded.forEach((key, values) -> {
            if (key.endsWith("[]")) {
                String k = key.substring(0, key.length() - 2);
                for (int i = 0; i < ((String[])values).length; ++i) {
                    data.put(k + "[" + i + "]", values[i]);
                }
            } else if (((String[])values).length > 0) {
                data.put((String)key, values[0]);
            }
        });
    }

    protected String getSessionID() {
        return UUID.randomUUID().toString();
    }

    public void setDataMethod(DataMethod dataMethod) {
        this.dataMethod = dataMethod;
    }

    public void setRequest(Http.Request req) {
        this.req = req;
    }

    private TypedMap buildTypedMap(Map<String, String> data) {
        if (data.isEmpty()) {
            return TypedMap.empty();
        }
        TypedEntry[] entries = new TypedEntry[data.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            logger.info("creating typedKey {}-{}", new Object[]{entry.getKey(), entry.getValue()});
            entries[i++] = new TypedEntry(TypedKey.create((String)entry.getKey()), (Object)entry.getValue());
        }
        return TypedMap.create((TypedEntry[])entries);
    }
}

