/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.access.playframework.annotation;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import jayeson.lib.access.playframework.AccessRequestAttrs;
import jayeson.lib.access.playframework.annotation.RequireLogin;
import jayeson.lib.access.playframework.annotation.UnauthorizedAccessHandler;
import play.Logger;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

public class DefaultUnauthorizedAccessHandler
implements UnauthorizedAccessHandler {
    private static final Logger.ALogger logger = Logger.of(DefaultUnauthorizedAccessHandler.class);

    @Override
    public CompletionStage<Result> handleUnauthorizedAccess(Http.Request req, RequireLogin configuration) {
        if (configuration.loginPage() == null || configuration.loginPage().equals("")) {
            return CompletableFuture.completedFuture(Results.unauthorized((String)configuration.unauthorizationMessage()));
        }
        String redirectionUrl = configuration.loginPage();
        if (configuration.rememberLastUrl()) {
            String encodedUrl = null;
            try {
                encodedUrl = new String(Base64.getEncoder().encode(req.uri().getBytes("UTF8")));
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Cannot encode the return url " + req.uri(), (Throwable)e);
            }
            if (encodedUrl != null) {
                switch (configuration.rememberMethod()) {
                    case COOKIE: {
                        return CompletableFuture.completedFuture(Results.redirect((String)redirectionUrl).addingToSession(req, AccessRequestAttrs.RETURN_URL.toString(), encodedUrl));
                    }
                    case FORM: {
                        redirectionUrl = redirectionUrl.contains("?") ? redirectionUrl + "&" : redirectionUrl + "?";
                        redirectionUrl = redirectionUrl + AccessRequestAttrs.RETURN_URL.toString() + "=" + encodedUrl;
                        return CompletableFuture.completedFuture(Results.redirect((String)redirectionUrl));
                    }
                }
            }
        }
        return CompletableFuture.completedFuture(Results.redirect((String)redirectionUrl));
    }
}

