/*
 * Decompiled with CFR 0.152.
 */
package play;

import com.typesafe.config.Config;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import play.Application;
import play.Environment;
import play.api.ApplicationLoader;
import play.api.ApplicationLoader$;
import play.api.ApplicationLoader$Context$;
import play.api.Configuration;
import play.api.inject.DefaultApplicationLifecycle;
import play.core.SourceMapper;
import play.inject.ApplicationLifecycle;
import play.libs.Scala;
import scala.Option;
import scala.compat.java8.OptionConverters;

public interface ApplicationLoader {
    public static ApplicationLoader apply(Context context) {
        final play.api.ApplicationLoader applicationLoader = ApplicationLoader$.MODULE$.apply(context.asScala());
        return new ApplicationLoader(){

            @Override
            public Application load(Context context) {
                return applicationLoader.load(context.asScala()).asJava();
            }
        };
    }

    public Application load(Context var1);

    public static Context create(Environment environment, Map<String, Object> map2) {
        ApplicationLoader.Context context = ApplicationLoader$Context$.MODULE$.create(environment.asScala(), Scala.asScala(map2), new DefaultApplicationLifecycle(), Scala.None());
        return new Context(context);
    }

    public static Context create(Environment environment) {
        return ApplicationLoader.create(environment, Collections.emptyMap());
    }

    public static final class Context {
        private final ApplicationLoader.Context underlying;

        public Context(ApplicationLoader.Context context) {
            this.underlying = context;
        }

        public Context(Environment environment) {
            this(environment, new HashMap<String, Object>());
        }

        public Context(Environment environment, Map<String, Object> map2) {
            this.underlying = new ApplicationLoader.Context(environment.asScala(), Configuration.load(environment.asScala(), Scala.asScala(map2)), new DefaultApplicationLifecycle(), (Option<ApplicationLoader.DevContext>)Option.empty());
        }

        public ApplicationLoader.Context asScala() {
            return this.underlying;
        }

        public Environment environment() {
            return new Environment(this.underlying.environment());
        }

        public Config initialConfig() {
            return this.underlying.initialConfiguration().underlying();
        }

        public ApplicationLifecycle applicationLifecycle() {
            return this.underlying.lifecycle().asJava();
        }

        public Optional<ApplicationLoader.DevContext> devContext() {
            return OptionConverters.toJava(this.underlying.devContext());
        }

        @Deprecated
        public Optional<SourceMapper> sourceMapper() {
            return this.devContext().map(ApplicationLoader.DevContext::sourceMapper);
        }

        public Context withEnvironment(Environment environment) {
            ApplicationLoader.Context context = new ApplicationLoader.Context(environment.asScala(), this.underlying.initialConfiguration(), new DefaultApplicationLifecycle(), this.underlying.devContext());
            return new Context(context);
        }

        public Context withConfig(Config config) {
            ApplicationLoader.Context context = new ApplicationLoader.Context(this.underlying.environment(), new Configuration(config), new DefaultApplicationLifecycle(), this.underlying.devContext());
            return new Context(context);
        }
    }
}

